/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.TypeIdEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.UnknownTypeException;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsGoalRestrOf;
import de.uni_koblenz.jgralab.greql.schema.IsStartRestrOf;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

public abstract class PathDescriptionEvaluator<V extends PathDescription>
extends VertexEvaluator<V> {
    public PathDescriptionEvaluator(V vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    public NFA getNFA(InternalGreqlEvaluator evaluator) {
        NFA createdNFA = (NFA)evaluator.getLocalAutomaton(this.vertex);
        if (createdNFA == null) {
            createdNFA = (NFA)this.getResult(evaluator);
            evaluator.setLocalAutomaton(this.vertex, createdNFA);
        }
        return createdNFA;
    }

    @Override
    public Object getResult(InternalGreqlEvaluator evaluator) {
        NFA createdNFA = (NFA)evaluator.getLocalAutomaton(this.vertex);
        if (createdNFA == null) {
            Object result = this.evaluate(evaluator);
            createdNFA = (NFA)result;
            evaluator.setLocalAutomaton(this.vertex, createdNFA);
            this.addGoalRestrictions(evaluator);
            this.addStartRestrictions(evaluator);
        }
        if (evaluator.getLocalEvaluationResult(this.vertex) == null) {
            evaluator.setLocalEvaluationResult(this.vertex, createdNFA);
        }
        return evaluator.getLocalEvaluationResult(this.vertex);
    }

    protected void addGoalRestrictions(InternalGreqlEvaluator evaluator) {
        PathDescription pathDesc = (PathDescription)this.getVertex();
        VertexEvaluator<Expression> goalRestEval = null;
        IsGoalRestrOf inc = pathDesc.getFirstIsGoalRestrOfIncidence(EdgeDirection.IN);
        if (inc == null) {
            return;
        }
        TypeCollection typeCollection = TypeCollection.empty();
        while (inc != null) {
            VertexEvaluator<Expression> vertexEval = this.query.getVertexEvaluator(inc.getAlpha());
            if (vertexEval instanceof TypeIdEvaluator) {
                TypeIdEvaluator typeEval = (TypeIdEvaluator)vertexEval;
                typeCollection = typeCollection.combine((TypeCollection)typeEval.getResult(evaluator));
            } else {
                goalRestEval = vertexEval;
            }
            inc = inc.getNextIsGoalRestrOfIncidence(EdgeDirection.IN);
        }
        try {
            typeCollection = typeCollection.bindToSchema(evaluator);
        }
        catch (UnknownTypeException e) {
            throw new UnknownTypeException(e.getTypeName(), this.createPossibleSourcePositions());
        }
        NFA.addGoalTypeRestriction(this.getNFA(evaluator), typeCollection);
        if (goalRestEval != null) {
            NFA.addGoalBooleanRestriction(this.getNFA(evaluator), goalRestEval, this.query);
        }
    }

    protected void addStartRestrictions(InternalGreqlEvaluator evaluator) {
        PathDescription pathDesc = (PathDescription)this.getVertex();
        VertexEvaluator<Expression> startRestEval = null;
        IsStartRestrOf inc = pathDesc.getFirstIsStartRestrOfIncidence(EdgeDirection.IN);
        if (inc == null) {
            return;
        }
        TypeCollection typeCollection = TypeCollection.empty();
        while (inc != null) {
            VertexEvaluator<Expression> vertexEval = this.query.getVertexEvaluator(inc.getAlpha());
            if (vertexEval instanceof TypeIdEvaluator) {
                TypeIdEvaluator typeEval = (TypeIdEvaluator)vertexEval;
                typeCollection = typeCollection.combine((TypeCollection)typeEval.getResult(evaluator));
            } else {
                startRestEval = vertexEval;
            }
            inc = inc.getNextIsStartRestrOfIncidence(EdgeDirection.IN);
        }
        try {
            typeCollection = typeCollection.bindToSchema(evaluator);
        }
        catch (UnknownTypeException e) {
            throw new UnknownTypeException(e.getTypeName(), this.createPossibleSourcePositions());
        }
        NFA.addStartTypeRestriction(this.getNFA(evaluator), typeCollection);
        if (startRestEval != null) {
            NFA.addStartBooleanRestriction(this.getNFA(evaluator), startRestEval, this.query);
        }
    }
}

