/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IntermediateVertexPathDescription;
import de.uni_koblenz.jgralab.greql.schema.IsSubPathOf;

public class IntermediateVertexPathDescriptionEvaluator
extends PathDescriptionEvaluator<IntermediateVertexPathDescription> {
    public IntermediateVertexPathDescriptionEvaluator(IntermediateVertexPathDescription vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public NFA evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        IsSubPathOf inc = ((IntermediateVertexPathDescription)this.vertex).getFirstIsSubPathOfIncidence(EdgeDirection.IN);
        PathDescriptionEvaluator firstEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
        NFA firstNFA = firstEval.getNFA(evaluator);
        inc = inc.getNextIsSubPathOfIncidence(EdgeDirection.IN);
        PathDescriptionEvaluator secondEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
        NFA secondNFA = secondEval.getNFA(evaluator);
        VertexEvaluator<Expression> vertexEval = this.query.getVertexEvaluator(((IntermediateVertexPathDescription)this.vertex).getFirstIsIntermediateVertexOfIncidence(EdgeDirection.IN).getAlpha());
        return NFA.createIntermediateVertexPathDescriptionNFA(firstNFA, vertexEval, secondNFA);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        IntermediateVertexPathDescription pathDesc = (IntermediateVertexPathDescription)this.getVertex();
        IsSubPathOf inc = pathDesc.getFirstIsSubPathOfIncidence();
        PathDescriptionEvaluator firstPathEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
        inc = inc.getNextIsSubPathOfIncidence();
        PathDescriptionEvaluator secondPathEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
        long firstCosts = firstPathEval.getCurrentSubtreeEvaluationCosts();
        long secondCosts = secondPathEval.getCurrentSubtreeEvaluationCosts();
        VertexEvaluator<Expression> vertexEval = this.query.getVertexEvaluator(pathDesc.getFirstIsIntermediateVertexOfIncidence().getAlpha());
        long intermVertexCosts = vertexEval.getCurrentSubtreeEvaluationCosts();
        long ownCosts = 10L;
        long iteratedCosts = 10L;
        long subtreeCosts = iteratedCosts + intermVertexCosts + firstCosts + secondCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }
}

