/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.schema.AlternativePathDescription;
import de.uni_koblenz.jgralab.greql.schema.IsAlternativePathOf;
import java.util.ArrayList;

public class AlternativePathDescriptionEvaluator
extends PathDescriptionEvaluator<AlternativePathDescription> {
    public AlternativePathDescriptionEvaluator(AlternativePathDescription vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public NFA evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        ArrayList<NFA> nfaList = new ArrayList<NFA>();
        for (IsAlternativePathOf inc = ((AlternativePathDescription)this.vertex).getFirstIsAlternativePathOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsAlternativePathOfIncidence(EdgeDirection.IN)) {
            PathDescriptionEvaluator pathEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
            nfaList.add(pathEval.getNFA(evaluator));
        }
        return NFA.createAlternativePathDescriptionNFA(nfaList);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        AlternativePathDescription p = (AlternativePathDescription)this.getVertex();
        long aggregatedCosts = 0L;
        IsAlternativePathOf inc = p.getFirstIsAlternativePathOfIncidence(EdgeDirection.IN);
        long alternatives = 0L;
        while (inc != null) {
            PathDescriptionEvaluator pathEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
            aggregatedCosts += pathEval.getCurrentSubtreeEvaluationCosts();
            inc = inc.getNextIsAlternativePathOfIncidence(EdgeDirection.IN);
            ++alternatives;
        }
        return new VertexCosts(10L * alternatives, 10L * alternatives, aggregatedCosts += 10L * alternatives);
    }
}

