/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.fa;

import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class FiniteAutomaton {
    private static Logger logger = Logger.getLogger(FiniteAutomaton.class.getPackage().getName());
    public State initialState;
    public ArrayList<State> finalStates = new ArrayList();
    public ArrayList<State> stateList = new ArrayList();
    public ArrayList<Transition> transitionList = new ArrayList();

    public abstract DFA getDFA();

    public void printAscii() {
        logger.info("|||||||||||||||||||||||  Automaton: |||||||||||||||||||||||||");
        for (State currentState : this.stateList) {
            logger.info("[" + this.stateList.indexOf(currentState) + "]");
            for (Transition currentTransition : currentState.outTransitions) {
                int stateNumber = this.stateList.indexOf(currentTransition.endState);
                if (this.finalStates.contains(currentTransition.endState)) {
                    logger.info("      ----" + currentTransition.edgeString() + "--->    [[" + stateNumber + "]]");
                    continue;
                }
                logger.info("      ----" + currentTransition.edgeString() + "--->    [" + stateNumber + "]");
            }
            logger.info("\n--------------------------");
        }
        logger.info("||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| ");
    }

    public void printAscii2() {
        for (State currentState : this.stateList) {
            if (currentState.isFinal) {
                System.out.println("State: [[" + currentState.number + "]]");
            } else {
                System.out.println("State: [" + currentState.number + "]");
            }
            for (Transition currentTransition : currentState.outTransitions) {
                int stateNumber = currentTransition.endState.number;
                if (this.finalStates.contains(currentTransition.endState)) {
                    System.out.println("      ----" + currentTransition.edgeString() + "--->    [[" + stateNumber + "]]");
                    continue;
                }
                System.out.println("      ----" + currentTransition.edgeString() + "--->    [" + stateNumber + "]");
            }
            System.out.println("\n--------------------------");
        }
    }

    public boolean isFinal(State s) {
        return this.finalStates.contains(s);
    }

    protected void updateStateAttributes() {
        Iterator<State> iter = this.stateList.iterator();
        int i = 0;
        while (iter.hasNext()) {
            State s = iter.next();
            s.isFinal = false;
            s.number = i++;
        }
        iter = this.finalStates.iterator();
        while (iter.hasNext()) {
            iter.next().isFinal = true;
        }
    }
}

