/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.fa;

import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import java.util.ArrayList;
import java.util.Iterator;

public class DFAState
extends State {
    private ArrayList<State> neaStates = new ArrayList();

    public DFAState(State s) {
        ArrayList<Transition> newTransitions = new ArrayList<Transition>();
        for (Transition t : s.outTransitions) {
            Transition t2 = t.copy(false);
            newTransitions.add(t2);
        }
        for (Transition newTransition : newTransitions) {
            newTransition.setStartState(this);
            newTransition.setEndState(newTransition.endState);
        }
    }

    public ArrayList<Transition> addRepresentedState(State s) {
        if (this.neaStates.contains(s)) {
            return new ArrayList<Transition>();
        }
        this.neaStates.add(s);
        ArrayList<Transition> oldTransList = new ArrayList<Transition>();
        ArrayList<Transition> newTransList = new ArrayList<Transition>();
        oldTransList.addAll(s.outTransitions);
        Iterator transitionIter = oldTransList.iterator();
        while (transitionIter.hasNext()) {
            Transition t = ((Transition)transitionIter.next()).copy(true);
            t.setStartState(this);
            newTransList.add(t);
        }
        return newTransList;
    }

    public boolean representSameNFAStates(DFAState s) {
        if (this.neaStates.size() != s.neaStates.size()) {
            return false;
        }
        Iterator<State> iter = s.neaStates.iterator();
        while (iter.hasNext()) {
            if (this.neaStates.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsFinalStateOfNFA(NFA nfa) {
        Iterator<State> stateIter = this.neaStates.iterator();
        while (stateIter.hasNext()) {
            if (!nfa.finalStates.contains(stateIter.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsState(State s) {
        return this.neaStates.contains(s);
    }
}

