/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.fa;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.ThisEdgeEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.ThisEdge;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.util.Set;

public class AggregationTransition
extends Transition {
    private final VertexEvaluator<? extends Expression> predicateEvaluator;
    private ThisEdgeEvaluator thisEdgeEvaluator;
    protected TypeCollection typeCollection;
    protected Set<String> validToEdgeRoles;
    protected Set<String> validFromEdgeRoles;
    protected boolean aggregateFrom;

    public VertexEvaluator<? extends Expression> getPredicateEvaluator() {
        return this.predicateEvaluator;
    }

    public TypeCollection getTypeCollection() {
        return this.typeCollection;
    }

    public Set<String> getValidToRoles() {
        return this.validToEdgeRoles;
    }

    public Set<String> getValidFromRoles() {
        return this.validFromEdgeRoles;
    }

    public boolean isAggregateFrom() {
        return this.aggregateFrom;
    }

    @Override
    public String edgeString() {
        String desc = "AggregationTransition (aggregateFrom:" + this.aggregateFrom;
        if (this.typeCollection != null) {
            desc = desc + "\n " + this.typeCollection.toString() + "\n ";
        }
        desc = desc + ")";
        return desc;
    }

    @Override
    public boolean equalSymbol(Transition t) {
        if (!(t instanceof AggregationTransition)) {
            return false;
        }
        AggregationTransition et = (AggregationTransition)t;
        if (!this.typeCollection.equals(et.typeCollection)) {
            return false;
        }
        if (this.aggregateFrom != et.aggregateFrom) {
            return false;
        }
        if (this.validToEdgeRoles != null) {
            if (et.validToEdgeRoles == null) {
                return false;
            }
            if (!this.validToEdgeRoles.equals(et.validToEdgeRoles)) {
                return false;
            }
        } else if (et.validToEdgeRoles != null) {
            return false;
        }
        if (this.validFromEdgeRoles != null) {
            if (et.validFromEdgeRoles == null) {
                return false;
            }
            if (!this.validFromEdgeRoles.equals(et.validFromEdgeRoles)) {
                return false;
            }
        } else if (et.validFromEdgeRoles != null) {
            return false;
        }
        if (this.predicateEvaluator != null) {
            if (et.predicateEvaluator == null) {
                return false;
            }
            if (!this.predicateEvaluator.equals(et.predicateEvaluator)) {
                return false;
            }
        } else if (et.predicateEvaluator != null) {
            return false;
        }
        return true;
    }

    protected AggregationTransition(AggregationTransition t, boolean addToStates) {
        super(t, addToStates);
        this.aggregateFrom = t.aggregateFrom;
        this.typeCollection = t.typeCollection;
        this.validToEdgeRoles = t.validToEdgeRoles;
        this.predicateEvaluator = t.predicateEvaluator;
        this.thisEdgeEvaluator = t.thisEdgeEvaluator;
        this.validToEdgeRoles = t.validToEdgeRoles;
        this.validFromEdgeRoles = t.validFromEdgeRoles;
    }

    @Override
    public Transition copy(boolean addToStates) {
        return new AggregationTransition(this, addToStates);
    }

    public AggregationTransition(State start, State end, boolean aggregateFrom, TypeCollection typeCollection, Set<String> roles, VertexEvaluator<? extends Expression> predicateEvaluator, GreqlQueryImpl query) {
        super(start, end);
        this.aggregateFrom = aggregateFrom;
        this.validToEdgeRoles = roles;
        this.validFromEdgeRoles = null;
        this.typeCollection = typeCollection;
        this.predicateEvaluator = predicateEvaluator;
        ThisEdge v = (ThisEdge)query.getQueryGraph().getFirstVertex(ThisEdge.VC);
        if (v != null) {
            this.thisEdgeEvaluator = (ThisEdgeEvaluator)query.getVertexEvaluator(v);
        }
    }

    @Override
    public void reverse() {
        super.reverse();
        this.aggregateFrom = !this.aggregateFrom;
        Set<String> tempSet = this.validFromEdgeRoles;
        this.validFromEdgeRoles = this.validToEdgeRoles;
        this.validToEdgeRoles = tempSet;
    }

    @Override
    public boolean isEpsilon() {
        return false;
    }

    @Override
    public boolean accepts(Vertex v, Edge e, InternalGreqlEvaluator evaluator) {
        EdgeClass edgeClass;
        if (e == null) {
            return false;
        }
        if (this.aggregateFrom ? e.getThatAggregationKind() == AggregationKind.NONE : e.getThisAggregationKind() == AggregationKind.NONE) {
            return false;
        }
        Set<String> validEdgeRoles = this.validToEdgeRoles;
        boolean checkToEdgeRoles = true;
        if (validEdgeRoles == null) {
            validEdgeRoles = this.validFromEdgeRoles;
            checkToEdgeRoles = false;
        }
        boolean rolesOnly = validEdgeRoles != null && this.typeCollection.isEmpty();
        boolean acceptedByRole = false;
        if (validEdgeRoles != null) {
            EdgeClass ec = e.getAttributedElementClass();
            Set<String> roles = null;
            roles = e.isNormal() == checkToEdgeRoles ? ec.getTo().getAllRoles() : ec.getFrom().getAllRoles();
            for (String role : roles) {
                if (!validEdgeRoles.contains(role)) continue;
                acceptedByRole = true;
                break;
            }
        }
        if (rolesOnly ? !acceptedByRole : !acceptedByRole && !this.typeCollection.acceptsType(edgeClass = e.getAttributedElementClass())) {
            return false;
        }
        if (this.predicateEvaluator != null) {
            this.thisEdgeEvaluator.setValue(e, evaluator);
            Object res = this.predicateEvaluator.getResult(evaluator);
            return res instanceof Boolean && ((Boolean)res).equals(Boolean.TRUE);
        }
        return true;
    }

    @Override
    public Vertex getNextVertex(Vertex v, Edge e) {
        return e.getThat();
    }

    @Override
    public String prettyPrint() {
        String symbol = "--<>";
        if (this.aggregateFrom) {
            symbol = "<>--";
        }
        return symbol + this.typeCollection.toString();
    }

    @Override
    public boolean consumesEdge() {
        return true;
    }
}

