/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator;

import de.uni_koblenz.jgralab.greql.evaluator.GreqlEvaluatorImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VariableDeclaration;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.WrongResultTypeException;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import java.util.List;

public class VariableDeclarationLayer {
    private final List<VariableDeclaration> variableDeclarations;
    private final List<VertexEvaluator<? extends Expression>> constraintList;
    private boolean firstIteration = true;
    private Declaration declaration = null;

    public VariableDeclarationLayer(Declaration vertex, List<VariableDeclaration> varDecls, List<VertexEvaluator<? extends Expression>> constraintList) {
        this.declaration = vertex;
        this.variableDeclarations = varDecls;
        this.constraintList = constraintList;
    }

    public boolean iterate(InternalGreqlEvaluator evaluator) {
        StringBuilder sb = null;
        if (GreqlEvaluatorImpl.DEBUG_DECLARATION_ITERATIONS) {
            sb = new StringBuilder();
            sb.append("### New Declaration Layer Iteration (");
            sb.append(this.declaration);
            sb.append(")\n");
        }
        boolean constraintsFullfilled = false;
        if (this.firstIteration) {
            if (!this.getFirstCombination(evaluator)) {
                if (GreqlEvaluatorImpl.DEBUG_DECLARATION_ITERATIONS) {
                    sb.append("## 1st. iteration: returning false (");
                    sb.append(this.declaration);
                    sb.append(")");
                    System.out.println(sb.toString());
                }
                return false;
            }
            constraintsFullfilled = this.fullfillsConstraints(evaluator);
            this.firstIteration = false;
        }
        while (!constraintsFullfilled) {
            if (!this.getNextCombination(false, evaluator)) {
                if (GreqlEvaluatorImpl.DEBUG_DECLARATION_ITERATIONS) {
                    sb.append("## nth iteration: returning false (");
                    sb.append(this.declaration);
                    sb.append(")");
                    System.out.println(sb.toString());
                }
                return false;
            }
            constraintsFullfilled = this.fullfillsConstraints(evaluator);
        }
        if (GreqlEvaluatorImpl.DEBUG_DECLARATION_ITERATIONS) {
            boolean first = true;
            for (VariableDeclaration dec : this.variableDeclarations) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(dec);
            }
            sb.append(" (");
            sb.append(this.declaration);
            sb.append(")");
            System.out.println(sb.toString());
        }
        return true;
    }

    private boolean getFirstCombination(InternalGreqlEvaluator evaluator) {
        this.variableDeclarations.get(0).reset(evaluator);
        return this.getNextCombination(true, evaluator);
    }

    private boolean getNextCombination(boolean firstCombination, InternalGreqlEvaluator evaluator) {
        boolean iterate;
        int pointer = firstCombination ? 0 : this.variableDeclarations.size() - 1;
        block0: do {
            iterate = false;
            VariableDeclaration currDecl = null;
            do {
                if (pointer >= 0) continue;
                return false;
            } while (!(currDecl = this.variableDeclarations.get(pointer--)).iterate(evaluator));
            pointer += 2;
            int size = this.variableDeclarations.size();
            while (pointer < size) {
                currDecl = this.variableDeclarations.get(pointer++);
                currDecl.reset(evaluator);
                if (currDecl.iterate(evaluator)) continue;
                pointer -= 2;
                iterate = true;
                continue block0;
            }
        } while (iterate);
        return true;
    }

    private boolean fullfillsConstraints(InternalGreqlEvaluator evaluator) {
        if (this.constraintList == null || this.constraintList.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.constraintList.size(); ++i) {
            VertexEvaluator<? extends Expression> currentEval = this.constraintList.get(i);
            Object tempResult = currentEval.getResult(evaluator);
            if (tempResult instanceof Boolean) {
                if ((Boolean)tempResult == Boolean.TRUE) continue;
                return false;
            }
            throw new WrongResultTypeException(currentEval.getVertex(), "Boolean", tempResult.getClass().getSimpleName(), currentEval.createPossibleSourcePositions());
        }
        return true;
    }

    public void reset() {
        this.firstIteration = true;
    }
}

