/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.greql.GreqlEnvironment;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.EvaluatorUtilities;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.FiniteAutomaton;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.EvaluationInterruptedException;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.types.Undefined;
import de.uni_koblenz.jgralab.impl.std.GraphImpl;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;
import java.util.HashMap;
import java.util.Map;

public class GreqlEvaluatorImpl
implements InternalGreqlEvaluator {
    public static boolean DEBUG_DECLARATION_ITERATIONS = false;
    public static final int VERTEX_INDEX_SIZE = 50;
    private Graph graph = null;
    private Schema schema = null;
    private Object result = null;
    private Object[] localEvaluationResults;
    private Map<GreqlVertex, FiniteAutomaton> localAutomatons;
    private ProgressFunction progressFunction = null;
    private long progressStepsPassed;
    private long estimatedInterpretationSteps;
    private GreqlQueryImpl query;
    private GreqlEnvironment environment;
    private int cnt = 0;

    @Override
    public final void progress(long value) {
        if (++this.cnt == 4096) {
            if (Thread.interrupted()) {
                throw new EvaluationInterruptedException();
            }
            this.cnt = 0;
        }
        this.progressStepsPassed += value;
        if (this.progressFunction != null) {
            while (this.progressStepsPassed > this.progressFunction.getUpdateInterval()) {
                this.progressFunction.progress(1L);
                this.progressStepsPassed -= this.progressFunction.getUpdateInterval();
            }
        }
    }

    @Override
    public Object setLocalEvaluationResult(GreqlVertex vertex, Object value) {
        Object oldValue = this.localEvaluationResults[vertex.getId()];
        this.localEvaluationResults[vertex.getId()] = value;
        return oldValue;
    }

    @Override
    public Object getLocalEvaluationResult(GreqlVertex vertex) {
        return this.localEvaluationResults[vertex.getId()];
    }

    @Override
    public FiniteAutomaton setLocalAutomaton(GreqlVertex vertex, FiniteAutomaton value) {
        return this.localAutomatons.put(vertex, value);
    }

    @Override
    public FiniteAutomaton getLocalAutomaton(GreqlVertex vertex) {
        return this.localAutomatons.get(vertex);
    }

    @Override
    public Object removeLocalEvaluationResult(GreqlVertex vertex) {
        return this.setLocalEvaluationResult(vertex, null);
    }

    public Object getResult() {
        return this.evaluate();
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public GraphElementClass<?, ?> getGraphElementClass(String typeName) {
        return EvaluatorUtilities.getGraphElementClass(this.query.getRootExpression(), this.schema, typeName);
    }

    public GreqlEvaluatorImpl(GreqlQuery query, Graph datagraph, GreqlEnvironment environment, ProgressFunction progressFunction) {
        this.initialize(query, datagraph, environment, progressFunction);
    }

    public GreqlEvaluatorImpl(GreqlQuery query, Graph datagraph, GreqlEnvironment environment) {
        this.initialize(query, datagraph, environment, null);
    }

    private void initialize(GreqlQuery query, Graph datagraph, GreqlEnvironment environment, ProgressFunction progressFunction) {
        this.query = (GreqlQueryImpl)query;
        this.graph = datagraph;
        if (datagraph != null) {
            this.schema = datagraph.getSchema();
        }
        this.environment = environment;
        this.localEvaluationResults = new Object[((GraphImpl)((Object)query.getQueryGraph())).getMaxVCount() + 1];
        this.localAutomatons = new HashMap<GreqlVertex, FiniteAutomaton>();
        this.progressFunction = progressFunction;
    }

    public Object evaluate(GreqlQuery query, Graph datagraph, GreqlEnvironment environment, ProgressFunction progressFunction) {
        this.initialize(query, datagraph, environment, progressFunction);
        return this.evaluate();
    }

    public Object evaluate() {
        this.query.resetVertexEvaluators(this);
        if (this.query.getQueryGraph().getVCount() <= 1) {
            this.result = Undefined.UNDEFINED;
            return this.result;
        }
        VertexEvaluator<GreqlExpression> greql2ExpEval = this.query.getVertexEvaluator(this.query.getRootExpression());
        if (this.progressFunction != null) {
            this.estimatedInterpretationSteps = greql2ExpEval.getInitialSubtreeEvaluationCosts();
            this.progressFunction.init(this.estimatedInterpretationSteps);
        }
        this.result = greql2ExpEval.getResult(this);
        if (this.progressFunction != null) {
            this.progressFunction.finished();
        }
        return this.result;
    }

    @Override
    public Object setVariable(String varName, Object value) {
        return this.environment.setVariable(varName, value);
    }

    @Override
    public Object getVariable(String varName) {
        return this.environment.getVariable(varName);
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }
}

