/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizerInfo;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import java.lang.ref.SoftReference;
import java.util.HashMap;

public class GreqlQueryCache {
    private final HashMap<String, SoftReference<GreqlQuery>> cache = new HashMap();
    private Optimizer optimizer;

    public GreqlQueryCache() {
        this(new DefaultOptimizer(new DefaultOptimizerInfo()));
    }

    public GreqlQueryCache(Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    public synchronized GreqlQuery getQuery(String queryText) {
        String key = queryText;
        SoftReference<GreqlQuery> ref = this.cache.get(key);
        if (ref != null) {
            GreqlQuery e = ref.get();
            if (e != null) {
                return e;
            }
            this.cache.remove(key);
        }
        GreqlQuery query = GreqlQuery.createQuery(queryText, this.optimizer);
        this.cache.put(key, new SoftReference<GreqlQuery>(query));
        return query;
    }
}

