/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphvalidator;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphvalidator.BrokenGReQLConstraintViolation;
import de.uni_koblenz.jgralab.graphvalidator.ConstraintViolation;
import de.uni_koblenz.jgralab.graphvalidator.GReQLConstraintViolation;
import de.uni_koblenz.jgralab.graphvalidator.MultiplicityConstraintViolation;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Constraint;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class GraphValidator {
    private final Graph graph;

    public GraphValidator(Graph graph) {
        this.graph = graph;
    }

    public static void main(String[] args) throws GraphIOException, IOException {
        if (args.length != 1) {
            System.err.println("Usage: java GraphValidator <graph.tg>");
            System.exit(1);
        }
        Graph g = GraphIO.loadGraphFromFile(args[0], new ConsoleProgressFunction("Loading"));
        GraphValidator v = new GraphValidator(g);
        v.createValidationReport("__validation_report.html");
    }

    public SortedSet<MultiplicityConstraintViolation> validateMultiplicities(EdgeClass ec) {
        TreeSet<MultiplicityConstraintViolation> brokenConstraints = new TreeSet<MultiplicityConstraintViolation>();
        int toMin = ec.getTo().getMin();
        int toMax = ec.getTo().getMax();
        HashMap badOutgoing = new HashMap();
        for (Vertex v : this.graph.vertices(ec.getFrom().getVertexClass())) {
            int degree = v.getDegree(ec, EdgeDirection.OUT);
            if (degree >= toMin && degree <= toMax) continue;
            badOutgoing.put(v, degree);
        }
        if (!badOutgoing.isEmpty()) {
            brokenConstraints.add(new MultiplicityConstraintViolation(ec, "Invalid number of outgoing edges, allowed are (" + toMin + "," + (toMax == Integer.MAX_VALUE ? "*" : Integer.valueOf(toMax)) + ").", badOutgoing));
        }
        int fromMin = ec.getFrom().getMin();
        int fromMax = ec.getFrom().getMax();
        HashMap badIncoming = new HashMap();
        for (Vertex v : this.graph.vertices(ec.getTo().getVertexClass())) {
            int degree = v.getDegree(ec, EdgeDirection.IN);
            if (degree >= fromMin && degree <= fromMax) continue;
            badIncoming.put(v, degree);
        }
        if (!badIncoming.isEmpty()) {
            brokenConstraints.add(new MultiplicityConstraintViolation(ec, "Invalid number of incoming edges, allowed are (" + fromMin + "," + (fromMax == Integer.MAX_VALUE ? "*" : Integer.valueOf(fromMax)) + ").", badIncoming));
        }
        return brokenConstraints;
    }

    public SortedSet<ConstraintViolation> validate() {
        TreeSet<ConstraintViolation> brokenConstraints = new TreeSet<ConstraintViolation>();
        for (EdgeClass ec : this.graph.getGraphClass().getEdgeClasses()) {
            brokenConstraints.addAll(this.validateMultiplicities(ec));
        }
        ArrayList<AttributedElementClass<GraphClass, Graph>> aecs = new ArrayList<AttributedElementClass<GraphClass, Graph>>();
        aecs.add(this.graph.getSchema().getGraphClass());
        aecs.addAll(this.graph.getSchema().getGraphClass().getVertexClasses());
        aecs.addAll(this.graph.getSchema().getGraphClass().getEdgeClasses());
        for (AttributedElementClass attributedElementClass : aecs) {
            brokenConstraints.addAll(this.validateConstraints(attributedElementClass));
        }
        return brokenConstraints;
    }

    public SortedSet<ConstraintViolation> validateConstraints(AttributedElementClass<?, ?> aec) {
        TreeSet<ConstraintViolation> brokenConstraints = new TreeSet<ConstraintViolation>();
        for (Constraint constraint : aec.getConstraints()) {
            String query = constraint.getPredicate();
            try {
                if (((Boolean)GreqlQuery.createQuery(query).evaluate(this.graph)).booleanValue()) continue;
                if (constraint.getOffendingElementsQuery() != null) {
                    query = constraint.getOffendingElementsQuery();
                    Set resultSet = (Set)GreqlQuery.createQuery(query).evaluate(this.graph);
                    brokenConstraints.add(new GReQLConstraintViolation(aec, constraint, resultSet));
                    continue;
                }
                brokenConstraints.add(new GReQLConstraintViolation(aec, constraint, null));
            }
            catch (GreqlException e) {
                brokenConstraints.add(new BrokenGReQLConstraintViolation(aec, constraint, query));
            }
        }
        return brokenConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<ConstraintViolation> createValidationReport(String fileName) throws IOException {
        SortedSet<ConstraintViolation> brokenConstraints = this.validate();
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(new File(fileName)));
            bw.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n\"http://www.w3.org/TR/html4/strict.dtd\">\n<html>");
            bw.append("<head>");
            bw.append("<style type=\"text/css\">");
            bw.append("th {");
            bw.append("\tfont: bold 11px sans-serif;");
            bw.append("\tcolor: MidnightBlue;");
            bw.append("\tborder-right: 1px solid #C1DAD7;");
            bw.append("\tborder-bottom: 1px solid #C1DAD7;");
            bw.append("\tborder-top: 1px solid #C1DAD7;");
            bw.append("\tletter-spacing: 2px;");
            bw.append("\ttext-align: left;");
            bw.append(" padding: 6px 6px 6px 12px;");
            bw.append("\tbackground: #CAE8EA;");
            bw.append("}");
            bw.append("td {");
            bw.append(" border-right: 1px solid #C1DAD7;");
            bw.append("\tborder-bottom: 1px solid #C1DAD7;");
            bw.append("\tbackground: #fff;");
            bw.append("\tpadding: 6px 6px 6px 12px;");
            bw.append("\tcolor: DimGrey;");
            bw.append("}");
            bw.append("td.other {");
            bw.append(" border-right: 1px solid #C1DAD7;");
            bw.append("\tborder-bottom: 1px solid #C1DAD7;");
            bw.append("\tbackground: AliceBlue;");
            bw.append("\tpadding: 6px 6px 6px 12px;");
            bw.append("\tcolor: DimGrey;");
            bw.append("}");
            bw.append("</style>");
            bw.append("<title>");
            bw.append("Validation Report for the " + this.graph.getSchemaClass().getSimpleName() + " with id " + this.graph.getId() + ".");
            bw.append("</title>");
            bw.append("</head>");
            bw.append("<body>");
            if (brokenConstraints.size() == 0) {
                bw.append("<p><b>The graph is valid!</b></p>");
            } else {
                bw.append("<p><b>The " + this.graph.getSchemaClass().getSimpleName() + " violates " + brokenConstraints.size() + " constraints.</b></p>");
                bw.append("<table border=\"1\">");
                bw.append("<tr>");
                bw.append("<th>#</th>");
                bw.append("<th>ConstraintType</th>");
                bw.append("<th>AttributedElementClass</th>");
                bw.append("<th>Message</th>");
                bw.append("<th>Broken Elements</th>");
                bw.append("</tr>");
                int no = 1;
                String cssClass = "";
                for (ConstraintViolation ci : brokenConstraints) {
                    cssClass = no % 2 == 0 ? "other" : "";
                    bw.append("<tr>");
                    bw.append("<td class=\"" + cssClass + "\">");
                    bw.append(Integer.valueOf(no++).toString());
                    bw.append("</td>");
                    bw.append("<td class=\"" + cssClass + "\">");
                    bw.append(ci.getClass().getSimpleName());
                    bw.append("</td>");
                    bw.append("<td class=\"" + cssClass + "\">");
                    bw.append(ci.getAttributedElementClass().getQualifiedName());
                    bw.append("</td>");
                    bw.append("<td class=\"" + cssClass + "\">");
                    bw.append(ci.getMessage());
                    bw.append("</td>");
                    bw.append("<td class=\"" + cssClass + "\">");
                    if (ci.getOffendingElements() != null) {
                        for (AttributedElement<?, ?> ae : ci.getOffendingElements()) {
                            bw.append(ae.toString());
                            if (ci instanceof MultiplicityConstraintViolation) {
                                bw.append(", degree=").append(Integer.toString(((MultiplicityConstraintViolation)ci).getDegree(ae)));
                            }
                            bw.append("<br/>");
                        }
                    }
                    bw.append("</td>");
                    bw.append("</tr>");
                }
                bw.append("</table>");
            }
            bw.append("</body></html>");
            bw.flush();
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException ex) {
                throw new RuntimeException("An Exception occurred while closing the stream.", ex);
            }
        }
        return brokenConstraints;
    }
}

