/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.algolib.functions.Function;
import de.uni_koblenz.jgralab.algolib.functions.entries.FunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import de.uni_koblenz.jgralab.impl.ReversedEdgeBaseImpl;
import java.util.HashMap;
import java.util.Iterator;

public abstract class MapGraphMarker<T extends AttributedElement<?, ?>, O>
extends AbstractGraphMarker<T>
implements Function<T, O> {
    protected HashMap<T, O> tempAttributeMap = new HashMap();

    protected MapGraphMarker(Graph g) {
        super(g);
    }

    public O getMark(T elem) {
        if (elem == null) {
            return null;
        }
        assert (elem instanceof GraphElement && ((GraphElement)elem).getGraph() == this.graph || elem == this.graph);
        if (elem instanceof ReversedEdgeBaseImpl) {
            elem = this.getNormalEdge(elem);
        }
        return this.tempAttributeMap.get(elem);
    }

    public O mark(T elem, O value) {
        assert (elem instanceof GraphElement && ((GraphElement)elem).getGraph() == this.graph || elem == this.graph);
        if (elem instanceof ReversedEdgeBaseImpl) {
            elem = this.getNormalEdge(elem);
        }
        return this.tempAttributeMap.put(elem, value);
    }

    private T getNormalEdge(T elem) {
        elem = ((ReversedEdgeBaseImpl)elem).getNormalEdge();
        return elem;
    }

    @Override
    public int size() {
        return this.tempAttributeMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tempAttributeMap.isEmpty();
    }

    @Override
    public void clear() {
        this.tempAttributeMap.clear();
    }

    @Override
    public Iterable<T> getMarkedElements() {
        return this.tempAttributeMap.keySet();
    }

    @Override
    public boolean isMarked(T elem) {
        assert (elem instanceof GraphElement && ((GraphElement)elem).getGraph() == this.graph || elem == this.graph);
        if (elem instanceof ReversedEdgeBaseImpl) {
            elem = this.getNormalEdge(elem);
        }
        return this.tempAttributeMap.containsKey(elem);
    }

    @Override
    public boolean removeMark(T elem) {
        assert (elem instanceof GraphElement && ((GraphElement)elem).getGraph() == this.graph || elem == this.graph);
        if (elem instanceof ReversedEdgeBaseImpl) {
            elem = this.getNormalEdge(elem);
        }
        return this.tempAttributeMap.remove(elem) != null;
    }

    @Override
    public void maxEdgeCountIncreased(int newValue) {
    }

    @Override
    public void maxVertexCountIncreased(int newValue) {
    }

    @Override
    public O get(T parameter) {
        return this.getMark(parameter);
    }

    @Override
    public boolean isDefined(T parameter) {
        return this.isMarked(parameter);
    }

    @Override
    public void set(T parameter, O value) {
        this.mark(parameter, value);
    }

    @Override
    public Iterable<T> getDomainElements() {
        return this.getMarkedElements();
    }

    @Override
    public Iterator<FunctionEntry<T, O>> iterator() {
        final Iterator<T> markedElements = this.getMarkedElements().iterator();
        return new Iterator<FunctionEntry<T, O>>(){

            @Override
            public boolean hasNext() {
                return markedElements.hasNext();
            }

            @Override
            public FunctionEntry<T, O> next() {
                AttributedElement currentElement = (AttributedElement)markedElements.next();
                return new FunctionEntry(currentElement, MapGraphMarker.this.get(currentElement));
            }

            @Override
            public void remove() {
                markedElements.remove();
            }
        };
    }
}

