/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.LongFunction;
import de.uni_koblenz.jgralab.algolib.functions.entries.LongFunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import java.util.Iterator;

public abstract class LongGraphMarker<T extends GraphElement<?, ?>>
extends AbstractGraphMarker<T>
implements LongFunction<T> {
    private static final long DEFAULT_UNMARKED_VALUE = Long.MIN_VALUE;
    protected long[] temporaryAttributes;
    protected int marked;
    protected long unmarkedValue = Long.MIN_VALUE;
    protected long version;

    protected LongGraphMarker(Graph graph, int size) {
        super(graph);
        this.temporaryAttributes = this.createNewArray(size);
        this.marked = 0;
    }

    private long[] createNewArray(int size) {
        long[] newArray = new long[size];
        for (int i = 0; i < size; ++i) {
            newArray[i] = this.unmarkedValue;
        }
        return newArray;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.temporaryAttributes.length; ++i) {
            this.temporaryAttributes[i] = this.unmarkedValue;
        }
        this.marked = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.marked == 0;
    }

    @Override
    public boolean isMarked(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        return this.temporaryAttributes[graphElement.getId()] != this.unmarkedValue;
    }

    public long mark(T graphElement, long value) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        long out = this.temporaryAttributes[graphElement.getId()];
        this.temporaryAttributes[graphElement.getId()] = value;
        ++this.marked;
        ++this.version;
        return out;
    }

    public long getMark(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        long out = this.temporaryAttributes[graphElement.getId()];
        return out;
    }

    @Override
    public boolean removeMark(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        if (this.temporaryAttributes[graphElement.getId()] == this.unmarkedValue) {
            return false;
        }
        this.temporaryAttributes[graphElement.getId()] = this.unmarkedValue;
        --this.marked;
        ++this.version;
        return true;
    }

    @Override
    public int size() {
        return this.marked;
    }

    public int maxSize() {
        return this.temporaryAttributes.length - 1;
    }

    protected void expand(int newSize) {
        assert (newSize > this.temporaryAttributes.length);
        long[] newTemporaryAttributes = this.createNewArray(newSize);
        System.arraycopy(this.temporaryAttributes, 0, newTemporaryAttributes, 0, this.temporaryAttributes.length);
        this.temporaryAttributes = newTemporaryAttributes;
    }

    public long getUnmarkedValue() {
        return this.unmarkedValue;
    }

    public void setUnmarkedValue(long newUnmarkedValue) {
        if (newUnmarkedValue != this.unmarkedValue) {
            for (int i = 0; i < this.temporaryAttributes.length; ++i) {
                if (this.temporaryAttributes[i] == newUnmarkedValue) {
                    --this.marked;
                }
                if (this.temporaryAttributes[i] != this.unmarkedValue) continue;
                this.temporaryAttributes[i] = newUnmarkedValue;
            }
            this.unmarkedValue = newUnmarkedValue;
        }
    }

    @Override
    public long get(T parameter) {
        return this.getMark(parameter);
    }

    @Override
    public boolean isDefined(T parameter) {
        return this.isMarked(parameter);
    }

    @Override
    public void set(T parameter, long value) {
        this.mark(parameter, value);
    }

    @Override
    public Iterable<T> getDomainElements() {
        return this.getMarkedElements();
    }

    @Override
    public Iterator<LongFunctionEntry<T>> iterator() {
        final Iterator markedElements = this.getMarkedElements().iterator();
        return new Iterator<LongFunctionEntry<T>>(){

            @Override
            public boolean hasNext() {
                return markedElements.hasNext();
            }

            @Override
            public LongFunctionEntry<T> next() {
                GraphElement currentElement = (GraphElement)markedElements.next();
                return new LongFunctionEntry<GraphElement>(currentElement, LongGraphMarker.this.get(currentElement));
            }

            @Override
            public void remove() {
            }
        };
    }
}

