/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.Function;
import de.uni_koblenz.jgralab.algolib.functions.entries.FunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import java.util.Iterator;

public abstract class ArrayGraphMarker<T extends GraphElement<?, ?>, O>
extends AbstractGraphMarker<T>
implements Function<T, O> {
    protected Object[] temporaryAttributes;
    protected int marked;
    protected long version;

    protected ArrayGraphMarker(Graph graph, int size) {
        super(graph);
        this.temporaryAttributes = new Object[size];
        this.marked = 0;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.temporaryAttributes.length; ++i) {
            this.temporaryAttributes[i] = null;
        }
        this.marked = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.marked == 0;
    }

    @Override
    public boolean isMarked(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.isValid());
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        return this.temporaryAttributes[graphElement.getId()] != null;
    }

    public O getMark(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.isValid());
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        Object out = this.temporaryAttributes[graphElement.getId()];
        return (O)out;
    }

    public O mark(T graphElement, O value) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.isValid());
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        Object out = this.temporaryAttributes[graphElement.getId()];
        this.temporaryAttributes[graphElement.getId()] = value;
        ++this.marked;
        ++this.version;
        return (O)out;
    }

    @Override
    public int size() {
        return this.marked;
    }

    @Override
    public boolean removeMark(T graphElement) {
        assert (graphElement.getGraph() == this.graph);
        assert (graphElement.isValid());
        assert (graphElement.getId() <= (graphElement instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        if (this.temporaryAttributes[graphElement.getId()] == null) {
            return false;
        }
        this.temporaryAttributes[graphElement.getId()] = null;
        --this.marked;
        ++this.version;
        return true;
    }

    protected void expand(int newSize) {
        assert (newSize > this.temporaryAttributes.length);
        Object[] newTemporaryAttributes = new Object[newSize];
        System.arraycopy(this.temporaryAttributes, 0, newTemporaryAttributes, 0, this.temporaryAttributes.length);
        this.temporaryAttributes = newTemporaryAttributes;
    }

    public int maxSize() {
        return this.temporaryAttributes.length - 1;
    }

    @Override
    public O get(T parameter) {
        return this.getMark(parameter);
    }

    @Override
    public boolean isDefined(T parameter) {
        return this.isMarked(parameter);
    }

    @Override
    public void set(T parameter, O value) {
        this.mark(parameter, value);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("[");
        Iterator iter = this.getMarkedElements().iterator();
        if (iter.hasNext()) {
            GraphElement next = (GraphElement)iter.next();
            out.append(next);
            out.append(" -> ");
            out.append(this.get((T)next));
            while (iter.hasNext()) {
                out.append(",\n");
                next = (GraphElement)iter.next();
                out.append(next);
                out.append(" -> ");
                out.append(this.get((T)next));
            }
        }
        out.append("]");
        return out.toString();
    }

    @Override
    public Iterable<T> getDomainElements() {
        return this.getMarkedElements();
    }

    @Override
    public Iterator<FunctionEntry<T, O>> iterator() {
        final Iterator markedElements = this.getMarkedElements().iterator();
        return new Iterator<FunctionEntry<T, O>>(){

            @Override
            public boolean hasNext() {
                return markedElements.hasNext();
            }

            @Override
            public FunctionEntry<T, O> next() {
                GraphElement currentElement = (GraphElement)markedElements.next();
                return new FunctionEntry(currentElement, ArrayGraphMarker.this.get(currentElement));
            }

            @Override
            public void remove() {
                markedElements.remove();
            }
        };
    }
}

