/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.eca;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.eca.Action;
import de.uni_koblenz.jgralab.eca.Condition;
import de.uni_koblenz.jgralab.eca.ECAException;
import de.uni_koblenz.jgralab.eca.ECARule;
import de.uni_koblenz.jgralab.eca.ECARuleManagerInterface;
import de.uni_koblenz.jgralab.eca.events.ChangeAttributeEventDescription;
import de.uni_koblenz.jgralab.eca.events.ChangeEdgeEventDescription;
import de.uni_koblenz.jgralab.eca.events.CreateEdgeEventDescription;
import de.uni_koblenz.jgralab.eca.events.CreateVertexEventDescription;
import de.uni_koblenz.jgralab.eca.events.DeleteEdgeEventDescription;
import de.uni_koblenz.jgralab.eca.events.DeleteVertexEventDescription;
import de.uni_koblenz.jgralab.eca.events.EventDescription;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ECARuleManager
implements ECARuleManagerInterface {
    private Graph graph;
    private List<ECARule<?>> rules;
    private int nestedTriggerCalls = 0;
    private int maxNestedTriggerCalls = 30;
    private boolean blocked = false;
    private List<CreateVertexEventDescription> beforeCreateVertexEvents;
    private List<CreateVertexEventDescription> afterCreateVertexEvents;
    private List<DeleteVertexEventDescription> beforeDeleteVertexEvents;
    private List<DeleteVertexEventDescription> afterDeleteVertexEvents;
    private List<CreateEdgeEventDescription> beforeCreateEdgeEvents;
    private List<CreateEdgeEventDescription> afterCreateEdgeEvents;
    private List<DeleteEdgeEventDescription> beforeDeleteEdgeEvents;
    private List<DeleteEdgeEventDescription> afterDeleteEdgeEvents;
    private List<ChangeEdgeEventDescription> beforeChangeAlphaOfEdgeEvents;
    private List<ChangeEdgeEventDescription> afterChangeAlphaOfEdgeEvents;
    private List<ChangeEdgeEventDescription> beforeChangeOmegaOfEdgeEvents;
    private List<ChangeEdgeEventDescription> afterChangeOmegaOfEdgeEvents;
    private List<ChangeAttributeEventDescription<?>> beforeChangeAttributeEvents;
    private List<ChangeAttributeEventDescription<?>> afterChangeAttributeEvents;

    public static ECARuleManager getECARuleManagerForGraph(Graph g) {
        return (ECARuleManager)g.getECARuleManager();
    }

    public ECARuleManager(Graph graph) {
        this.graph = graph;
        this.rules = new ArrayList();
    }

    private void createBeforeCreateVertexEventsLazily() {
        if (this.beforeCreateVertexEvents == null) {
            this.beforeCreateVertexEvents = new ArrayList<CreateVertexEventDescription>();
        }
    }

    private void createAfterCreateVertexEventsLazily() {
        if (this.afterCreateVertexEvents == null) {
            this.afterCreateVertexEvents = new ArrayList<CreateVertexEventDescription>();
        }
    }

    private void createBeforeDeleteVertexEventsLazily() {
        if (this.beforeDeleteVertexEvents == null) {
            this.beforeDeleteVertexEvents = new ArrayList<DeleteVertexEventDescription>();
        }
    }

    private void createAfterDeleteVertexEventsLazily() {
        if (this.afterDeleteVertexEvents == null) {
            this.afterDeleteVertexEvents = new ArrayList<DeleteVertexEventDescription>();
        }
    }

    private void createBeforeCreateEdgeEventsLazily() {
        if (this.beforeCreateEdgeEvents == null) {
            this.beforeCreateEdgeEvents = new ArrayList<CreateEdgeEventDescription>();
        }
    }

    private void createAfterCreateEdgeEventsLazily() {
        if (this.afterCreateEdgeEvents == null) {
            this.afterCreateEdgeEvents = new ArrayList<CreateEdgeEventDescription>();
        }
    }

    private void createBeforeDeleteEdgeEventsLazily() {
        if (this.beforeDeleteEdgeEvents == null) {
            this.beforeDeleteEdgeEvents = new ArrayList<DeleteEdgeEventDescription>();
        }
    }

    private void createAfterDeleteEdgeEventsLazily() {
        if (this.afterDeleteEdgeEvents == null) {
            this.afterDeleteEdgeEvents = new ArrayList<DeleteEdgeEventDescription>();
        }
    }

    private void createBeforeChangeAlphaOfEdgeEventsLazily() {
        if (this.beforeChangeAlphaOfEdgeEvents == null) {
            this.beforeChangeAlphaOfEdgeEvents = new ArrayList<ChangeEdgeEventDescription>();
        }
    }

    private void createAfterChangeAlphaOfEdgeEventsLazily() {
        if (this.afterChangeAlphaOfEdgeEvents == null) {
            this.afterChangeAlphaOfEdgeEvents = new ArrayList<ChangeEdgeEventDescription>();
        }
    }

    private void createBeforeChangeOmegaOfEdgeEventsLazily() {
        if (this.beforeChangeOmegaOfEdgeEvents == null) {
            this.beforeChangeOmegaOfEdgeEvents = new ArrayList<ChangeEdgeEventDescription>();
        }
    }

    private void createAfterChangeOmegaOfEdgeEventsLazily() {
        if (this.afterChangeOmegaOfEdgeEvents == null) {
            this.afterChangeOmegaOfEdgeEvents = new ArrayList<ChangeEdgeEventDescription>();
        }
    }

    private void createBeforeChangeAttributeEventsLazily() {
        if (this.beforeChangeAttributeEvents == null) {
            this.beforeChangeAttributeEvents = new ArrayList();
        }
    }

    private void createAfterChangeAttributeEventsLazily() {
        if (this.afterChangeAttributeEvents == null) {
            this.afterChangeAttributeEvents = new ArrayList();
        }
    }

    @Override
    public void fireBeforeCreateVertexEvents(VertexClass vc) {
        if (this.beforeCreateVertexEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.beforeCreateVertexEvents.size();
        for (int i = 0; i < max; ++i) {
            this.beforeCreateVertexEvents.get(i).fire(vc);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireAfterCreateVertexEvents(Vertex element) {
        if (this.afterCreateVertexEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.afterCreateVertexEvents.size();
        for (int i = 0; i < max; ++i) {
            this.afterCreateVertexEvents.get(i).fire(element);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireBeforeDeleteVertexEvents(Vertex element) {
        if (this.beforeDeleteVertexEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.beforeDeleteVertexEvents.size();
        for (int i = 0; i < max; ++i) {
            this.beforeDeleteVertexEvents.get(i).fire(element);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireAfterDeleteVertexEvents(VertexClass vc) {
        if (this.afterDeleteVertexEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.afterDeleteVertexEvents.size();
        for (int i = 0; i < max; ++i) {
            this.afterDeleteVertexEvents.get(i).fire(vc);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireBeforeCreateEdgeEvents(EdgeClass elementClass) {
        if (this.beforeCreateEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.beforeCreateEdgeEvents.size();
        for (int i = 0; i < max; ++i) {
            this.beforeCreateEdgeEvents.get(i).fire(elementClass);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireAfterCreateEdgeEvents(Edge element) {
        if (this.afterCreateEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.afterCreateEdgeEvents.size();
        for (int i = 0; i < max; ++i) {
            this.afterCreateEdgeEvents.get(i).fire(element);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireBeforeDeleteEdgeEvents(Edge element) {
        if (this.beforeDeleteEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.beforeDeleteEdgeEvents.size();
        for (int i = 0; i < max; ++i) {
            this.beforeDeleteEdgeEvents.get(i).fire(element);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireAfterDeleteEdgeEvents(EdgeClass ec, Vertex oldAlpha, Vertex oldOmega) {
        if (this.afterDeleteEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.afterDeleteEdgeEvents.size();
        for (int i = 0; i < max; ++i) {
            this.afterDeleteEdgeEvents.get(i).fire(ec, oldAlpha, oldOmega);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireBeforeChangeAlphaOfEdgeEvents(Edge element, Vertex oldVertex, Vertex newVertex) {
        if (this.beforeChangeAlphaOfEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.beforeChangeAlphaOfEdgeEvents.size();
        for (int i = 0; i < max; ++i) {
            this.beforeChangeAlphaOfEdgeEvents.get(i).fire(element, oldVertex, newVertex, ChangeEdgeEventDescription.EdgeEnd.ALPHA);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireAfterChangeAlphaOfEdgeEvents(Edge element, Vertex oldVertex, Vertex newVertex) {
        if (this.afterChangeAlphaOfEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.afterChangeAlphaOfEdgeEvents.size();
        for (int i = 0; i < max; ++i) {
            this.afterChangeAlphaOfEdgeEvents.get(i).fire(element, oldVertex, newVertex, ChangeEdgeEventDescription.EdgeEnd.ALPHA);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireBeforeChangeOmegaOfEdgeEvents(Edge element, Vertex oldVertex, Vertex newVertex) {
        if (this.beforeChangeOmegaOfEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.beforeChangeOmegaOfEdgeEvents.size();
        for (int i = 0; i < max; ++i) {
            this.beforeChangeOmegaOfEdgeEvents.get(i).fire(element, oldVertex, newVertex, ChangeEdgeEventDescription.EdgeEnd.OMEGA);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireAfterChangeOmegaOfEdgeEvents(Edge element, Vertex oldVertex, Vertex newVertex) {
        if (this.afterChangeOmegaOfEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.afterChangeOmegaOfEdgeEvents.size();
        for (int i = 0; i < max; ++i) {
            this.afterChangeOmegaOfEdgeEvents.get(i).fire(element, oldVertex, newVertex, ChangeEdgeEventDescription.EdgeEnd.OMEGA);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public <AEC extends AttributedElementClass<AEC, ?>> void fireBeforeChangeAttributeEvents(AttributedElement<AEC, ?> element, String attributeName, Object oldValue, Object newValue) {
        if (this.beforeChangeAttributeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.beforeChangeAttributeEvents.size();
        for (int i = 0; i < max; ++i) {
            ChangeAttributeEventDescription<?> ed = this.beforeChangeAttributeEvents.get(i);
            ed.fire(element, attributeName, oldValue, newValue);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public <AEC extends AttributedElementClass<AEC, ?>> void fireAfterChangeAttributeEvents(AttributedElement<AEC, ?> element, String attributeName, Object oldValue, Object newValue) {
        if (this.afterChangeAttributeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int max = this.afterChangeAttributeEvents.size();
        for (int i = 0; i < max; ++i) {
            ChangeAttributeEventDescription<?> ed = this.afterChangeAttributeEvents.get(i);
            ed.fire(element, attributeName, oldValue, newValue);
        }
        --this.nestedTriggerCalls;
    }

    private boolean increaseAndTestOnMaximumNestedCalls() {
        if (this.nestedTriggerCalls == 0) {
            this.blocked = false;
        }
        if (this.blocked) {
            return true;
        }
        ++this.nestedTriggerCalls;
        if (this.nestedTriggerCalls >= this.maxNestedTriggerCalls) {
            this.blocked = true;
            System.err.println("CAUTION: Maximum nested Trigger Calls arrived, Rule evaluation aborted. Stack will become cleaned up.");
            --this.nestedTriggerCalls;
            return true;
        }
        return false;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    public List<ECARule<?>> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    @Override
    public int getMaxNestedTriggerCalls() {
        return this.maxNestedTriggerCalls;
    }

    @Override
    public void setMaxNestedTriggerCalls(int maxNestedTriggerCalls) {
        this.maxNestedTriggerCalls = maxNestedTriggerCalls;
    }

    @Override
    public int getNestedTriggerCalls() {
        return this.nestedTriggerCalls;
    }

    public <AEC extends AttributedElementClass<AEC, ?>> void addECARule(EventDescription<AEC> event, Action<AEC> action) {
        ECARule<AEC> newRule = new ECARule<AEC>(event, action);
        this.addECARule(newRule);
    }

    public <AEC extends AttributedElementClass<AEC, ?>> void addECARule(EventDescription<AEC> event, Condition<AEC> condition, Action<AEC> action) {
        ECARule<AEC> newRule = new ECARule<AEC>(event, condition, action);
        this.addECARule(newRule);
    }

    public void addECARule(ECARule<?> rule) {
        if (rule.getECARuleManager() != null) {
            throw new ECAException("ERROR: Tried to add an ECARule to an ECARulemanager, but the ECARule has already a manager.");
        }
        EventDescription<?> ev = rule.getEventDescription();
        for (ECARule<?> temprule : ev.getActiveECARules()) {
            if (temprule.getECARuleManager() == this) continue;
            throw new ECAException("ERROR: Tried to add an ECARule to an ECARulemanager, but the Event part monitors already another Graph.");
        }
        this.rules.add(rule);
        rule.setECARuleManager(this);
        ev.addActiveRule(rule);
        if (ev instanceof CreateVertexEventDescription) {
            this.addEventToList((CreateVertexEventDescription)ev);
        }
        if (ev instanceof DeleteVertexEventDescription) {
            this.addEventToList((DeleteVertexEventDescription)ev);
        }
        if (ev instanceof CreateEdgeEventDescription) {
            this.addEventToList((CreateEdgeEventDescription)ev);
        }
        if (ev instanceof DeleteEdgeEventDescription) {
            this.addEventToList((DeleteEdgeEventDescription)ev);
        }
        if (ev instanceof ChangeEdgeEventDescription) {
            this.addEventToList((ChangeEdgeEventDescription)ev);
        }
        if (ev instanceof ChangeAttributeEventDescription) {
            this.addEventToList((ChangeAttributeEventDescription)ev);
        }
    }

    public void deleteECARule(ECARule<?> rule) {
        this.rules.remove(rule);
        rule.setECARuleManager(null);
        EventDescription<?> ev = rule.getEventDescription();
        ev.getActiveECARules().remove(rule);
        if (ev.getActiveECARules().isEmpty()) {
            if (ev instanceof CreateVertexEventDescription) {
                this.removeEventFromList((CreateVertexEventDescription)ev);
            }
            if (ev instanceof DeleteVertexEventDescription) {
                this.removeEventFromList((DeleteVertexEventDescription)ev);
            }
            if (ev instanceof CreateEdgeEventDescription) {
                this.removeEventFromList((CreateEdgeEventDescription)ev);
            }
            if (ev instanceof DeleteEdgeEventDescription) {
                this.removeEventFromList((DeleteEdgeEventDescription)ev);
            }
            if (ev instanceof ChangeEdgeEventDescription) {
                this.removeEventFromList((ChangeEdgeEventDescription)ev);
            }
            if (ev instanceof ChangeAttributeEventDescription) {
                this.removeEventFromList((ChangeAttributeEventDescription)ev);
            }
        }
    }

    private void addEventToList(CreateVertexEventDescription e) {
        if (e.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.createBeforeCreateVertexEventsLazily();
            if (!this.beforeCreateVertexEvents.contains(e)) {
                this.beforeCreateVertexEvents.add(e);
            }
        } else {
            this.createAfterCreateVertexEventsLazily();
            if (!this.afterCreateVertexEvents.contains(e)) {
                this.afterCreateVertexEvents.add(e);
            }
        }
    }

    private void addEventToList(DeleteVertexEventDescription e) {
        if (e.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.createBeforeDeleteVertexEventsLazily();
            if (!this.beforeDeleteVertexEvents.contains(e)) {
                this.beforeDeleteVertexEvents.add(e);
            }
        } else {
            this.createAfterDeleteVertexEventsLazily();
            if (!this.afterDeleteVertexEvents.contains(e)) {
                this.afterDeleteVertexEvents.add(e);
            }
        }
    }

    private void addEventToList(CreateEdgeEventDescription e) {
        if (e.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.createBeforeCreateEdgeEventsLazily();
            if (!this.beforeCreateEdgeEvents.contains(e)) {
                this.beforeCreateEdgeEvents.add(e);
            }
        } else {
            this.createAfterCreateEdgeEventsLazily();
            if (!this.afterCreateEdgeEvents.contains(e)) {
                this.afterCreateEdgeEvents.add(e);
            }
        }
    }

    private void addEventToList(DeleteEdgeEventDescription e) {
        if (e.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.createBeforeDeleteEdgeEventsLazily();
            if (!this.beforeDeleteEdgeEvents.contains(e)) {
                this.beforeDeleteEdgeEvents.add(e);
            }
        } else {
            this.createAfterDeleteEdgeEventsLazily();
            if (!this.afterDeleteEdgeEvents.contains(e)) {
                this.afterDeleteEdgeEvents.add(e);
            }
        }
    }

    private void addEventToList(ChangeEdgeEventDescription e) {
        if (e.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            if (e.getEdgeEnd().equals((Object)ChangeEdgeEventDescription.EdgeEnd.ALPHA)) {
                this.createBeforeChangeAlphaOfEdgeEventsLazily();
                if (!this.beforeChangeAlphaOfEdgeEvents.contains(e)) {
                    this.beforeChangeAlphaOfEdgeEvents.add(e);
                }
            } else if (e.getEdgeEnd().equals((Object)ChangeEdgeEventDescription.EdgeEnd.OMEGA)) {
                this.createBeforeChangeOmegaOfEdgeEventsLazily();
                if (!this.beforeChangeOmegaOfEdgeEvents.contains(e)) {
                    this.beforeChangeOmegaOfEdgeEvents.add(e);
                }
            } else {
                this.createBeforeChangeAlphaOfEdgeEventsLazily();
                this.createBeforeChangeOmegaOfEdgeEventsLazily();
                if (!this.beforeChangeAlphaOfEdgeEvents.contains(e)) {
                    this.beforeChangeAlphaOfEdgeEvents.add(e);
                }
                if (!this.beforeChangeOmegaOfEdgeEvents.contains(e)) {
                    this.beforeChangeOmegaOfEdgeEvents.add(e);
                }
            }
        } else if (e.getEdgeEnd().equals((Object)ChangeEdgeEventDescription.EdgeEnd.ALPHA)) {
            this.createAfterChangeAlphaOfEdgeEventsLazily();
            if (!this.afterChangeAlphaOfEdgeEvents.contains(e)) {
                this.afterChangeAlphaOfEdgeEvents.add(e);
            }
        } else if (e.getEdgeEnd().equals((Object)ChangeEdgeEventDescription.EdgeEnd.OMEGA)) {
            this.createAfterChangeOmegaOfEdgeEventsLazily();
            if (!this.afterChangeOmegaOfEdgeEvents.contains(e)) {
                this.afterChangeOmegaOfEdgeEvents.add(e);
            }
        } else {
            this.createAfterChangeAlphaOfEdgeEventsLazily();
            this.createAfterChangeOmegaOfEdgeEventsLazily();
            if (!this.afterChangeAlphaOfEdgeEvents.contains(e)) {
                this.afterChangeAlphaOfEdgeEvents.add(e);
            }
            if (!this.afterChangeOmegaOfEdgeEvents.contains(e)) {
                this.afterChangeOmegaOfEdgeEvents.add(e);
            }
        }
    }

    private <AEC extends AttributedElementClass<AEC, ?>> void addEventToList(ChangeAttributeEventDescription<AEC> e) {
        if (e.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.createBeforeChangeAttributeEventsLazily();
            if (!this.beforeChangeAttributeEvents.contains(e)) {
                this.beforeChangeAttributeEvents.add(e);
            }
        } else {
            this.createAfterChangeAttributeEventsLazily();
            if (!this.afterChangeAttributeEvents.contains(e)) {
                this.afterChangeAttributeEvents.add(e);
            }
        }
    }

    private void removeEventFromList(CreateVertexEventDescription ev) {
        if (ev.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.beforeCreateVertexEvents.remove(ev);
        } else {
            this.afterCreateVertexEvents.remove(ev);
        }
    }

    private void removeEventFromList(DeleteVertexEventDescription ev) {
        if (ev.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.beforeDeleteVertexEvents.remove(ev);
        } else {
            this.afterDeleteVertexEvents.remove(ev);
        }
    }

    private void removeEventFromList(CreateEdgeEventDescription ev) {
        if (ev.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.beforeCreateEdgeEvents.remove(ev);
        } else {
            this.afterCreateEdgeEvents.remove(ev);
        }
    }

    private void removeEventFromList(DeleteEdgeEventDescription ev) {
        if (ev.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.beforeDeleteEdgeEvents.remove(ev);
        } else {
            this.afterDeleteEdgeEvents.remove(ev);
        }
    }

    private void removeEventFromList(ChangeEdgeEventDescription ev) {
        if (ev.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.beforeChangeAlphaOfEdgeEvents.remove(ev);
            this.beforeChangeOmegaOfEdgeEvents.remove(ev);
        } else {
            this.afterChangeAlphaOfEdgeEvents.remove(ev);
            this.afterChangeOmegaOfEdgeEvents.remove(ev);
        }
    }

    private <AEC extends AttributedElementClass<AEC, ?>> void removeEventFromList(ChangeAttributeEventDescription<AEC> ev) {
        if (ev.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.beforeChangeAttributeEvents.remove(ev);
        } else {
            this.afterChangeAttributeEvents.remove(ev);
        }
    }
}

