/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.eca;

import de.uni_koblenz.jgralab.eca.Action;
import de.uni_koblenz.jgralab.eca.Condition;
import de.uni_koblenz.jgralab.eca.ECAIOException;
import de.uni_koblenz.jgralab.eca.ECARule;
import de.uni_koblenz.jgralab.eca.GreqlCondition;
import de.uni_koblenz.jgralab.eca.PrintAction;
import de.uni_koblenz.jgralab.eca.events.ChangeAttributeEventDescription;
import de.uni_koblenz.jgralab.eca.events.ChangeEdgeEventDescription;
import de.uni_koblenz.jgralab.eca.events.CreateEdgeEventDescription;
import de.uni_koblenz.jgralab.eca.events.CreateVertexEventDescription;
import de.uni_koblenz.jgralab.eca.events.DeleteEdgeEventDescription;
import de.uni_koblenz.jgralab.eca.events.DeleteVertexEventDescription;
import de.uni_koblenz.jgralab.eca.events.EventDescription;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.gretl.eca.GretlTransformAction;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ECAIO {
    private static final int BUFFER_SIZE = 65536;
    private Schema schema;
    private List<ECARule<?>> rules = new ArrayList();
    private BufferedInputStream inStream;
    private DataOutputStream outStream;
    int la;

    public static List<ECARule<?>> loadECArules(Schema schema, String filename) throws ECAIOException {
        List<ECARule<?>> list;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(filename), 65536);
            ECAIO ecaLoader = new ECAIO();
            ecaLoader.inStream = inputStream;
            ecaLoader.schema = schema;
            ecaLoader.load();
            list = ecaLoader.rules;
        }
        catch (IOException e) {
            try {
                throw new ECAIOException("Error while reading file " + filename);
            }
            catch (Throwable throwable) {
                ECAIO.close(inputStream);
                throw throwable;
            }
        }
        ECAIO.close(inputStream);
        return list;
    }

    public static void saveECArules(Schema schema, String filename, List<ECARule<?>> rules) throws ECAIOException {
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename), 65536));
            ECAIO ecaSaver = new ECAIO();
            ecaSaver.rules = rules;
            ecaSaver.schema = schema;
            ecaSaver.outStream = out;
            ecaSaver.save();
        }
        catch (IOException ex) {
            try {
                throw new ECAIOException("Error while saving ECA rules to " + filename);
            }
            catch (Throwable throwable) {
                ECAIO.close(out);
                throw throwable;
            }
        }
        ECAIO.close(out);
    }

    private ECAIO() {
    }

    private void save() throws ECAIOException {
        for (ECARule<?> rule : this.rules) {
            this.saveRule(rule);
        }
    }

    private void saveRule(ECARule<?> rule) throws ECAIOException {
        this.saveEventDescriptionToStream(rule.getEventDescription());
        if (rule.getCondition() != null) {
            this.saveConditionToStream(rule.getCondition());
        }
        this.saveActionToStream(rule.getAction());
    }

    private void saveEventDescriptionToStream(EventDescription<?> ev) throws ECAIOException {
        String eventDescriptionString = "";
        if (ev.getContext().equals((Object)EventDescription.Context.EXPRESSION)) {
            eventDescriptionString = eventDescriptionString + ev.getContextExpression();
            eventDescriptionString = eventDescriptionString + " : ";
        }
        eventDescriptionString = ev.getTime().equals((Object)EventDescription.EventTime.AFTER) ? eventDescriptionString + "after " : eventDescriptionString + "before ";
        eventDescriptionString = eventDescriptionString + this.getEventDescriptionType(ev);
        this.writeToStream(eventDescriptionString);
    }

    private String getEventDescriptionType(EventDescription<?> ev) {
        if (ev instanceof CreateVertexEventDescription) {
            return "createdVertex(" + this.getEventElementTypeString(ev) + ") ";
        }
        if (ev instanceof DeleteVertexEventDescription) {
            return "deletedVertex(" + this.getEventElementTypeString(ev) + ") ";
        }
        if (ev instanceof ChangeAttributeEventDescription) {
            return "updatedAttributeValue(" + this.getEventElementTypeString(ev) + ", " + ((ChangeAttributeEventDescription)ev).getConcernedAttribute() + ")";
        }
        if (ev instanceof ChangeEdgeEventDescription) {
            if (((ChangeEdgeEventDescription)ev).getEdgeEnd().equals((Object)ChangeEdgeEventDescription.EdgeEnd.ALPHA)) {
                return "updatedStartVertex(" + this.getEventElementTypeString(ev) + ") ";
            }
            if (((ChangeEdgeEventDescription)ev).getEdgeEnd().equals((Object)ChangeEdgeEventDescription.EdgeEnd.OMEGA)) {
                return "updatedEndVertex(" + this.getEventElementTypeString(ev) + ") ";
            }
            return "updatedStartOrEndVertex(" + this.getEventElementTypeString(ev) + ") ";
        }
        if (ev instanceof CreateEdgeEventDescription) {
            return "createdEdge(" + this.getEventElementTypeString(ev) + ") ";
        }
        return "deletedEdge(" + this.getEventElementTypeString(ev) + ") ";
    }

    private String getEventElementTypeString(EventDescription<?> ev) {
        String nameOfGraphElementClass = "";
        if (ev.getContext().equals((Object)EventDescription.Context.TYPE)) {
            nameOfGraphElementClass = nameOfGraphElementClass + ev.getType().getQualifiedName().replace(this.schema.getPackagePrefix() + ".", "");
        }
        return nameOfGraphElementClass;
    }

    private void saveConditionToStream(Condition<?> cond) throws ECAIOException {
        if (cond instanceof GreqlCondition) {
            this.writeToStream(" with \"" + ((GreqlCondition)cond).getConditionExpression() + "\" ");
        } else {
            this.writeToStream(" with class " + cond.getClass().getName() + " ");
        }
    }

    private void saveActionToStream(Action<?> act) throws ECAIOException {
        String actionstring = "do ";
        if (act instanceof PrintAction) {
            actionstring = actionstring + "print \"";
            actionstring = actionstring + ((PrintAction)act).getMessage();
            actionstring = actionstring + "\"";
            actionstring = actionstring + "\n";
        } else if (act instanceof GretlTransformAction) {
            GretlTransformAction gta = (GretlTransformAction)act;
            actionstring = actionstring + gta.getTransformationClass().getName();
        } else {
            actionstring = actionstring + act.getClass().getName();
        }
        this.writeToStream(actionstring);
    }

    private void writeToStream(String text) throws ECAIOException {
        try {
            this.outStream.writeChars(text);
        }
        catch (IOException e) {
            throw new ECAIOException("Error while writing " + text + " to stream.");
        }
    }

    private void load() throws ECAIOException {
        this.la = 0;
        while (this.la != -1) {
            this.parseRule();
            this.skipWs();
        }
    }

    private void parseRule() throws ECAIOException {
        EventDescription<?> ed = this.parseEventDescription();
        Condition<?> cond = this.parseCondition();
        Action<?> action = this.parseAction();
        if (cond == null) {
            this.rules.add(new ECARule(ed, action));
        } else {
            this.rules.add(new ECARule(ed, cond, action));
        }
    }

    private EventDescription<?> parseEventDescription() throws ECAIOException {
        String context = null;
        String currentToken = this.nextToken();
        String lookAheadToken = this.nextToken();
        if (lookAheadToken.equals(":")) {
            context = currentToken;
            currentToken = this.nextToken();
            lookAheadToken = this.nextToken();
        }
        EventDescription.EventTime et = this.getEventTime(currentToken);
        String eventdestype = lookAheadToken;
        String type = null;
        this.match("(");
        if (context == null) {
            type = this.nextToken();
        }
        if (eventdestype.equals("updatedAttributeValue")) {
            this.match(",");
            return this.finishChangeAttributeEventDescription(context, et, type);
        }
        this.match(")");
        if (eventdestype.equals("createdVertex")) {
            return this.finishCreateVertexEvent(context, et, type);
        }
        if (eventdestype.equals("createdEdge")) {
            return this.finishCreateEdgeEventDescription(context, et, type);
        }
        if (eventdestype.equals("updatedStartVertex")) {
            return this.finishChangeEdgeEventDescription(context, et, type, ChangeEdgeEventDescription.EdgeEnd.ALPHA);
        }
        if (eventdestype.equals("updatedEndVertex")) {
            return this.finishChangeEdgeEventDescription(context, et, type, ChangeEdgeEventDescription.EdgeEnd.OMEGA);
        }
        if (eventdestype.equals("updatedStartOrEndVertex")) {
            return this.finishChangeEdgeEventDescription(context, et, type, ChangeEdgeEventDescription.EdgeEnd.ANY);
        }
        if (eventdestype.equals("deletedVertex")) {
            return this.finishDeleteVertexEventDescription(context, et, type);
        }
        if (eventdestype.equals("deletedEdge")) {
            return this.finishDeleteEdgeEventDescription(context, et, type);
        }
        throw new ECAIOException("Type of EventDescription not recognized. Found " + eventdestype + " Possible are \"createVertex\", \"deleteVertex\", " + "\"createEdge\", \"deleteEdge\", " + "\"updatedStartVertex\", \"updatedEndVertex\", " + "\"updatedStartOrEndVertex\"" + "\"changeAttributeValue");
    }

    private EventDescription.EventTime getEventTime(String eventTimeString) throws ECAIOException {
        EventDescription.EventTime eventTime;
        if (eventTimeString.equals("after")) {
            eventTime = EventDescription.EventTime.AFTER;
        } else if (eventTimeString.equals("before")) {
            eventTime = EventDescription.EventTime.BEFORE;
        } else {
            throw new ECAIOException("EventTime expected. Possible are \"before\" and \"after\". Found: \"" + eventTimeString + "\" ");
        }
        return eventTime;
    }

    private EventDescription<EdgeClass> finishDeleteEdgeEventDescription(String context, EventDescription.EventTime eventTime, String qualNameOfGraphElementToMonitor) throws ECAIOException {
        if (context != null && qualNameOfGraphElementToMonitor == null) {
            return new DeleteEdgeEventDescription(eventTime, context);
        }
        if (context == null && qualNameOfGraphElementToMonitor != null) {
            return new DeleteEdgeEventDescription(eventTime, (EdgeClass)this.getAttributedElementClass(qualNameOfGraphElementToMonitor));
        }
        throw new ECAIOException("It's necessary to give a context OR a type. Its an XOR. Found: context: \"" + context + "\" and GraphElementType: \"" + qualNameOfGraphElementToMonitor + "\"");
    }

    private EventDescription<VertexClass> finishDeleteVertexEventDescription(String context, EventDescription.EventTime eventTime, String qualNameOfGraphElementToMonitor) throws ECAIOException {
        if (context != null && qualNameOfGraphElementToMonitor == null) {
            return new DeleteVertexEventDescription(eventTime, context);
        }
        if (context == null && qualNameOfGraphElementToMonitor != null) {
            return new DeleteVertexEventDescription(eventTime, (VertexClass)this.getAttributedElementClass(qualNameOfGraphElementToMonitor));
        }
        throw new ECAIOException("It's necessary to give a context OR a type. Its an XOR. Found: context: \"" + context + "\" and type: \"" + qualNameOfGraphElementToMonitor + "\"");
    }

    private EventDescription<EdgeClass> finishChangeEdgeEventDescription(String context, EventDescription.EventTime eventTime, String qualNameOfGraphElementToMonitor, ChangeEdgeEventDescription.EdgeEnd edgeEnd) throws ECAIOException {
        if (context != null && qualNameOfGraphElementToMonitor == null) {
            return new ChangeEdgeEventDescription(eventTime, context);
        }
        if (context == null && qualNameOfGraphElementToMonitor != null) {
            return new ChangeEdgeEventDescription(eventTime, (EdgeClass)this.getAttributedElementClass(qualNameOfGraphElementToMonitor), edgeEnd);
        }
        throw new ECAIOException("It's necessary to give a context OR a type. Its an XOR. Found: context: \"" + context + "\" and type: \"" + qualNameOfGraphElementToMonitor + "\"");
    }

    private EventDescription<?> finishChangeAttributeEventDescription(String context, EventDescription.EventTime eventTime, String qualNameOfGraphElementToMonitor) throws ECAIOException {
        String name = this.nextToken();
        this.match(")");
        if (context != null && qualNameOfGraphElementToMonitor == null) {
            return new ChangeAttributeEventDescription(eventTime, context, name);
        }
        if (context == null && qualNameOfGraphElementToMonitor != null) {
            return new ChangeAttributeEventDescription(eventTime, this.getAttributedElementClass(qualNameOfGraphElementToMonitor), name);
        }
        throw new ECAIOException("It's necessary to give a context OR a type. Its an XOR. Found: context: \"" + context + "\" and type: \"" + qualNameOfGraphElementToMonitor + "\"");
    }

    private EventDescription<EdgeClass> finishCreateEdgeEventDescription(String context, EventDescription.EventTime eventTime, String qualNameOfGraphElementToMonitor) throws ECAIOException {
        if (context != null && qualNameOfGraphElementToMonitor == null) {
            return new CreateEdgeEventDescription(eventTime, context);
        }
        if (context == null && qualNameOfGraphElementToMonitor != null) {
            return new CreateEdgeEventDescription(eventTime, (EdgeClass)this.getAttributedElementClass(qualNameOfGraphElementToMonitor));
        }
        throw new ECAIOException("It's necessary to give a context OR a type. Its an XOR. Found: context: \"" + context + "\" and type: \"" + qualNameOfGraphElementToMonitor + "\"");
    }

    private EventDescription<VertexClass> finishCreateVertexEvent(String context, EventDescription.EventTime eventTime, String qualNameOfGraphElementToMonitor) throws ECAIOException {
        if (context != null && qualNameOfGraphElementToMonitor == null) {
            return new CreateVertexEventDescription(eventTime, context);
        }
        if (context == null && qualNameOfGraphElementToMonitor != null) {
            return new CreateVertexEventDescription(eventTime, (VertexClass)this.getAttributedElementClass(qualNameOfGraphElementToMonitor));
        }
        throw new ECAIOException("It's necessary to give a context OR a type. Its an XOR. Found: context: \"" + context + "\" and type: \"" + qualNameOfGraphElementToMonitor + "\"");
    }

    private AttributedElementClass<?, ?> getAttributedElementClass(String name) {
        return this.schema.getAttributedElementClass(name);
    }

    private Condition<?> parseCondition() throws ECAIOException {
        String currentToken = this.nextToken();
        if (this.isMatching(currentToken, "do")) {
            return null;
        }
        if (this.isMatching(currentToken, "with")) {
            String condexpr = this.nextToken();
            if (condexpr.equals("class")) {
                Condition cond;
                condexpr = this.nextToken();
                try {
                    Condition c;
                    System.out.println("classname: " + condexpr);
                    Class<?> conditionclass = Class.forName(condexpr);
                    cond = c = (Condition)conditionclass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new ECAIOException("Specified Condition " + currentToken + " not found.");
                }
                catch (InstantiationException e) {
                    throw new ECAIOException("Error while instanciating Condition " + currentToken);
                }
                catch (IllegalAccessException e) {
                    throw new ECAIOException("Error while instanciating Condition " + currentToken);
                }
                this.match("do");
                return cond;
            }
            this.match("do");
            return new GreqlCondition(condexpr);
        }
        throw new ECAIOException("Parsing Error. Expected \"do\" or \"with\". Found: \"" + currentToken + "\"");
    }

    private Action<?> parseAction() throws ECAIOException {
        String currentToken = this.nextToken();
        if (this.isMatching("print", currentToken)) {
            String message = this.nextToken();
            return new PrintAction(message);
        }
        try {
            Class<?> actionclass = Class.forName(currentToken);
            if (actionclass.getSuperclass().equals(Transformation.class)) {
                return new GretlTransformAction(actionclass);
            }
            return (Action)actionclass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ECAIOException("Specified Action " + currentToken + " not found.");
        }
        catch (InstantiationException e) {
            throw new ECAIOException("Error while instanciating Action " + currentToken);
        }
        catch (IllegalAccessException e) {
            throw new ECAIOException("Error while instanciating Action " + currentToken);
        }
    }

    private boolean isMatching(String one, String two) {
        return one.equals(two);
    }

    private void match(String expected) throws ECAIOException {
        String token = this.nextToken();
        if (!token.equals(expected)) {
            throw new ECAIOException("Parsing Error: Expected \"" + expected + "\" Found: \"" + token + "\"");
        }
    }

    private String nextToken() throws ECAIOException {
        StringBuilder out = new StringBuilder();
        try {
            this.skipWs();
            if (this.la == 34) {
                this.readUtfString(out);
            } else if (this.isUnitSymbol(this.la)) {
                out.append((char)this.la);
                this.la = this.inStream.read();
            } else if (this.la != -1) {
                do {
                    out.append((char)this.la);
                    this.la = this.inStream.read();
                } while (!this.isWs(this.la) && !this.isUnitSymbol(this.la) && this.la != -1);
            }
        }
        catch (IOException e) {
            throw new ECAIOException("Error while reading next token from stream.");
        }
        return this.myTrim0(out.toString());
    }

    private final void skipWs() throws ECAIOException {
        while (this.isWs(this.la) || this.la == 0) {
            try {
                this.la = this.inStream.read();
            }
            catch (IOException e) {
                throw new ECAIOException("Error while reading from stream.");
            }
        }
    }

    private String myTrim0(String x) {
        char[] ar = x.toCharArray();
        String ex = "";
        for (int i = 0; i < ar.length; ++i) {
            if (ar[i] == '\u0000') continue;
            ex = ex + ar[i];
        }
        return ex;
    }

    private boolean isWs(int c) {
        return c == 32 || c == 10 || c == 9 || c == 13;
    }

    private boolean isUnitSymbol(int c) {
        return c == 62 || c == 60 || c == 40 || c == 41 || c == 44;
    }

    private final void readUtfString(StringBuilder out) throws IOException {
        this.la = this.inStream.read();
        block10: while (this.la != -1 && this.la != 34) {
            if (this.la == 0) {
                this.la = this.inStream.read();
                continue;
            }
            if (this.la < 32 || this.la > 127) {
                throw new RuntimeException("invalid character '" + (char)this.la + "'");
            }
            if (this.la == 92) {
                this.la = this.inStream.read();
                if (this.la == -1) break;
                switch (this.la) {
                    case 92: {
                        this.la = 92;
                        break;
                    }
                    case 34: {
                        this.la = 34;
                        break;
                    }
                    case 110: {
                        this.la = 10;
                        break;
                    }
                    case 114: {
                        this.la = 13;
                        break;
                    }
                    case 116: {
                        this.la = 9;
                        break;
                    }
                    case 117: {
                        this.la = this.inStream.read();
                        if (this.la == -1) break block10;
                        String unicode = "" + (char)this.la;
                        this.la = this.inStream.read();
                        if (this.la == -1) break block10;
                        unicode = unicode + (char)this.la;
                        this.la = this.inStream.read();
                        if (this.la == -1) break block10;
                        unicode = unicode + (char)this.la;
                        this.la = this.inStream.read();
                        if (this.la == -1) break block10;
                        unicode = unicode + (char)this.la;
                        try {
                            this.la = Integer.parseInt(unicode, 16);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException("invalid unicode escape sequence '\\u" + unicode);
                        }
                    }
                    default: {
                        throw new RuntimeException("invalid escape sequence in string");
                    }
                }
            }
            out.append((char)this.la);
            this.la = this.inStream.read();
        }
        this.la = this.inStream.read();
    }

    private static void close(Closeable stream) throws ECAIOException {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ex) {
            throw new ECAIOException("Exception while closing the stream.", ex);
        }
    }
}

