/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.visitors;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.visitors.GraphVisitor;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;
import de.uni_koblenz.jgralab.algolib.visitors.VisitorList;
import java.util.ArrayList;
import java.util.List;

public class GraphVisitorList
extends VisitorList
implements GraphVisitor {
    private List<GraphVisitor> visitors = new ArrayList<GraphVisitor>();

    @Override
    public void addVisitor(Visitor visitor) {
        super.addVisitor(visitor);
        if (visitor instanceof GraphVisitor && !this.visitors.contains(visitor)) {
            this.visitors.add((GraphVisitor)visitor);
        }
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        super.removeVisitor(visitor);
        if (visitor instanceof GraphVisitor) {
            this.visitors.remove(visitor);
        }
    }

    @Override
    public void clearVisitors() {
        super.clearVisitors();
        this.visitors.clear();
    }

    @Override
    public void visitEdge(Edge e) throws AlgorithmTerminatedException {
        int n = this.visitors.size();
        for (int i = 0; i < n; ++i) {
            this.visitors.get(i).visitEdge(e);
        }
    }

    @Override
    public void visitVertex(Vertex v) throws AlgorithmTerminatedException {
        int n = this.visitors.size();
        for (int i = 0; i < n; ++i) {
            this.visitors.get(i).visitVertex(v);
        }
    }
}

