/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.functions;

import de.uni_koblenz.jgralab.algolib.functions.Permutation;
import de.uni_koblenz.jgralab.algolib.functions.entries.PermutationEntry;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayPermutation<RANGE>
implements Permutation<RANGE> {
    private RANGE[] values;
    private int length;

    public ArrayPermutation(RANGE[] values) {
        int i;
        this.values = values;
        for (i = 1; i < values.length && values[i] != null; ++i) {
        }
        this.length = values.length <= 1 ? 0 : i - 1;
    }

    @Override
    public RANGE get(int parameter) {
        return this.values[parameter];
    }

    @Override
    public boolean isDefined(int parameter) {
        assert (parameter <= 0 || parameter > this.length || this.values[parameter] != null);
        return parameter > 0 && parameter <= this.length;
    }

    @Override
    public void add(RANGE value) {
        throw new UnsupportedOperationException("This permutation is immutable.");
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    public RANGE[] getArray() {
        return this.values;
    }

    @Override
    public Iterable<RANGE> getRangeElements() {
        return new Iterable<RANGE>(){

            @Override
            public Iterator<RANGE> iterator() {
                return new ArrayIterator<RANGE>(){

                    @Override
                    public RANGE next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException("There are no more elements.");
                        }
                        return ArrayPermutation.this.values[this.i++];
                    }
                };
            }
        };
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public Iterator<PermutationEntry<RANGE>> iterator() {
        return new ArrayIterator<PermutationEntry<RANGE>>(){

            @Override
            public PermutationEntry<RANGE> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("There are no more elements.");
                }
                return new PermutationEntry<Object>(this.i, ArrayPermutation.this.values[this.i++]);
            }
        };
    }

    private abstract class ArrayIterator<T>
    implements Iterator<T> {
        protected int i = 1;

        protected ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i <= ArrayPermutation.this.length;
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not allow the removal of objects.");
        }
    }
}

