/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.shortest_paths;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.DoubleFunction;
import de.uni_koblenz.jgralab.algolib.functions.Function;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.problems.DistanceFromVertexToVertexSolver;
import de.uni_koblenz.jgralab.algolib.problems.DistancesFromVertexSolver;
import de.uni_koblenz.jgralab.algolib.problems.ShortestPathFromVertexToVertexSolver;
import de.uni_koblenz.jgralab.algolib.problems.ShortestPathsFromVertexSolver;
import de.uni_koblenz.jgralab.algolib.problems.TraversalSolver;
import de.uni_koblenz.jgralab.algolib.problems.WeightedProblemSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;
import de.uni_koblenz.jgralab.graphmarker.ArrayVertexMarker;
import de.uni_koblenz.jgralab.graphmarker.DoubleVertexMarker;
import de.uni_koblenz.jgralab.graphmarker.IntegerVertexMarker;
import java.util.LinkedList;
import java.util.Queue;

public class FordMooreAlgorithm
extends StructureOrientedAlgorithm
implements WeightedProblemSolver,
TraversalSolver,
DistancesFromVertexSolver,
ShortestPathsFromVertexSolver,
DistanceFromVertexToVertexSolver,
ShortestPathFromVertexToVertexSolver {
    private DoubleFunction<Edge> edgeWeight;
    private Vertex target;
    private Function<Vertex, Edge> parent;
    private DoubleFunction<Vertex> distance;
    private Queue<Vertex> vertexQueue;
    private IntFunction<Vertex> pushCount;
    private int maxPushCount;
    private boolean negativeCycleDetected;

    public FordMooreAlgorithm(Graph graph, BooleanFunction<Edge> navigable, DoubleFunction<Edge> weight) {
        super(graph, navigable);
        this.edgeWeight = weight;
    }

    public FordMooreAlgorithm(Graph graph) {
        this(graph, null, null);
    }

    @Override
    public void setEdgeWeight(DoubleFunction<Edge> edgeWeight) {
        this.checkStateForSettingParameters();
        this.edgeWeight = edgeWeight;
    }

    @Override
    public void disableOptionalResults() {
    }

    @Override
    protected void done() {
        this.state = AlgorithmStates.FINISHED;
    }

    @Override
    public FordMooreAlgorithm normal() {
        super.normal();
        return this;
    }

    @Override
    public FordMooreAlgorithm reversed() {
        super.reversed();
        return this;
    }

    @Override
    public FordMooreAlgorithm undirected() {
        super.undirected();
        return this;
    }

    @Override
    public boolean isHybrid() {
        return true;
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        throw new UnsupportedOperationException("This algorithm currently doesn't support visitors!");
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        throw new UnsupportedOperationException("This algorithm currently doesn't support visitors!");
    }

    @Override
    public void reset() {
        super.reset();
        this.parent = new ArrayVertexMarker<Edge>(this.graph);
        this.distance = new DoubleVertexMarker(this.graph);
        for (Vertex v : this.graph.vertices()) {
            this.distance.set(v, Double.POSITIVE_INFINITY);
        }
        this.vertexQueue = this.vertexQueue == null ? new LinkedList() : this.vertexQueue;
        this.vertexQueue.clear();
        this.pushCount = new IntegerVertexMarker(this.graph);
        this.maxPushCount = this.graph.getVCount() - 1;
        this.negativeCycleDetected = false;
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.edgeWeight = null;
        this.traversalDirection = EdgeDirection.OUT;
    }

    @Override
    public FordMooreAlgorithm execute(Vertex start) throws AlgorithmTerminatedException {
        this.startRunning();
        for (Vertex currentVertex : this.graph.vertices()) {
            this.pushCount.set(currentVertex, 0);
        }
        this.distance.set(start, 0.0);
        this.vertexQueue.add(start);
        this.pushCount.set(start, this.pushCount.get(start) + 1);
        while (!this.vertexQueue.isEmpty()) {
            Vertex currentVertex = this.vertexQueue.poll();
            assert (currentVertex != null);
            for (Edge currentEdge : currentVertex.incidences(this.traversalDirection)) {
                this.cancelIfInterrupted();
                if (this.navigable != null && !this.navigable.get(currentEdge)) continue;
                Vertex nextVertex = currentEdge.getThat();
                double d = this.distance.get(currentVertex);
                double d2 = this.edgeWeight == null ? 1.0 : this.edgeWeight.get(currentEdge);
                double newDistance = d + d2;
                if (!(newDistance < this.distance.get(nextVertex))) continue;
                this.parent.set(nextVertex, currentEdge);
                this.distance.set(nextVertex, newDistance);
                int newCount = this.pushCount.get(nextVertex) + 1;
                if (newCount > this.maxPushCount) {
                    this.negativeCycleDetected = true;
                    this.terminate();
                }
                this.pushCount.set(nextVertex, newCount);
                this.vertexQueue.add(nextVertex);
            }
        }
        this.done();
        return this;
    }

    @Override
    public FordMooreAlgorithm execute(Vertex start, Vertex target) throws AlgorithmTerminatedException {
        this.target = target;
        return this.execute(start);
    }

    @Override
    public DoubleFunction<Vertex> getDistance() {
        this.checkStateForResult();
        return this.distance;
    }

    public DoubleFunction<Vertex> getInternalDistance() {
        return this.distance;
    }

    @Override
    public double getDistanceToTarget() {
        this.checkStateForResult();
        if (this.target != null) {
            return this.distance.get(this.target);
        }
        throw new UnsupportedOperationException("No target vertex specified or wrong execute method used.");
    }

    @Override
    public Function<Vertex, Edge> getParent() {
        this.checkStateForResult();
        return this.parent;
    }

    public Function<Vertex, Edge> getInternalParent() {
        return this.parent;
    }

    public boolean hasNegativeCycleDetected() {
        return this.negativeCycleDetected;
    }

    public int getMaxPushCount() {
        return this.maxPushCount;
    }

    public Queue<Vertex> getVertexQueue() {
        return this.vertexQueue;
    }

    public IntFunction<Vertex> getPushCount() {
        return this.pushCount;
    }
}

