/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.shortest_paths;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.SearchVisitorAdapter;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.SearchVisitorList;
import de.uni_koblenz.jgralab.algolib.functions.BinaryDoubleFunction;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.DoubleFunction;
import de.uni_koblenz.jgralab.algolib.functions.Function;
import de.uni_koblenz.jgralab.algolib.problems.DistanceFromVertexToVertexSolver;
import de.uni_koblenz.jgralab.algolib.problems.ShortestPathFromVertexToVertexSolver;
import de.uni_koblenz.jgralab.algolib.problems.WeightedProblemSolver;
import de.uni_koblenz.jgralab.algolib.util.PriorityQueue;
import de.uni_koblenz.jgralab.algolib.visitors.GraphVisitorAdapter;
import de.uni_koblenz.jgralab.algolib.visitors.GraphVisitorList;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;
import de.uni_koblenz.jgralab.graphmarker.ArrayVertexMarker;
import de.uni_koblenz.jgralab.graphmarker.BitSetVertexMarker;
import de.uni_koblenz.jgralab.graphmarker.DoubleVertexMarker;

public class AStarSearch
extends StructureOrientedAlgorithm
implements DistanceFromVertexToVertexSolver,
ShortestPathFromVertexToVertexSolver,
WeightedProblemSolver {
    protected DoubleFunction<Vertex> weightedDistance;
    protected BooleanFunction<Vertex> visitedVertices;
    protected Function<Vertex, Edge> parent;
    protected DoubleFunction<Edge> edgeWeight;
    private BinaryDoubleFunction<Vertex, Vertex> heuristic;
    protected Vertex target;
    protected GraphVisitorAdapter targetVertexReachedVisitor;
    protected PriorityQueue<Vertex> vertexQueue;
    protected GraphVisitorList visitors;

    public AStarSearch(Graph graph, BooleanFunction<Edge> navigable, DoubleFunction<Edge> edgeWeight, BinaryDoubleFunction<Vertex, Vertex> heuristic) {
        super(graph, navigable);
        this.edgeWeight = edgeWeight;
        this.heuristic = heuristic;
    }

    public AStarSearch(Graph graph) {
        this(graph, null, null, null);
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        visitor.setAlgorithm(this);
        this.visitors.addVisitor(visitor);
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        this.visitors.removeVisitor(visitor);
    }

    @Override
    public void disableOptionalResults() {
    }

    @Override
    public AStarSearch normal() {
        super.normal();
        return this;
    }

    @Override
    public AStarSearch reversed() {
        super.reversed();
        return this;
    }

    @Override
    public AStarSearch undirected() {
        super.undirected();
        return this;
    }

    @Override
    public boolean isHybrid() {
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.visitors.reset();
        this.weightedDistance = new DoubleVertexMarker(this.graph);
        for (Vertex v : this.graph.vertices()) {
            this.weightedDistance.set(v, Double.POSITIVE_INFINITY);
        }
        this.visitedVertices = new BitSetVertexMarker(this.graph);
        this.parent = new ArrayVertexMarker<Edge>(this.graph);
        this.vertexQueue = this.vertexQueue == null ? new PriorityQueue() : this.vertexQueue.clear();
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.visitors = new SearchVisitorList();
        this.targetVertexReachedVisitor = new SearchVisitorAdapter(){

            @Override
            public void visitVertex(Vertex v) throws AlgorithmTerminatedException {
                if (AStarSearch.this.target == v) {
                    AStarSearch.this.terminate();
                }
            }
        };
    }

    @Override
    public void setEdgeWeight(DoubleFunction<Edge> edgeWeight) {
        this.checkStateForSettingParameters();
        this.edgeWeight = edgeWeight;
    }

    public void setHeuristic(BinaryDoubleFunction<Vertex, Vertex> heuristic) {
        this.checkStateForSettingParameters();
        this.heuristic = heuristic;
    }

    @Override
    public AStarSearch execute(Vertex start, Vertex target) throws AlgorithmTerminatedException {
        TraversalContext subgraph = this.graph.getTraversalContext();
        if (subgraph != null && !subgraph.containsVertex(target)) {
            throw new IllegalArgumentException("Target vertex not in subgraph!");
        }
        this.target = target;
        this.visitors.addVisitor(this.targetVertexReachedVisitor);
        this.internalExecute(start, target);
        this.visitors.removeVisitor(this.targetVertexReachedVisitor);
        return this;
    }

    protected void internalExecute(Vertex start, Vertex target) throws AlgorithmTerminatedException {
        TraversalContext subgraph = this.graph.getTraversalContext();
        if (subgraph != null && !subgraph.containsVertex(start)) {
            throw new IllegalArgumentException("Start vertex not in subgraph!");
        }
        this.startRunning();
        this.weightedDistance.set(start, 0.0);
        this.vertexQueue.put(start, 0.0);
        while (!this.vertexQueue.isEmpty()) {
            Vertex currentVertex = this.vertexQueue.getNext();
            if (this.visitedVertices.get(currentVertex)) continue;
            this.visitors.visitVertex(currentVertex);
            this.visitedVertices.set(currentVertex, true);
            for (Edge currentEdge : currentVertex.incidences(this.traversalDirection)) {
                this.cancelIfInterrupted();
                if (this.navigable != null && !this.navigable.get(currentEdge)) continue;
                Vertex nextVertex = currentEdge.getThat();
                double newDistance = this.weightedDistance.get(currentVertex) + (this.edgeWeight == null ? 1.0 : this.edgeWeight.get(currentEdge));
                this.visitors.visitEdge(currentEdge);
                if (!(this.weightedDistance.get(nextVertex) > newDistance)) continue;
                this.parent.set(nextVertex, currentEdge);
                this.weightedDistance.set(nextVertex, newDistance);
                this.vertexQueue.put(nextVertex, newDistance + (this.heuristic == null ? 0.0 : this.heuristic.get(nextVertex, target)));
            }
        }
        this.done();
    }

    @Override
    public void done() {
        this.state = AlgorithmStates.FINISHED;
    }

    @Override
    public double getDistanceToTarget() {
        this.checkStateForResult();
        if (this.target != null) {
            return this.weightedDistance.get(this.target);
        }
        throw new UnsupportedOperationException("No target vertex specified or wrong execute method used.");
    }

    @Override
    public Function<Vertex, Edge> getParent() {
        this.checkStateForResult();
        return this.parent;
    }

    public Function<Vertex, Edge> getInternalParent() {
        return this.parent;
    }

    public PriorityQueue<Vertex> getVertexQueue() {
        return this.vertexQueue;
    }

    public BooleanFunction<Vertex> visitedVertices() {
        return this.visitedVertices;
    }

    public DoubleFunction<Vertex> getDistance() {
        return this.weightedDistance;
    }
}

