/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.algolib.algorithms.GraphAlgorithm;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.problems.TraversalSolver;

public abstract class StructureOrientedAlgorithm
extends GraphAlgorithm
implements TraversalSolver {
    public static final EdgeDirection DEFAULT_TRAVERSAL_DIRECTION = EdgeDirection.OUT;
    protected BooleanFunction<Edge> navigable;
    protected EdgeDirection traversalDirection;

    public StructureOrientedAlgorithm(Graph graph, BooleanFunction<Edge> navigable) {
        super(graph);
        this.navigable = navigable;
    }

    @Override
    public void setNavigable(BooleanFunction<Edge> navigable) {
        this.checkStateForSettingParameters();
        this.navigable = navigable;
        this.reset();
    }

    public void setTraversalDirection(EdgeDirection traversalDirection) {
        this.checkStateForSettingParameters();
        assert (traversalDirection != null);
        if (!this.isHybrid()) {
            if (this.isDirected() && traversalDirection == EdgeDirection.INOUT) {
                throw new UnsupportedOperationException("This algorithm does not support undirected graphs.");
            }
            if (!this.isDirected() && traversalDirection != EdgeDirection.INOUT) {
                throw new UnsupportedOperationException("This algorithm does not support directed graphs.");
            }
        }
        this.traversalDirection = traversalDirection;
    }

    public EdgeDirection getTraversalDirection() {
        return this.traversalDirection;
    }

    public BooleanFunction<Edge> getNavigable() {
        return this.navigable;
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.navigable = null;
        this.traversalDirection = DEFAULT_TRAVERSAL_DIRECTION;
    }

    public StructureOrientedAlgorithm normal() {
        this.setTraversalDirection(EdgeDirection.OUT);
        return this;
    }

    public StructureOrientedAlgorithm reversed() {
        this.setTraversalDirection(EdgeDirection.IN);
        return this;
    }

    public StructureOrientedAlgorithm undirected() {
        this.setTraversalDirection(EdgeDirection.INOUT);
        return this;
    }

    @Override
    public boolean isDirected() {
        return this.traversalDirection != EdgeDirection.INOUT;
    }
}

