/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.plist;

import de.uni_koblenz.ist.utilities.plist.PList;
import de.uni_koblenz.ist.utilities.plist.PListDict;
import de.uni_koblenz.ist.utilities.xml.XmlProcessor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Stack;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;

class PListProcessor
extends XmlProcessor {
    private PListDict dict;
    private Stack<StackEntry> objectStack;

    PListProcessor() {
    }

    @Override
    protected void startElement(String name) throws XMLStreamException {
        StackEntry e = new StackEntry();
        e.tag = name;
        if (e.tag.equals("dict")) {
            e.dict = new PListDict();
        } else if (e.tag.equals("array")) {
            e.array = new Vector();
        }
        this.objectStack.push(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void endElement(String name, StringBuilder content) throws XMLStreamException {
        StackEntry e = this.objectStack.pop();
        StackEntry top = null;
        if (this.objectStack.size() > 0) {
            top = this.objectStack.peek();
        }
        if (e.tag.equals("string")) {
            e.value = content.toString();
        } else if (e.tag.equals("key")) {
            top.lastKey = content.toString();
        } else if (e.tag.equals("integer")) {
            e.value = Integer.parseInt(content.toString());
        } else if (e.tag.equals("real")) {
            e.value = Double.parseDouble(content.toString());
        } else if (e.tag.equals("date")) {
            try {
                DateFormat dateFormat = PList.dateFormat;
                synchronized (dateFormat) {
                    e.value = PList.dateFormat.parse(content.toString());
                }
            }
            catch (ParseException e1) {
                e.value = null;
            }
        } else {
            if (e.tag.equals("data")) {
                throw new XMLStreamException("property list element 'data' not yet implemented");
            }
            if (e.tag.equals("true")) {
                e.value = true;
            } else if (e.tag.equals("false")) {
                e.value = false;
            } else if (e.tag.equals("dict")) {
                e.value = e.dict;
            } else if (e.tag.equals("array")) {
                e.value = e.array;
            }
        }
        if (top != null) {
            if (top.dict != null && top.lastKey != null && !e.tag.equals("key")) {
                top.dict.put(top.lastKey, e.value);
                top.lastKey = null;
            } else if (top.array != null) {
                top.array.add(e.value);
            } else if (top.tag.equals("plist")) {
                this.dict = (PListDict)e.value;
            }
        }
    }

    @Override
    protected void startDocument() throws XMLStreamException {
        this.objectStack = new Stack();
    }

    @Override
    protected void endDocument() throws XMLStreamException {
        this.objectStack = null;
    }

    public PListDict getDict() {
        return this.dict;
    }

    private static class StackEntry {
        String tag;
        String lastKey;
        PListDict dict;
        Vector<Object> array;
        Object value;

        private StackEntry() {
        }
    }
}

