/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.csvreader;

import de.uni_koblenz.ist.utilities.csvreader.CsvReaderException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class CsvReader {
    public static final int WITHOUT_FIELDNAMES = 0;
    public static final int WITH_FIELDNAMES = 1;
    private static final Pattern commentLine = Pattern.compile("^\\s*#.*$");
    private LineNumberReader reader;
    private ArrayList<String> fieldNames;
    private ArrayList<String> currentRecord;
    private String separators;
    private String quote;
    private char stringDelimiter = (char)34;
    private boolean quoting;

    public CsvReader(Reader in, int withFieldNames) throws IOException {
        this(in, ";", "", withFieldNames);
    }

    public CsvReader(Reader in) throws IOException {
        this(in, ";", "", 0);
    }

    public CsvReader(Reader in, String separators, String quote) throws IOException {
        this(in, separators, quote, 0);
    }

    public CsvReader(Reader in, String separators, String quote, int withFieldNames) throws IOException {
        this.reader = new LineNumberReader(in);
        this.separators = separators;
        this.quote = quote;
        this.currentRecord = new ArrayList();
        boolean bl = this.quoting = !quote.equals("");
        if (withFieldNames == 1) {
            this.readFieldNames();
        }
    }

    public int getLineNumber() {
        return this.reader.getLineNumber();
    }

    public void readFieldNames() throws IOException {
        if (this.readRecord()) {
            this.fieldNames = new ArrayList<String>(this.currentRecord);
        }
    }

    public boolean readRecord() throws IOException {
        String line;
        do {
            if ((line = this.reader.readLine()) != null) continue;
            return false;
        } while (commentLine.matcher(line).matches());
        this.currentRecord.clear();
        StringTokenizer st = new StringTokenizer(line, this.separators + this.quote, true);
        StringBuilder field = new StringBuilder();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (this.quoting && s.equals(this.quote)) {
                if (!st.hasMoreTokens()) continue;
                s = st.nextToken();
                field.append(s);
                continue;
            }
            if (this.separators.indexOf(s) >= 0) {
                this.currentRecord.add(this.removeStringDelimiters(field));
                field = new StringBuilder();
                continue;
            }
            field.append(s);
        }
        this.currentRecord.add(this.removeStringDelimiters(field));
        return true;
    }

    public String removeStringDelimiters(StringBuilder field) {
        String val = field.toString().trim();
        if (val.length() > 0) {
            if (val.charAt(0) == this.stringDelimiter) {
                val = val.substring(1);
            }
            if (val.length() > 0 && val.charAt(val.length() - 1) == this.stringDelimiter) {
                val = val.substring(0, val.length() - 1);
            }
        }
        return val;
    }

    public String getFieldByName(String name) throws CsvReaderException {
        if (this.fieldNames == null) {
            throw new CsvReaderException("field name lookup disabled because field names were not read");
        }
        int index = this.fieldNames.indexOf(name);
        if (index < 0) {
            throw new NoSuchElementException("unknown field name: \"" + name + "\"");
        }
        return this.currentRecord.get(index);
    }

    public String getFieldAt(int index) {
        return this.currentRecord.get(index);
    }

    public int getFieldCount() {
        return this.currentRecord.size();
    }

    public List<String> getCurrentRecord() {
        return new ArrayList<String>(this.currentRecord);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

