/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.ant;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.resources.FileResource;

public class MetaDataPreservingUnjar
extends Task {
    private Set<File> jarFiles = new HashSet<File>();
    private String metaDir = "META-INF";
    private File dest;

    public void setDest(File dest) {
        this.dest = dest;
    }

    public void addConfiguredFileset(FileSet files) {
        for (Object current : files) {
            if (!(current instanceof FileResource)) continue;
            File currentFile = ((FileResource)current).getFile();
            this.jarFiles.add(currentFile);
        }
    }

    public void execute() {
        PatternSet exclude = new PatternSet();
        exclude.setExcludes(this.metaDir + "/**");
        for (File currentFile : this.jarFiles) {
            Expand unjarClasses = new Expand();
            unjarClasses.setSrc(currentFile);
            unjarClasses.setDest(this.dest);
            unjarClasses.addPatternset(exclude);
            unjarClasses.execute();
            File metaSubDir = new File(this.dest.getAbsolutePath() + File.separator + this.metaDir + File.separator + currentFile.getName());
            metaSubDir.mkdirs();
            PatternSet include = new PatternSet();
            include.setIncludes(this.metaDir + "/**");
            Expand unjar = new Expand();
            unjar.setSrc(currentFile);
            unjar.setDest(metaSubDir);
            unjar.addPatternset(include);
            unjar.execute();
        }
    }
}

