/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgraphbrowser;

import de.uni_koblenz.jgralab.utilities.tgraphbrowser.StateRepository;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TGraphBrowserServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RequestThread
extends Thread {
    static final String SVG_WITH_ZOOM_AND_MOVE_SUPPORT = "resources/svgNavigation.svg";
    private static File workspace;
    private final StateRepository rep;
    public static Long MAXIMUM_FILE_SIZE;
    public static long MAXIMUM_WORKSPACE_SIZE;
    private final Socket _socket;
    private static final HashSet<String> svgToDelete;
    private String viewBoxDimension = "";

    public RequestThread(Socket socket, String path) {
        this._socket = socket;
        workspace = path == null ? null : new File(path);
        this.rep = new StateRepository(workspace, this);
    }

    private static void sendHeader(BufferedOutputStream out, int code, String contentType, long contentLength, long lastModified) throws IOException {
        out.write(("HTTP/1.0 " + code + " OK\r\n" + "Date: " + new Date().toString() + "\r\n" + "Server: JibbleWebServer/1.0\r\n" + "Content-Type: " + contentType + "\r\n" + "Expires: Thu, 01 Dec 1994 16:00:00 GMT\r\n" + (contentLength != -1L ? "Content-Length: " + contentLength + "\r\n" : "") + "Last-modified: " + new Date(lastModified).toString() + "\r\n" + "\r\n").getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendError(BufferedOutputStream out, int code, String message) throws IOException {
        try {
            message = message + "<hr>" + "SimpleWebServer  http://www.jibble.org/";
            RequestThread.sendHeader(out, code, "text/html", message.length(), System.currentTimeMillis());
            out.write(message.getBytes());
            out.flush();
        }
        finally {
            out.close();
        }
    }

    @Override
    public void run() {
        try {
            this._socket.setSoTimeout(30000);
            InputStream inputStream = this._socket.getInputStream();
            DataInputStream in = new DataInputStream(new BufferedInputStream(inputStream));
            BufferedOutputStream out = new BufferedOutputStream(this._socket.getOutputStream());
            String firstLine = this.readLine(in);
            String request = URLDecoder.decode(firstLine != null ? firstLine : "", "UTF-8");
            if (request == null || !request.startsWith("GET ") && !request.startsWith("POST ") || !request.endsWith(" HTTP/1.0") && !request.endsWith("HTTP/1.1")) {
                RequestThread.sendError(out, 500, "Invalid Method.");
                return;
            }
            if (request.startsWith("POST ")) {
                this.handlePostRequest(in, out, request);
            } else {
                this.handleGetRequest(out, request);
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleGetRequest(BufferedOutputStream out, String request) throws IOException, FileNotFoundException {
        TGraphBrowserServer.logger.info(request);
        String path = request.substring(5, request.length() - 9);
        if (path.isEmpty()) {
            this.sendFile(out, "TGraphBrowser_GraphChoice.html");
        } else if (path.contains("jgralab-logo.png")) {
            this.sendFile(out, "jgralab-logo.png");
        } else if (path.contains("plus.png")) {
            this.sendFile(out, "plus.png");
        } else if (path.contains("minus.png")) {
            this.sendFile(out, "minus.png");
        } else if (path.endsWith("svg")) {
            this.handleRequestForSVG(out, path);
        } else {
            this.handleGetMethodCall(out, path);
        }
    }

    private void handleGetMethodCall(BufferedOutputStream out, String path) throws IOException {
        String[] parts = path.split(Pattern.quote("?"));
        String methodname = parts.length > 0 ? parts[0] : null;
        String[] args = null;
        if (parts.length > 1) {
            String[] methodArgs = parts[1].split("&");
            args = new String[methodArgs.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = methodArgs[i].split("=")[1];
            }
        }
        StringBuilder erg = this.callMethod(out, methodname, args);
        if (methodname.equals("loadGraphFromURI") || methodname.equals("loadGraphFromServer")) {
            if (erg.toString().equals("-1")) {
                this.sendFile(out, "TGraphBrowser_GraphChoice_AfterError.html", "The tg.-file is too big!");
            } else {
                try {
                    this.sendFile(out, "TGraphBrowser_GraphLoaded.html", "= " + erg + ";\n\t\t timestamp = " + StateRepository.getSession((int)Integer.parseInt((String)erg.toString())).lastAccess);
                }
                catch (NumberFormatException e) {
                    String ergText = erg.toString();
                    String[] partOfErg = ergText.split(Pattern.quote("ERROR: "));
                    if (partOfErg.length > 0) {
                        partOfErg = partOfErg[1].split(Pattern.quote("\""));
                        ergText = partOfErg[0];
                    }
                    this.sendFile(out, "TGraphBrowser_GraphChoice_AfterError.html", ergText);
                }
            }
        } else {
            this.sendMessage(out, erg);
        }
    }

    private void handleRequestForSVG(BufferedOutputStream out, String path) throws IOException {
        if (path.charAt(0) == '_') {
            if (svgToDelete.contains(path)) {
                svgToDelete.remove(path);
            } else {
                svgToDelete.add(path);
            }
        }
        String fileName = System.getProperty("java.io.tmpdir") + File.separator + "tgraphbrowser" + File.separator + (path.charAt(0) == '_' ? path.substring(1) : path);
        File svg = new File(fileName);
        long sleepTime = System.currentTimeMillis() + 10000L;
        while (!svg.exists() && System.currentTimeMillis() <= sleepTime) {
            try {
                RequestThread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (svg.exists()) {
            this.sendSVG(out, fileName);
            if (!svgToDelete.contains(path) && !svg.delete()) {
                TGraphBrowserServer.logger.warning(svg.toString() + " could not be deleted.");
            }
        } else {
            this.sendMessage(out, new StringBuilder(svg.toString() + " was not created."));
        }
    }

    private void handlePostRequest(DataInputStream in, BufferedOutputStream out, String request) throws IOException, FileNotFoundException {
        Long contentLength = null;
        String contentType = null;
        do {
            String line;
            if ((line = this.readLine(in)).startsWith("Content-Type")) {
                contentType = line;
                continue;
            }
            if (!line.startsWith("Content-Length:")) continue;
            contentLength = Long.parseLong(line.substring(16));
        } while (contentLength == null || contentType == null);
        if (contentType.contains("multipart/form-data")) {
            this.handleFileUpload(in, out, request, contentLength, contentType);
        } else {
            this.handleNoFileUpload(in, out, contentLength);
        }
    }

    private void handleNoFileUpload(DataInputStream in, BufferedOutputStream out, Long contentLength) throws IOException {
        long timestamp;
        String line;
        while ((line = this.readLine(in)) != null && !line.isEmpty()) {
        }
        byte[] content = new byte[contentLength.intValue()];
        if (in.read(content) <= 0) {
            TGraphBrowserServer.logger.info("content could not be read");
        }
        String body = new String(content);
        String[] bodyparts = Pattern.compile(Matcher.quoteReplacement("\n")).split(body);
        String timestampString = bodyparts[0];
        long l = timestamp = timestampString.equals("undefined") ? Long.MIN_VALUE : Long.parseLong(timestampString);
        if (timestamp + TGraphBrowserServer.DeleteUnusedStates.timeout < System.currentTimeMillis()) {
            this.sendErrorMessage(out, "This session was deleted because there wasn't any communication with the server in the last " + TGraphBrowserServer.DeleteUnusedStates.timeout / 1000L + "sec.");
        } else if (timestamp < TGraphBrowserServer.starttime) {
            this.sendErrorMessage(out, "This server was restarted. This session is too old.");
        } else {
            String sessionId = bodyparts[1];
            String methodname = bodyparts[2];
            ArrayList<String> args = new ArrayList<String>();
            args.add(sessionId);
            for (int i = 3; i < bodyparts.length; ++i) {
                args.add(bodyparts[i]);
            }
            StringBuilder erg = this.callMethod(out, methodname, args.toArray(new String[0]));
            if (erg != null) {
                this.sendMessage(out, erg);
            }
        }
    }

    private void handleFileUpload(DataInputStream in, BufferedOutputStream out, String request, Long contentLength, String contentType) throws IOException, FileNotFoundException {
        String line;
        TGraphBrowserServer.logger.info(request);
        boolean shouldOverwrite = request.contains("overwrite=true");
        String boundary = contentType.split("boundary=")[1];
        String[] bounds = boundary.split("-");
        boundary = bounds[bounds.length - 1];
        while (!(line = this.readLine(in)).contains(boundary)) {
        }
        int sizeOfLinesAlreadyRead = line.length() + 2;
        line = this.readLine(in);
        sizeOfLinesAlreadyRead += line.length() + 2;
        String filename = line.split("filename=")[1];
        if (!(filename = filename.substring(1, filename.length() - 1)).toLowerCase().endsWith(".tg") && !filename.toLowerCase().endsWith(".gz")) {
            this.sendFile(out, "TGraphBrowser_GraphChoice_AfterError.html", "You can only upload .tg or .gz files!");
        } else if (!RequestThread.isSizeOk(contentLength)) {
            this.sendFile(out, "TGraphBrowser_GraphChoice_AfterError.html", "The .tg file is too big!");
        } else {
            File receivedFile = this.receiveFile(in, contentLength, line, shouldOverwrite, sizeOfLinesAlreadyRead, filename);
            int sessionId = StateRepository.createNewSession(receivedFile.getAbsolutePath());
            this.sendFile(out, "TGraphBrowser_GraphLoaded.html", "= " + sessionId + ";\n\t\ttimestamp = " + StateRepository.getSession((int)sessionId).lastAccess);
        }
    }

    private File receiveFile(DataInputStream in, Long contentLength, String line, boolean shouldOverwrite, int sizeOfLinesAlreadyRead, String filename) throws IOException, FileNotFoundException {
        while (line != null && !line.isEmpty()) {
            line = this.readLine(in);
            sizeOfLinesAlreadyRead += line.length() + 2;
        }
        boolean isCompressed = filename.endsWith(".gz");
        filename = workspace.toString() + "/" + filename.substring(0, filename.length() - 3);
        File receivedFile = new File(filename + (isCompressed ? ".gz" : ".tg"));
        if (!shouldOverwrite) {
            int i = 0;
            while (receivedFile.exists()) {
                receivedFile = new File(filename + i + (isCompressed ? ".gz" : ".tg"));
                ++i;
            }
        }
        if (!receivedFile.createNewFile()) {
            TGraphBrowserServer.logger.info(receivedFile.toString() + " overwrites an existing file or could not be created.");
        }
        contentLength = contentLength - (long)sizeOfLinesAlreadyRead;
        BufferedOutputStream fileOutput = this.createFile(in, contentLength, receivedFile);
        fileOutput.flush();
        fileOutput.close();
        return receivedFile;
    }

    private BufferedOutputStream createFile(DataInputStream in, Long contentLength, File receivedFile) throws FileNotFoundException, IOException {
        long totalNumberOfBytesRead;
        BufferedOutputStream fileOutput = new BufferedOutputStream(new FileOutputStream(receivedFile));
        byte[] content = new byte[contentLength < 4096L ? (int)(contentLength % 4096L) : 4096];
        int numberOfBytesRead = 1;
        for (totalNumberOfBytesRead = 0L; totalNumberOfBytesRead < contentLength - (long)content.length; totalNumberOfBytesRead += (long)numberOfBytesRead) {
            numberOfBytesRead = in.read(content);
            if (numberOfBytesRead <= 0) break;
            fileOutput.write(content, 0, numberOfBytesRead);
        }
        if (numberOfBytesRead > 0) {
            content = new byte[(int)(contentLength - totalNumberOfBytesRead) % (content.length + 1)];
            numberOfBytesRead = in.read(content);
            totalNumberOfBytesRead += (long)numberOfBytesRead;
        }
        int endOfFile = this.findEndOfFileInMultipart(content, numberOfBytesRead);
        fileOutput.write(content, 0, endOfFile + 1);
        return fileOutput;
    }

    private String readLine(DataInputStream input) throws IOException {
        byte[] aByte;
        int numberOfBytesRead;
        StringBuilder line = new StringBuilder();
        while ((numberOfBytesRead = input.read(aByte = new byte[1])) > 0) {
            String currentByte = new String(aByte, "UTF-8");
            if (!currentByte.equals("\n") && !currentByte.equals("\r")) {
                line.append(currentByte);
            }
            if (!currentByte.equals("\n")) continue;
        }
        return line.toString().trim();
    }

    private int findEndOfFileInMultipart(byte[] content, int numberOfBytesRead) {
        int currentPos;
        int numberOfCarriageReturn = 0;
        for (currentPos = numberOfBytesRead - 1; currentPos > 0 && numberOfCarriageReturn < 2; --currentPos) {
            if (content[currentPos] != 13) continue;
            ++numberOfCarriageReturn;
        }
        return currentPos;
    }

    private StringBuilder callMethod(BufferedOutputStream out, String methodname, String[] args) throws IOException {
        Method method = StateRepository.definedMethods.get(methodname);
        if (method == null) {
            this.sendErrorMessage(out, "There does not exist a method with name " + methodname + ".");
            return new StringBuilder();
        }
        Class<?>[] params = method.getParameterTypes();
        Object[] currentParams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            currentParams[i] = params[i] == Integer.class ? Integer.valueOf(Integer.parseInt(args[i])) : (params[i] == Boolean.class ? Boolean.valueOf(Boolean.parseBoolean(args[i])) : args[i]);
        }
        StringBuilder argsString = new StringBuilder();
        for (int i = 0; currentParams != null && i < currentParams.length; ++i) {
            argsString.append((i == 0 ? "" : ", ") + (currentParams[i] instanceof String ? "\"" : "") + currentParams[i] + (currentParams[i] instanceof String ? "\"" : ""));
        }
        TGraphBrowserServer.logger.info("StateRepository." + methodname + "(" + argsString.toString() + ")");
        try {
            return (StringBuilder)method.invoke((Object)this.rep, currentParams);
        }
        catch (IllegalArgumentException e) {
            this.sendErrorMessage(out, e.toString());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            this.sendErrorMessage(out, e.toString());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            this.sendErrorMessage(out, e.getCause().toString());
            e.printStackTrace();
        }
        return null;
    }

    public static synchronized boolean isSizeOk(long size) {
        if (MAXIMUM_FILE_SIZE == null) {
            return true;
        }
        if (size > MAXIMUM_FILE_SIZE) {
            return false;
        }
        return workspace.getTotalSpace() + size <= MAXIMUM_WORKSPACE_SIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(BufferedOutputStream out, String file) throws IOException, FileNotFoundException {
        try (InputStream reader = null;){
            if (this._socket.isConnected()) {
                int bytesRead;
                RequestThread.sendHeader(out, 200, file.endsWith(".svg") ? "image/svg+xml" : (file.endsWith(".png") ? "image/png" : "text/html"), -1L, System.currentTimeMillis());
                reader = new File(file).isAbsolute() ? new FileInputStream(file) : this.getClass().getResourceAsStream("resources/" + file);
                byte[] buffer = new byte[4096];
                while ((bytesRead = reader.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(BufferedOutputStream out, String file, String replaceText) throws IOException {
        if (this._socket.isConnected()) {
            RequestThread.sendHeader(out, 200, "text/html", -1L, System.currentTimeMillis());
            try (BufferedReader br = null;){
                br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("resources/" + file)));
                boolean isReplaced = false;
                String line = br.readLine();
                while (line != null) {
                    if (!isReplaced && line.contains("/*?*/")) {
                        line = line.replace("/*?*/", replaceText);
                        isReplaced = true;
                    }
                    if (isReplaced) {
                        out.write((line + "\n").getBytes());
                        break;
                    }
                    out.write((line + "\n").getBytes());
                    line = br.readLine();
                }
                if (line != null) {
                    int bytesRead;
                    char[] buffer = new char[4096];
                    while ((bytesRead = br.read(buffer)) != -1) {
                        out.write(new String(buffer).getBytes(), 0, bytesRead);
                    }
                }
            }
        }
    }

    private void sendSVG(BufferedOutputStream out, String fileName) throws IOException {
        RequestThread.sendHeader(out, 200, "image/svg+xml", -1L, System.currentTimeMillis());
        if (this._socket.isConnected()) {
            StringBuilder contentOfCreatedSVG = this.getContentOfCreatedSVG(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(SVG_WITH_ZOOM_AND_MOVE_SUPPORT)));
            boolean isReplaced = false;
            String line = br.readLine();
            while (line != null) {
                if (line.contains("?viewBox?")) {
                    line = line.replace("?viewBox?", this.viewBoxDimension);
                }
                if (!isReplaced && line.contains("<!--  -->")) {
                    out.write(contentOfCreatedSVG.toString().getBytes());
                    isReplaced = true;
                    break;
                }
                out.write((line + "\n").getBytes());
                line = br.readLine();
            }
            if (line != null) {
                int bytesRead;
                char[] buffer = new char[4096];
                while ((bytesRead = br.read(buffer)) != -1) {
                    out.write(new String(buffer).getBytes(), 0, bytesRead);
                }
            }
            br.close();
        }
    }

    private StringBuilder getContentOfCreatedSVG(String fileName) throws IOException {
        String line;
        StringBuilder out = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        while ((line = br.readLine()) != null && !line.startsWith("<g ")) {
            if (!line.contains("viewBox=\"")) continue;
            String subline = line.split(Pattern.quote("viewBox=\""))[1];
            this.viewBoxDimension = subline.substring(0, subline.indexOf("\""));
        }
        if (line != null) {
            out.append(line + "\n");
        }
        while (line != null && !line.startsWith("</svg>")) {
            line = br.readLine();
            if (line == null || line.startsWith("</svg>")) continue;
            out.append(line + "\n");
        }
        br.close();
        return out;
    }

    private void sendMessage(BufferedOutputStream out, StringBuilder method) throws IOException {
        if (this._socket.isConnected()) {
            RequestThread.sendHeader(out, 200, "text/html", -1L, System.currentTimeMillis());
            String send = "{ \"method\": " + method.toString() + " }";
            out.write(send.getBytes());
        }
    }

    private void sendErrorMessage(BufferedOutputStream out, String message) throws IOException {
        if (this._socket.isConnected()) {
            RequestThread.sendHeader(out, 200, "text/html", -1L, System.currentTimeMillis());
            String send = "{ \"method\": function() {\ndocument.getElementById('loadError').innerHTML = \"ERROR: " + message + "\";\n" + "document.getElementById('divError').style.display = \"block\";\n" + "document.getElementById('h2ErrorMessage').innerHTML = \"ERROR: " + message + "\";\n" + "document.getElementById('divNonError').style.display = \"none\";\n" + " } }";
            out.write(send.getBytes());
        }
    }

    static {
        svgToDelete = new HashSet();
    }
}

