/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2schemagraph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.grumlschema.GrumlSchema;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.CollectionDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.domains.EnumDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasBaseDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasRecordDomainComponent;
import de.uni_koblenz.jgralab.grumlschema.domains.MapDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.AggregationKind;
import de.uni_koblenz.jgralab.grumlschema.structure.Annotates;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ComesFrom;
import de.uni_koblenz.jgralab.grumlschema.structure.Comment;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsDefaultPackage;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsGraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsSubPackage;
import de.uni_koblenz.jgralab.grumlschema.structure.EndsAt;
import de.uni_koblenz.jgralab.grumlschema.structure.GoesTo;
import de.uni_koblenz.jgralab.grumlschema.structure.HasAttribute;
import de.uni_koblenz.jgralab.grumlschema.structure.HasConstraint;
import de.uni_koblenz.jgralab.grumlschema.structure.HasDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.NamedElement;
import de.uni_koblenz.jgralab.grumlschema.structure.Schema;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.BooleanDomain;
import de.uni_koblenz.jgralab.schema.DoubleDomain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.IntegerDomain;
import de.uni_koblenz.jgralab.schema.ListDomain;
import de.uni_koblenz.jgralab.schema.LongDomain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.StringDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.HashMap;
import java.util.Map;

public class Schema2SchemaGraph {
    private de.uni_koblenz.jgralab.schema.Schema schema;
    private de.uni_koblenz.jgralab.grumlschema.structure.Package gDefaultPackage;
    private Package defaultPackage;
    private Map<Package, de.uni_koblenz.jgralab.grumlschema.structure.Package> packageMap;
    private Map<de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?>, AttributedElementClass> attributedElementClassMap;
    private Map<VertexClass, de.uni_koblenz.jgralab.grumlschema.structure.VertexClass> vertexClassMap;
    private Map<EdgeClass, de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass> edgeClassMap;
    private Map<IncidenceClass, de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass> incidenceClassMap;
    private Map<de.uni_koblenz.jgralab.schema.Domain, Domain> domainMap;
    private SchemaGraph schemaGraph;

    private void setUp() {
        this.packageMap = new HashMap<Package, de.uni_koblenz.jgralab.grumlschema.structure.Package>();
        this.attributedElementClassMap = new HashMap();
        this.domainMap = new HashMap<de.uni_koblenz.jgralab.schema.Domain, Domain>();
        this.vertexClassMap = new HashMap<VertexClass, de.uni_koblenz.jgralab.grumlschema.structure.VertexClass>();
        this.edgeClassMap = new HashMap<EdgeClass, de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass>();
        this.incidenceClassMap = new HashMap<IncidenceClass, de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass>();
        this.schemaGraph = GrumlSchema.instance().createSchemaGraph(ImplementationType.STANDARD);
    }

    private void tearDown() {
        this.packageMap = null;
        this.attributedElementClassMap = null;
        this.domainMap = null;
        this.vertexClassMap = null;
        this.edgeClassMap = null;
        this.incidenceClassMap = null;
        this.defaultPackage = null;
        this.gDefaultPackage = null;
        this.schemaGraph = null;
    }

    public synchronized SchemaGraph convert2SchemaGraph(de.uni_koblenz.jgralab.schema.Schema schema) {
        this.setUp();
        if (schema == null) {
            throw new IllegalArgumentException("Schema is a NullReference.");
        }
        this.schema = schema;
        assert (this.checkSchemaAndSchemaGraph());
        this.createSchema();
        this.createGraphClass();
        this.createPackages();
        this.createDomains();
        this.createVertexClasses();
        this.createEdgeClasses();
        this.createSpecializations();
        this.createAttributes();
        this.createConstraints();
        this.createIncidenceClasses();
        SchemaGraph schemaGraph = this.schemaGraph;
        this.tearDown();
        return schemaGraph;
    }

    private void createSchema() {
        assert (this.checkSchemaAndSchemaGraph());
        Schema gSchema = this.schemaGraph.createSchema();
        assert (gSchema != null) : "FIXME! No Schema has been created";
        assert (this.schema.getName() != null) : "FIXME! Schema name of a Schema shouldn't be null.";
        assert (this.schema.getPackagePrefix() != null) : "FIXME! Package prefix should exist.";
        gSchema.set_name(this.schema.getName());
        gSchema.set_packagePrefix(this.schema.getPackagePrefix());
    }

    private boolean checkSchemaAndSchemaGraph() {
        assert (this.schemaGraph != null) : "SchemaGraph has not been created.";
        assert (this.schema != null) : "Given Schema is null";
        return true;
    }

    private void createGraphClass() {
        assert (this.checkSchemaAndSchemaGraph());
        Schema gSchema = this.schemaGraph.getFirstSchema();
        assert (gSchema != null) : "FIXME! No Schema has been created!";
        de.uni_koblenz.jgralab.grumlschema.structure.GraphClass gGraphClass = this.schemaGraph.createGraphClass();
        assert (gGraphClass != null) : "FIXME! No GraphClass has been created!";
        GraphClass graphClass = this.schema.getGraphClass();
        assert (this.attributedElementClassMap != null);
        this.attributedElementClassMap.put(graphClass, gGraphClass);
        assert (graphClass.getQualifiedName() != null) : "FIXME! GraphClass is broken. No QualifiedName is set.";
        gGraphClass.set_qualifiedName(graphClass.getQualifiedName());
        this.schemaGraph.createDefinesGraphClass(gSchema, gGraphClass);
        if (graphClass.getComments() != null) {
            this.createComments(graphClass, gGraphClass);
        }
    }

    private void createComments(de.uni_koblenz.jgralab.schema.NamedElement namedElement, NamedElement gNamedElement) {
        assert (this.checkSchemaAndSchemaGraph());
        for (String comment : namedElement.getComments()) {
            Comment gComment = this.schemaGraph.createComment();
            assert (gComment != null) : "FIXEME! No Comment has been created!";
            gComment.set_text(comment);
            Annotates link = this.schemaGraph.createAnnotates(gComment, gNamedElement);
            assert (link != null) : "FIXME! No Annotates link has been created.";
        }
    }

    private void createPackages() {
        this.createDefaultPackage();
        this.createSubPackages(this.defaultPackage, this.gDefaultPackage);
    }

    private void createDefaultPackage() {
        assert (this.checkSchemaAndSchemaGraph());
        this.gDefaultPackage = this.schemaGraph.createPackage();
        this.defaultPackage = this.schema.getDefaultPackage();
        assert (this.gDefaultPackage != null) : "FIXEME! No DefaultPackage has been created!";
        assert (this.defaultPackage != null) : "FIXME! No DefaultPackage is defined in the given Schema.";
        assert (this.defaultPackage.getQualifiedName() != null) : "FIXME! Package has not QualifiedName defined.";
        this.gDefaultPackage.set_qualifiedName(this.defaultPackage.getQualifiedName());
        this.packageMap.put(this.defaultPackage, this.gDefaultPackage);
        ContainsDefaultPackage link = this.schemaGraph.createContainsDefaultPackage(this.schemaGraph.getFirstSchema(), this.gDefaultPackage);
        assert (link != null) : "FIXME! No ContainsDefaultPackage link has been created.";
        if (this.defaultPackage.getComments() != null) {
            this.createComments(this.defaultPackage, this.gDefaultPackage);
        }
    }

    private void createSubPackages(Package xPackage, de.uni_koblenz.jgralab.grumlschema.structure.Package gPackage) {
        assert (this.checkSchemaAndSchemaGraph());
        for (Package subPackage : xPackage.getSubPackages()) {
            assert (subPackage != null && subPackage.getQualifiedName() != null) : "FIXME! This Package has no QualifiedName defined!";
            de.uni_koblenz.jgralab.grumlschema.structure.Package gSubPackage = this.schemaGraph.createPackage();
            assert (gSubPackage != null) : "FIXME! A Package wasn't created.";
            gSubPackage.set_qualifiedName(subPackage.getQualifiedName());
            this.packageMap.put(subPackage, gSubPackage);
            ContainsSubPackage link = this.schemaGraph.createContainsSubPackage(gPackage, gSubPackage);
            assert (link != null) : "FIXME! Link ContainsSubPackage has not been created!";
            if (subPackage.getComments() != null) {
                this.createComments(subPackage, gSubPackage);
            }
            this.createSubPackages(subPackage, gSubPackage);
        }
    }

    private void createDomains() {
        for (Map.Entry<Package, de.uni_koblenz.jgralab.grumlschema.structure.Package> entry : this.packageMap.entrySet()) {
            for (de.uni_koblenz.jgralab.schema.Domain domain : entry.getKey().getDomains()) {
                this.createDomain(domain);
            }
        }
    }

    private Domain createDomain(de.uni_koblenz.jgralab.schema.Domain domain) {
        assert (this.checkSchemaAndSchemaGraph());
        assert (domain != null) : "FIXME! Domain is not set.";
        Domain gDomain = null;
        if (this.domainMap.containsKey(domain)) {
            gDomain = this.domainMap.get(domain);
        } else {
            if (domain instanceof BooleanDomain) {
                gDomain = this.schemaGraph.createBooleanDomain();
            } else if (domain instanceof IntegerDomain) {
                gDomain = this.schemaGraph.createIntegerDomain();
            } else if (domain instanceof LongDomain) {
                gDomain = this.schemaGraph.createLongDomain();
            } else if (domain instanceof DoubleDomain) {
                gDomain = this.schemaGraph.createDoubleDomain();
            } else if (domain instanceof StringDomain) {
                gDomain = this.schemaGraph.createStringDomain();
            } else if (domain instanceof de.uni_koblenz.jgralab.schema.CollectionDomain) {
                gDomain = this.createCollectionDomain((de.uni_koblenz.jgralab.schema.CollectionDomain)domain);
            } else if (domain instanceof de.uni_koblenz.jgralab.schema.MapDomain) {
                gDomain = this.createMapDomain((de.uni_koblenz.jgralab.schema.MapDomain)domain);
            } else if (domain instanceof RecordDomain) {
                gDomain = this.createRecordDomain((RecordDomain)domain);
            } else if (domain instanceof de.uni_koblenz.jgralab.schema.EnumDomain) {
                gDomain = this.createEnumDomain((de.uni_koblenz.jgralab.schema.EnumDomain)domain);
            } else {
                throw new RuntimeException("FIXME: Unforseen domain occured! " + domain);
            }
            assert (domain.getQualifiedName() != null) : "FIXME! QualifiedName is not defined";
            gDomain.set_qualifiedName(domain.getQualifiedName());
            de.uni_koblenz.jgralab.grumlschema.structure.Package gPackage = this.packageMap.get(domain.getPackage());
            ContainsDomain link = this.schemaGraph.createContainsDomain(gPackage, gDomain);
            assert (link != null) : "FIXME! No link ContainsDomain has been created!";
            this.domainMap.put(domain, gDomain);
            if (domain.getComments() != null) {
                this.createComments(domain, gDomain);
            }
        }
        assert (gDomain != null);
        return gDomain;
    }

    private MapDomain createMapDomain(de.uni_koblenz.jgralab.schema.MapDomain domain) {
        assert (this.checkSchemaAndSchemaGraph());
        MapDomain gDomain = this.schemaGraph.createMapDomain();
        this.domainMap.put(domain, gDomain);
        this.schemaGraph.createHasKeyDomain(gDomain, this.queryGDomain(domain.getKeyDomain()));
        this.schemaGraph.createHasValueDomain(gDomain, this.queryGDomain(domain.getValueDomain()));
        return gDomain;
    }

    private EnumDomain createEnumDomain(de.uni_koblenz.jgralab.schema.EnumDomain domain) {
        assert (this.checkSchemaAndSchemaGraph());
        EnumDomain gDomain = this.schemaGraph.createEnumDomain();
        assert (gDomain != null) : "FIXME! No EnumDomain has been created!";
        assert (domain.getConsts() != null) : "FIXME! No consts defined.";
        gDomain.set_enumConstants(domain.getConsts());
        return gDomain;
    }

    private CollectionDomain createCollectionDomain(de.uni_koblenz.jgralab.schema.CollectionDomain domain) {
        CollectionDomain gDomain;
        assert (this.checkSchemaAndSchemaGraph());
        CollectionDomain collectionDomain = gDomain = domain instanceof ListDomain ? this.schemaGraph.createListDomain() : this.schemaGraph.createSetDomain();
        assert (gDomain != null) : "FIXME! No Domain has been created!";
        this.domainMap.put(domain, gDomain);
        HasBaseDomain link = this.schemaGraph.createHasBaseDomain(gDomain, this.queryGDomain(domain.getBaseDomain()));
        assert (link != null) : "FIXME! No link has been created!";
        return gDomain;
    }

    private de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain createRecordDomain(RecordDomain domain) {
        assert (this.checkSchemaAndSchemaGraph());
        de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain gDomain = this.schemaGraph.createRecordDomain();
        assert (gDomain != null) : "FIXME! No RecordDomain has been created!";
        this.domainMap.put(domain, gDomain);
        for (RecordDomain.RecordComponent recComp : domain.getComponents()) {
            HasRecordDomainComponent edge = this.schemaGraph.createHasRecordDomainComponent(gDomain, this.queryGDomain(recComp.getDomain()));
            assert (edge != null) : "FIXME! No link HasRecordDomainComponent has been created!";
            assert (recComp.getName() != null) : "FIXME! No name defined!";
            edge.set_name(recComp.getName());
        }
        return gDomain;
    }

    private void createVertexClasses() {
        for (Map.Entry<Package, de.uni_koblenz.jgralab.grumlschema.structure.Package> entry : this.packageMap.entrySet()) {
            this.createVertexClasses(entry.getKey(), entry.getValue());
        }
    }

    private void createVertexClasses(Package xPackage, de.uni_koblenz.jgralab.grumlschema.structure.Package gPackage) {
        assert (this.checkSchemaAndSchemaGraph());
        for (VertexClass vertexClass : xPackage.getVertexClasses()) {
            assert (vertexClass != null && vertexClass.getQualifiedName() != null) : "FIXME! No QualifiedName for this VertexClass defined!";
            de.uni_koblenz.jgralab.grumlschema.structure.VertexClass gVertexClass = this.schemaGraph.createVertexClass();
            assert (gVertexClass != null) : "FIXME! No VertexClass has been created!";
            gVertexClass.set_abstract(vertexClass.isAbstract());
            gVertexClass.set_qualifiedName(vertexClass.getQualifiedName());
            this.attributedElementClassMap.put(vertexClass, gVertexClass);
            this.vertexClassMap.put(vertexClass, gVertexClass);
            ContainsGraphElementClass link = this.schemaGraph.createContainsGraphElementClass(gPackage, gVertexClass);
            assert (link != null) : "FIXME! No link ContainsGraphElementClass has been created!";
            if (vertexClass.getComments() == null) continue;
            this.createComments(vertexClass, gVertexClass);
        }
    }

    private void createEdgeClasses() {
        for (Map.Entry<Package, de.uni_koblenz.jgralab.grumlschema.structure.Package> entry : this.packageMap.entrySet()) {
            this.createEdgeClasses(entry.getKey(), entry.getValue());
        }
    }

    private void createEdgeClasses(Package xPackage, de.uni_koblenz.jgralab.grumlschema.structure.Package gPackage) {
        assert (this.checkSchemaAndSchemaGraph());
        for (EdgeClass edgeClass : xPackage.getEdgeClasses()) {
            assert (edgeClass != null && edgeClass.getQualifiedName() != null) : "FIXME! No QualifiedName for this EdgeClass defined!";
            de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass gEdgeClass = this.createEdgeClass(edgeClass);
            this.attributedElementClassMap.put(edgeClass, gEdgeClass);
            this.edgeClassMap.put(edgeClass, gEdgeClass);
            ContainsGraphElementClass link = this.schemaGraph.createContainsGraphElementClass(gPackage, gEdgeClass);
            assert (link != null) : "FIXME! No link ContainsGraphElementClass has been created!";
            if (edgeClass.getComments() == null) continue;
            this.createComments(edgeClass, gEdgeClass);
        }
    }

    private de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass createEdgeClass(EdgeClass edgeClass) {
        assert (this.checkSchemaAndSchemaGraph());
        assert (edgeClass != null && edgeClass.getQualifiedName() != null) : "FIXME! No QualifiedName for this EdgeClass defined!";
        de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass gEdgeClass = this.schemaGraph.createEdgeClass();
        assert (gEdgeClass != null) : "FIXME! No EdgeClass has been created!";
        gEdgeClass.set_abstract(edgeClass.isAbstract());
        gEdgeClass.set_qualifiedName(edgeClass.getQualifiedName());
        return gEdgeClass;
    }

    private void createSpecializations() {
        Edge link;
        assert (this.checkSchemaAndSchemaGraph());
        for (Map.Entry<VertexClass, de.uni_koblenz.jgralab.grumlschema.structure.VertexClass> entry : this.vertexClassMap.entrySet()) {
            for (de.uni_koblenz.jgralab.schema.AttributedElementClass superClass : entry.getKey().getDirectSuperClasses()) {
                link = this.schemaGraph.createSpecializesVertexClass(entry.getValue(), this.vertexClassMap.get(superClass));
                assert (link != null) : "FIXME! No link SpecializesVertexClass has been created!";
            }
        }
        for (Map.Entry<GraphElementClass<VertexClass, Vertex>, de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass> entry : this.edgeClassMap.entrySet()) {
            for (de.uni_koblenz.jgralab.schema.AttributedElementClass superClass : ((EdgeClass)entry.getKey()).getDirectSuperClasses()) {
                link = this.schemaGraph.createSpecializesEdgeClass((de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)entry.getValue(), this.edgeClassMap.get(superClass));
                assert (link != null) : "FIXME! No link SpecializesEdgeClass has been created!";
            }
        }
    }

    private void createAttributes() {
        for (Map.Entry<de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?>, AttributedElementClass> entry : this.attributedElementClassMap.entrySet()) {
            this.createAttributes(entry.getKey(), entry.getValue());
        }
    }

    private void createAttributes(de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?> element, AttributedElementClass gElement) {
        assert (this.checkSchemaAndSchemaGraph());
        for (Attribute attribute : element.getOwnAttributeList()) {
            assert (attribute != null && attribute.getName() != null) : "FIXME! No name for this Attribute is defined!";
            de.uni_koblenz.jgralab.grumlschema.structure.Attribute gAttribute = this.schemaGraph.createAttribute();
            assert (gAttribute != null) : "FIXME! No Attribute has been created!";
            gAttribute.set_name(attribute.getName());
            gAttribute.set_defaultValue(attribute.getDefaultValueAsString());
            assert (attribute.getDomain() != null) : "FIXME! No Domain has been defined!";
            Domain gDomain = this.domainMap.get(attribute.getDomain());
            assert (gDomain != null) : "FIXME! Given Schema malformed, because the requested Domain is not registered in its Package";
            HasAttribute link1 = this.schemaGraph.createHasAttribute(gElement, gAttribute);
            HasDomain link2 = this.schemaGraph.createHasDomain(gAttribute, gDomain);
            assert (link1 != null && link2 != null) : "FIXME! No link HasAttribute or HasDomain have been created!";
        }
    }

    private void createConstraints() {
        for (Map.Entry<de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?>, AttributedElementClass> entry : this.attributedElementClassMap.entrySet()) {
            this.createConstraints(entry.getKey(), entry.getValue());
        }
    }

    private void createConstraints(de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?> element, AttributedElementClass gElement) {
        assert (this.checkSchemaAndSchemaGraph());
        assert (element != null) : "FIXME! AttributedElement is null!";
        assert (gElement != null) : "FIXME! AttributedElement is null!";
        assert (element.getConstraints() != null) : "FIXME! AttributedElement has no Constraints defined!";
        for (de.uni_koblenz.jgralab.schema.Constraint constraint : element.getConstraints()) {
            assert (constraint != null && constraint.getMessage() != null && constraint.getPredicate() != null) : "FIXME! Constraint isn't wellformed.";
            Constraint gConstraint = this.schemaGraph.createConstraint();
            gConstraint.set_message(constraint.getMessage());
            gConstraint.set_predicateQuery(constraint.getPredicate());
            gConstraint.set_offendingElementsQuery(constraint.getOffendingElementsQuery());
            HasConstraint link = this.schemaGraph.createHasConstraint(gElement, gConstraint);
            assert (link != null) : "FIXME! No link HasConstraint has been created!";
        }
    }

    private void createIncidenceClasses() {
        for (Map.Entry<EdgeClass, de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass> entry : this.edgeClassMap.entrySet()) {
            this.createIncidenceClass(entry.getKey(), entry.getValue());
        }
    }

    private void createIncidenceClass(EdgeClass edgeClass, de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass gEdgeClass) {
        assert (edgeClass != null) : "FIXME! EdgeClass is null!";
        assert (edgeClass.getFrom() != null) : "FIXME! No from IncidenceClass defined!";
        de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass gIncidenceClass = this.createIncidenceClass(edgeClass.getFrom());
        this.incidenceClassMap.put(edgeClass.getFrom(), gIncidenceClass);
        ComesFrom from = this.schemaGraph.createComesFrom(gEdgeClass, gIncidenceClass);
        assert (from != null) : "FIXME! No link ComesFrom has been created!";
        assert (edgeClass.getTo() != null) : "FIXME! No to IncidenceClass defined!";
        gIncidenceClass = this.createIncidenceClass(edgeClass.getTo());
        this.incidenceClassMap.put(edgeClass.getTo(), gIncidenceClass);
        GoesTo to = this.schemaGraph.createGoesTo(gEdgeClass, gIncidenceClass);
        assert (to != null) : "FIXME! No link GoesTo has been created!";
        assert (this.checkSchemaAndSchemaGraph());
    }

    private de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass createIncidenceClass(IncidenceClass incidenceClass) {
        assert (this.checkSchemaAndSchemaGraph());
        assert (incidenceClass != null && incidenceClass.getAggregationKind() != null) : "FIXME! No AggregationKind for this IncidenceClass defined!";
        assert (incidenceClass != null && incidenceClass.getDirection() != null) : "FIXME! No Direction for this IncidenceClass defined!";
        de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass gIncidenceClass = this.schemaGraph.createIncidenceClass();
        assert (gIncidenceClass != null) : "FIXME! No IncidenceClass has been created!";
        gIncidenceClass.set_aggregation(AggregationKind.valueOf(incidenceClass.getAggregationKind().toString()));
        gIncidenceClass.set_max(incidenceClass.getMax());
        gIncidenceClass.set_min(incidenceClass.getMin());
        gIncidenceClass.set_roleName(incidenceClass.getRolename());
        de.uni_koblenz.jgralab.grumlschema.structure.VertexClass vertexClass = this.vertexClassMap.get(incidenceClass.getVertexClass());
        assert (vertexClass != null) : "The to vertex class '" + incidenceClass.getVertexClass().getQualifiedName() + "' was not in vertexClassMap!";
        EndsAt endsAt = this.schemaGraph.createEndsAt(gIncidenceClass, vertexClass);
        assert (endsAt != null) : "FIXME! No link EndsAt has been created!";
        return gIncidenceClass;
    }

    private Domain queryGDomain(de.uni_koblenz.jgralab.schema.Domain domain) {
        assert (this.domainMap != null) : "Relation map from original Domain to SchemaGraph Domain hasn't been created.";
        Domain gDomain = this.domainMap.get(domain);
        if (gDomain == null) {
            gDomain = this.createDomain(domain);
        }
        assert (gDomain != null) : "FIXME! Something is wrong!";
        return gDomain;
    }
}

