/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.schemacompare;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.WorkInProgress;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.NamedElement;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.Schema;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

@WorkInProgress(responsibleDevelopers="horn")
public class SchemaCompare {
    private Schema s;
    private Schema t;
    private int diffCount = 0;
    private boolean reverseRun = false;
    Set<Object> marked = new HashSet<Object>();

    public SchemaCompare(Schema s1, Schema s2) {
        this.s = s1;
        this.t = s2;
    }

    public int compareSchemas() {
        System.out.println("Comparing Schemas:\nForward run...\n");
        this.compareGraphClass(this.s.getGraphClass(), this.t.getGraphClass());
        for (RecordDomain recordDomain : this.s.getRecordDomains()) {
            this.compareRecordDomain(recordDomain, this.t.getDomain(recordDomain.getQualifiedName()));
        }
        for (EnumDomain enumDomain : this.s.getEnumDomains()) {
            this.compareEnumDomain(enumDomain, this.t.getDomain(enumDomain.getQualifiedName()));
        }
        System.out.println("\nReverse run...\n");
        this.reverseRun = true;
        this.compareGraphClass(this.t.getGraphClass(), this.s.getGraphClass());
        for (RecordDomain recordDomain : this.t.getRecordDomains()) {
            this.compareRecordDomain(recordDomain, this.s.getDomain(recordDomain.getQualifiedName()));
        }
        for (EnumDomain enumDomain : this.t.getEnumDomains()) {
            this.compareEnumDomain(enumDomain, this.s.getDomain(enumDomain.getQualifiedName()));
        }
        if (this.diffCount > 0) {
            System.out.println("\nFound " + this.diffCount + " differences!");
        } else {
            System.out.println("Schemas are equivalent.");
        }
        return this.diffCount;
    }

    private boolean areMarked(Object d, Object e) {
        return this.marked.contains(d) && this.marked.contains(e);
    }

    private void compareRecordDomain(RecordDomain d, Domain e) {
        if (e == null) {
            this.reportDiff("RecordDomain " + d.getQualifiedName(), "null");
            return;
        }
        if (this.areMarked(d, e)) {
            return;
        }
        if (!(e instanceof RecordDomain)) {
            this.reportDiff("RecordDomain " + d.getQualifiedName(), "no RecordDomain");
            return;
        }
        RecordDomain f = (RecordDomain)e;
        for (RecordDomain.RecordComponent dc : d.getComponents()) {
            boolean foundMatch = false;
            for (RecordDomain.RecordComponent fc : f.getComponents()) {
                if (!dc.getName().equals(fc.getName()) || !dc.getDomain().getQualifiedName().equals(fc.getDomain().getQualifiedName())) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            this.reportDiff("RecordDomain " + d.getQualifiedName() + ", Component: " + dc.getName() + " : " + dc.getDomain().getQualifiedName(), "RecordDomain " + f.getQualifiedName() + " has no such component.");
        }
        this.marked.add(d);
        this.marked.add(f);
    }

    private void compareEnumDomain(EnumDomain d, Domain e) {
        if (e == null) {
            this.reportDiff("EnumDomain " + d.getQualifiedName(), "null");
            return;
        }
        if (this.areMarked(d, e)) {
            return;
        }
        if (!(e instanceof EnumDomain)) {
            this.reportDiff("EnumDomain " + d.getQualifiedName(), "no EnumDomain");
            return;
        }
        EnumDomain f = (EnumDomain)e;
        if (!new HashSet<String>(d.getConsts()).equals(new HashSet<String>(f.getConsts()))) {
            this.reportDiff("EnumDomain " + d.getQualifiedName() + ": " + d.getConsts(), "EnumDomain " + f.getQualifiedName() + ": " + f.getConsts());
        }
        this.marked.add(d);
        this.marked.add(f);
    }

    private void reportDiff(String s, String t) {
        System.out.println("---");
        if (!this.reverseRun) {
            System.out.println("Schema 1: " + s);
            System.out.println("Schema 2: " + t);
        } else {
            System.out.println("Schema 2: " + s);
            System.out.println("Schema 1: " + t);
        }
        ++this.diffCount;
    }

    private void compareGraphClass(GraphClass g, GraphClass h) {
        if (!g.getQualifiedName().equals(h.getQualifiedName())) {
            this.reportDiff("GraphClass: " + g.getQualifiedName(), "GraphClass: " + h.getQualifiedName());
            return;
        }
        if (this.areMarked(g, h)) {
            return;
        }
        for (GraphElementClass<?, ?> gec : g.getGraphElementClasses()) {
            this.compareGraphElementClass(gec, h.getGraphElementClass(gec.getQualifiedName()));
        }
        this.marked.add(g);
        this.marked.add(h);
    }

    private void compareGraphElementClass(GraphElementClass<?, ?> g, GraphElementClass<?, ?> h) {
        if (h == null) {
            this.reportDiff("GraphElementClass: " + g.getQualifiedName(), "null");
            return;
        }
        if (this.areMarked(g, h)) {
            return;
        }
        this.compareHierarchy(g, h);
        this.compareAbstractness(g, h);
        for (Attribute a : g.getOwnAttributeList()) {
            this.compareAttribute(g, a, h, h.getAttribute(a.getName()));
        }
        this.marked.add(g);
        this.marked.add(h);
    }

    private void compareAbstractness(GraphElementClass<?, ?> g, GraphElementClass<?, ?> h) {
        if (g.isAbstract() ^ h.isAbstract()) {
            this.reportDiff(g.getQualifiedName() + (g.isAbstract() ? " is" : " is not") + " abstract", h.getQualifiedName() + (h.isAbstract() ? " is" : " is not") + " abstract");
        }
    }

    private void compareAttribute(GraphElementClass<?, ?> g, Attribute a, GraphElementClass<?, ?> h, Attribute b) {
        if (b == null) {
            this.reportDiff(g.getQualifiedName() + "." + a.getName(), h.getQualifiedName() + " doesn't have such an Atrribute");
            return;
        }
        if (this.areMarked(g, h)) {
            return;
        }
        if (!a.getDomain().getQualifiedName().equals(b.getDomain().getQualifiedName())) {
            this.reportDiff(g.getQualifiedName() + "." + a.getName() + " : " + a.getDomain().getQualifiedName(), h.getQualifiedName() + "." + b.getName() + " : " + b.getDomain().getQualifiedName());
        }
        this.marked.add(g);
        this.marked.add(h);
    }

    private void compareHierarchy(GraphElementClass<?, ?> g, GraphElementClass<?, ?> h) {
        Set<String> hsub;
        Set<String> gsub;
        Set<String> hsup;
        Set<String> gsup = this.getQNameSet(g.getDirectSuperClasses());
        if (!gsup.equals(hsup = this.getQNameSet(h.getDirectSuperClasses()))) {
            this.reportDiff(g.getQualifiedName() + " superclasses: " + gsup, h.getQualifiedName() + " superclasses: " + hsup);
        }
        if (!(gsub = this.getQNameSet(g.getAllSubClasses())).equals(hsub = this.getQNameSet(h.getAllSubClasses()))) {
            this.reportDiff(g.getQualifiedName() + " subclasses: " + gsub, h.getQualifiedName() + " subclasses: " + hsub);
        }
    }

    private Set<String> getQNameSet(Set<? extends NamedElement> a) {
        TreeSet<String> q = new TreeSet<String>();
        for (NamedElement namedElement : a) {
            q.add(namedElement.getQualifiedName());
        }
        return q;
    }

    public static void main(String[] args) throws GraphIOException {
        CommandLine comLine = SchemaCompare.processCommandLineOptions(args);
        assert (comLine != null);
        SchemaCompare sc = new SchemaCompare(GraphIO.loadSchemaFromFile(comLine.getOptionValue("s1")), GraphIO.loadSchemaFromFile(comLine.getOptionValue("s2")));
        sc.compareSchemas();
    }

    private static CommandLine processCommandLineOptions(String[] args) {
        String toolString = "java " + SchemaCompare.class.getName();
        String versionString = JGraLab.getInfo(false);
        OptionHandler oh = new OptionHandler(toolString, versionString);
        Option schema1 = new Option("s1", "schema1", true, "(required): the first schema which is compared with the second");
        schema1.setRequired(true);
        schema1.setArgName("file");
        oh.addOption(schema1);
        Option schema2 = new Option("s2", "schema2", true, "(required): the second schema which is compared with the first");
        schema2.setRequired(true);
        schema2.setArgName("file");
        oh.addOption(schema2);
        return oh.parse(args);
    }
}

