/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.gui.xdot;

import de.uni_koblenz.ist.utilities.gui.DrawingPanel;
import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.utilities.gui.xdot.ElementSelectionEvent;
import de.uni_koblenz.jgralab.utilities.gui.xdot.ElementSelectionListener;
import de.uni_koblenz.jgralab.utilities.gui.xdot.TextShape;
import de.uni_koblenz.jgralab.utilities.gui.xdot.XDotParser;
import de.uni_koblenz.jgralab.utilities.gui.xdot.XDotShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class XDotPanel
extends DrawingPanel {
    private static final long serialVersionUID = 1L;
    private Graph graph;
    private List<XDotShape> shapes;
    private GraphMarker<List<XDotShape>> elementShapes;
    private GraphMarker<Rectangle> elementBoxes;
    private GraphMarker<Rectangle> elementTexts;
    private Stroke standardStroke;
    private Stroke dashedStroke;
    private Stroke thickStroke;
    private Stroke thickDashedStroke;
    private boolean trackMouseMotion;
    private AttributedElement<?, ?> hoverElement;
    private List<ElementSelectionListener> listenerList;

    public XDotPanel(Graph g, InputStream xdotInputStream) throws IOException {
        super(true, false);
        this.setBackground(Color.WHITE);
        this.setGraph(g, xdotInputStream);
        this.standardStroke = new BasicStroke(1.0f, 1, 1);
        this.thickStroke = new BasicStroke(2.5f, 1, 1);
        float[] dash = new float[]{5.0f, 5.0f};
        this.dashedStroke = new BasicStroke(1.0f, 1, 1, 1.0f, dash, 0.0f);
        this.thickDashedStroke = new BasicStroke(2.5f, 1, 1, 1.0f, dash, 0.0f);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                AttributedElement<?, ?> el;
                if (XDotPanel.this.trackMouseMotion && (el = XDotPanel.this.getElementAt(XDotPanel.this.screenToModel(e.getPoint()))) != XDotPanel.this.hoverElement) {
                    XDotPanel.this.hoverElement = el;
                    XDotPanel.this.fireMouseOver(new ElementSelectionEvent(el, e));
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                AttributedElement<?, ?> el;
                if (XDotPanel.this.trackMouseMotion && (el = XDotPanel.this.getElementAt(XDotPanel.this.screenToModel(e.getPoint()))) != XDotPanel.this.hoverElement) {
                    XDotPanel.this.hoverElement = el;
                    XDotPanel.this.fireMouseOver(new ElementSelectionEvent(el, e));
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AttributedElement<?, ?> el = XDotPanel.this.getElementAt(XDotPanel.this.screenToModel(e.getPoint()));
                XDotPanel.this.fireMousePressed(new ElementSelectionEvent(el, e));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AttributedElement<?, ?> el = XDotPanel.this.getElementAt(XDotPanel.this.screenToModel(e.getPoint()));
                XDotPanel.this.fireMouseReleased(new ElementSelectionEvent(el, e));
            }
        });
        this.listenerList = new ArrayList<ElementSelectionListener>();
    }

    public void setGraph(Graph g, InputStream xdotInputStream) throws IOException {
        this.graph = g;
        this.elementShapes = new GraphMarker(g);
        XDotParser p = new XDotParser(this.graph, this.elementShapes);
        this.shapes = p.parseXDotFile(new BufferedInputStream(xdotInputStream));
        Rectangle2D bounds = p.getBounds();
        if (bounds != null) {
            this.setBoundingBox(bounds);
        }
        this.elementBoxes = null;
    }

    private void fireMousePressed(ElementSelectionEvent e) {
        for (ElementSelectionListener l : this.listenerList) {
            l.mousePressed(e);
        }
    }

    private void fireMouseReleased(ElementSelectionEvent e) {
        for (ElementSelectionListener l : this.listenerList) {
            l.mouseReleased(e);
        }
    }

    private void fireMouseOver(ElementSelectionEvent e) {
        for (ElementSelectionListener l : this.listenerList) {
            l.mouseOver(e);
        }
    }

    public void addElementSelectionListener(ElementSelectionListener l) {
        if (!this.listenerList.contains(l)) {
            this.listenerList.add(l);
            this.trackMouseMotion = true;
        }
    }

    public void removeElementSelectionListener(ElementSelectionListener l) {
        this.listenerList.remove(l);
        if (this.listenerList.isEmpty()) {
            this.trackMouseMotion = false;
        }
    }

    private void computeBoundingBoxes() {
        this.elementBoxes = new GraphMarker(this.graph);
        this.elementTexts = new GraphMarker(this.graph);
        for (AttributedElement el : this.elementShapes.getMarkedElements()) {
            List l = (List)this.elementShapes.get(el);
            Rectangle rb = null;
            Rectangle rt = null;
            for (XDotShape s : l) {
                if (s.getShape() instanceof TextShape) {
                    if (rt == null) {
                        rt = new Rectangle(s.getShape().getBounds());
                        continue;
                    }
                    rt = rt.union(s.getShape().getBounds());
                    continue;
                }
                if (rb == null) {
                    rb = new Rectangle(s.getShape().getBounds());
                    continue;
                }
                rb = rb.union(s.getShape().getBounds());
            }
            this.elementBoxes.mark(el, rb);
            this.elementTexts.mark(el, rt);
        }
    }

    @Override
    protected void paintContent(Graphics2D g2) {
        for (XDotShape s : this.shapes) {
            g2.setStroke(this.standardStroke);
            s.draw(g2);
        }
        if (this.elementBoxes == null) {
            this.computeBoundingBoxes();
        }
    }

    protected AttributedElement<?, ?> getElementAt(Point p) {
        Rectangle r;
        int fm = Integer.MAX_VALUE;
        AttributedElement result = null;
        for (XDotShape xs : this.shapes) {
            r = xs.getShape().getBounds();
            if (r.width * r.height >= fm || !r.contains(p)) continue;
            fm = r.width * r.height;
            result = xs.getElement();
        }
        if (this.elementBoxes != null) {
            for (AttributedElement el : this.elementBoxes.getMarkedElements()) {
                r = (Rectangle)this.elementTexts.get(el);
                if (r != null && r.width * r.height < fm && r.contains(p)) {
                    fm = r.width * r.height;
                    result = el;
                }
                if ((r = (Rectangle)this.elementBoxes.get(el)) == null || r.width * r.height >= fm || !r.contains(p)) continue;
                fm = r.width * r.height;
                result = el;
            }
        }
        return result;
    }

    public void setElementColors(AttributedElement<?, ?> el, Color lineColor, Color fillColor, Color textColor) {
        assert (lineColor != null);
        assert (fillColor != null);
        assert (textColor != null);
        List l = (List)this.elementShapes.get(el);
        if (l == null) {
            return;
        }
        for (XDotShape xs : l) {
            if (xs.getLineColor() != null) {
                xs.setLineColor(lineColor);
            }
            if (xs.getFillColor() != null) {
                xs.setFillColor(fillColor);
            }
            if (xs.getTextColor() == null) continue;
            xs.setTextColor(textColor);
        }
    }

    public void setElementStroke(AttributedElement<?, ?> el, Stroke s) {
        assert (s != null);
        List l = (List)this.elementShapes.get(el);
        if (l == null) {
            return;
        }
        for (XDotShape xs : l) {
            xs.setStroke(s);
        }
    }

    public Stroke getStandardStroke() {
        return this.standardStroke;
    }

    public Stroke getDashedStroke() {
        return this.dashedStroke;
    }

    public Stroke getThickStroke() {
        return this.thickStroke;
    }

    public Stroke getThickDashedStroke() {
        return this.thickDashedStroke;
    }
}

