/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.ant;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.Schema;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;

public class DeleteGeneratedSchemaTask
extends Task {
    private Set<String> tgFiles = new HashSet<String>();
    private String sourcePath;

    public void setSchemaFile(String filename) {
        this.tgFiles.add(filename);
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void addConfiguredFileset(FileSet files) {
        for (Object current : files) {
            if (!(current instanceof FileResource)) continue;
            File currentFile = ((FileResource)current).getFile();
            this.tgFiles.add(currentFile.getAbsolutePath());
        }
    }

    public void execute() {
        try {
            for (String currentTG : this.tgFiles) {
                if (new File(currentTG).exists()) {
                    Schema schema = GraphIO.loadSchemaFromFile(currentTG);
                    DeleteGeneratedSchemaTask.deleteGeneratedSchema(this.sourcePath, schema);
                    continue;
                }
                System.err.println("Warning: could not delete generated schema files: \"" + currentTG + "\" could not be found.");
            }
        }
        catch (GraphIOException e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    public static void deleteGeneratedSchema(String commitPath, Schema schema) throws GraphIOException {
        String toDelete = commitPath + File.separator + schema.getPathName();
        File directory = new File(toDelete);
        if (directory.exists()) {
            assert (directory.isDirectory());
            DeleteGeneratedSchemaTask.deleteTree(directory);
            System.out.println("Deleted schema from directory " + directory.getAbsolutePath());
        }
    }

    public static void deleteTree(File toDelete) {
        if (toDelete.isFile()) {
            toDelete.delete();
        } else {
            for (File current : toDelete.listFiles()) {
                DeleteGeneratedSchemaTask.deleteTree(current);
            }
            toDelete.delete();
        }
    }
}

