/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl.compilation;

import de.uni_koblenz.jgralab.EclipseAdapter;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.schema.impl.compilation.ClassFileObject;
import de.uni_koblenz.jgralab.schema.impl.compilation.InMemoryClassFile;
import de.uni_koblenz.jgralab.schema.impl.compilation.ManagableArtifact;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Logger;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class ClassFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final Logger logger = null;
    private final String qualifiedSchemaName;

    public ClassFileManager(ManagableArtifact ma, JavaFileManager fm) {
        super(fm);
        this.qualifiedSchemaName = ma.getManagedName();
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return super.hasLocation(location) || location.getName().equals("CLASS_PATH");
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (this.logger != null && location.getName().equals("CLASS_PATH")) {
            this.logger.fine("(" + location + ", " + file + ")");
        }
        if (location.getName().equals("CLASS_PATH") && file instanceof ClassFileObject) {
            return ((ClassFileObject)file).getBinaryName();
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
        if (this.logger != null) {
            this.logger.fine("(" + location + ", " + className + ", " + (Object)((Object)kind) + ", " + sibling + ")");
        }
        InMemoryClassFile cfa = new InMemoryClassFile(className);
        SchemaClassManager.instance(this.qualifiedSchemaName).putSchemaClass(className, cfa);
        return cfa;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        EclipseAdapter ea;
        if (this.logger != null) {
            this.logger.fine("(" + location + ", " + packageName + ", " + kinds + ", " + recurse + ")");
        }
        if ((ea = JGraLab.getEclipseAdapter()) == null || !location.getName().equals("CLASS_PATH") || !kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            return super.list(location, packageName, kinds, recurse);
        }
        return ea.listJavaFileObjects(packageName, recurse);
    }
}

