/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.IncidenceDirection;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.DirectedSchemaEdgeClass;
import de.uni_koblenz.jgralab.schema.impl.GraphClassImpl;
import de.uni_koblenz.jgralab.schema.impl.GraphElementClassImpl;
import de.uni_koblenz.jgralab.schema.impl.IncidenceClassImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VertexClassImpl
extends GraphElementClassImpl<VertexClass, Vertex>
implements VertexClass {
    private Set<IncidenceClass> inIncidenceClasses = new HashSet<IncidenceClass>();
    private Set<IncidenceClass> allInIncidenceClasses;
    private Set<IncidenceClass> outIncidenceClasses = new HashSet<IncidenceClass>();
    private Set<IncidenceClass> allOutIncidenceClasses;
    private Set<IncidenceClass> validFromFarIncidenceClasses;
    private Set<EdgeClass> validFromEdgeClasses;
    private Set<EdgeClass> validToEdgeClasses;
    private Set<IncidenceClass> validToFarIncidenceClasses;
    private Map<String, DirectedSchemaEdgeClass> farRoleNameToEdgeClass;

    protected VertexClassImpl(String simpleName, PackageImpl pkg, GraphClassImpl gc) {
        super(simpleName, pkg, gc, gc.vertexClassDag);
        this.parentPackage.addVertexClass(this);
        this.graphClass.addVertexClass(this);
    }

    void addInIncidenceClass(IncidenceClass incClass) {
        if (incClass.getVertexClass() != this) {
            this.throwSchemaException(incClass);
        }
        this.checkDuplicateRolenames(incClass);
        this.inIncidenceClasses.add(incClass);
    }

    void addOutIncidenceClass(IncidenceClass incClass) {
        if (incClass.getVertexClass() != this) {
            this.throwSchemaException(incClass);
        }
        this.checkDuplicateRolenames(incClass);
        this.outIncidenceClasses.add(incClass);
    }

    private void checkDuplicateRolenames(IncidenceClass incClass) {
        String rolename = incClass.getOpposite().getRolename();
        if (rolename.isEmpty()) {
            return;
        }
        this.checkDuplicatedRolenameForACyclicIncidence(incClass);
        this.checkDuplicatedRolenameForAllIncidences(incClass, this.getAllInIncidenceClasses());
        this.checkDuplicatedRolenameForAllIncidences(incClass, this.getAllOutIncidenceClasses());
    }

    private void checkDuplicatedRolenameForACyclicIncidence(IncidenceClass incClass) {
        boolean identicalClasses;
        String rolename = incClass.getOpposite().getRolename();
        VertexClass oppositeVertexClass = incClass.getOpposite().getVertexClass();
        boolean equalRolenames = incClass.getRolename().equals(rolename);
        boolean bl = identicalClasses = this == oppositeVertexClass;
        if (equalRolenames && identicalClasses) {
            throw new SchemaException("The rolename " + incClass.getRolename() + " may be not used at both ends of the reflexive edge class " + incClass.getEdgeClass().getQualifiedName());
        }
    }

    private void checkDuplicatedRolenameForAllIncidences(IncidenceClass incClass, Set<IncidenceClass> incidenceSet) {
        String rolename = incClass.getOpposite().getRolename();
        if (rolename.isEmpty()) {
            return;
        }
        for (IncidenceClass incidence : incidenceSet) {
            if (incidence == incClass || !incidence.getOpposite().getRolename().equals(rolename)) continue;
            throw new SchemaException("The rolename " + incidence.getOpposite().getRolename() + " is used twice at class " + this.getQualifiedName() + ". Concerning edge classes are " + incClass.getEdgeClass().getQualifiedName() + " and " + incidence.getEdgeClass().getQualifiedName());
        }
    }

    private void throwSchemaException(IncidenceClass ic) {
        throw new SchemaException("Try to add IncidenceClass ending at '" + ic.getVertexClass().getQualifiedName() + "' to VertexClass '" + this.getQualifiedName() + "'.IncidenceClasses may be added only to VertexClasses they are connected to.");
    }

    @Override
    public void addSuperClass(VertexClass superClass) {
        this.assertNotFinished();
        if (superClass == this) {
            return;
        }
        this.checkDuplicateRolenames(superClass);
        super.addSuperClass(superClass);
    }

    private void checkDuplicateRolenames(VertexClass superClass) {
        this.checkDuplicatedRolenamesAgainstAllIncidences(superClass.getAllInIncidenceClasses());
        this.checkDuplicatedRolenamesAgainstAllIncidences(superClass.getAllOutIncidenceClasses());
    }

    private void checkDuplicatedRolenamesAgainstAllIncidences(Set<IncidenceClass> incidences) {
        for (IncidenceClass incidence : incidences) {
            this.checkDuplicateRolenames(incidence);
        }
    }

    @Override
    public Set<IncidenceClass> getValidFromFarIncidenceClasses() {
        if (this.isFinished()) {
            return this.validFromFarIncidenceClasses;
        }
        HashSet<IncidenceClass> validFromInc = new HashSet<IncidenceClass>();
        for (IncidenceClass ic : this.getAllOutIncidenceClasses()) {
            IncidenceClass farInc = ic.getEdgeClass().getTo();
            validFromInc.add(farInc);
        }
        for (VertexClass vc : this.getAllSuperClasses()) {
            for (IncidenceClass ic : vc.getAllOutIncidenceClasses()) {
                IncidenceClass farInc = ic.getEdgeClass().getTo();
                validFromInc.add(farInc);
            }
        }
        return validFromInc;
    }

    @Override
    public Set<IncidenceClass> getValidToFarIncidenceClasses() {
        if (this.isFinished()) {
            return this.validToFarIncidenceClasses;
        }
        HashSet<IncidenceClass> validToInc = new HashSet<IncidenceClass>();
        for (IncidenceClass ic : this.getAllInIncidenceClasses()) {
            IncidenceClass farInc = ic.getEdgeClass().getFrom();
            validToInc.add(farInc);
        }
        for (VertexClass vc : this.getAllSuperClasses()) {
            for (IncidenceClass ic : vc.getAllInIncidenceClasses()) {
                IncidenceClass farInc = ic.getEdgeClass().getFrom();
                validToInc.add(farInc);
            }
        }
        return validToInc;
    }

    @Override
    public Set<EdgeClass> getValidFromEdgeClasses() {
        if (this.isFinished()) {
            return this.validFromEdgeClasses;
        }
        HashSet<EdgeClass> validFrom = new HashSet<EdgeClass>();
        for (IncidenceClass ic : this.getValidFromFarIncidenceClasses()) {
            if (ic.getEdgeClass().isDefaultGraphElementClass()) continue;
            validFrom.add(ic.getEdgeClass());
        }
        return validFrom;
    }

    @Override
    public Set<EdgeClass> getValidToEdgeClasses() {
        if (this.isFinished()) {
            return this.validToEdgeClasses;
        }
        HashSet<EdgeClass> validTo = new HashSet<EdgeClass>();
        for (IncidenceClass ic : this.getValidToFarIncidenceClasses()) {
            if (ic.getEdgeClass().isDefaultGraphElementClass()) continue;
            validTo.add(ic.getEdgeClass());
        }
        return validTo;
    }

    public Set<IncidenceClass> getOwnInIncidenceClasses() {
        return this.inIncidenceClasses;
    }

    public Set<IncidenceClass> getOwnOutIncidenceClasses() {
        return this.outIncidenceClasses;
    }

    @Override
    public Set<IncidenceClass> getAllInIncidenceClasses() {
        if (this.isFinished()) {
            return this.allInIncidenceClasses;
        }
        HashSet<IncidenceClass> incidenceClasses = new HashSet<IncidenceClass>();
        incidenceClasses.addAll(this.inIncidenceClasses);
        for (VertexClass vc : this.getDirectSuperClasses()) {
            incidenceClasses.addAll(vc.getAllInIncidenceClasses());
        }
        return incidenceClasses;
    }

    @Override
    public Set<IncidenceClass> getAllOutIncidenceClasses() {
        if (this.isFinished()) {
            return this.allOutIncidenceClasses;
        }
        HashSet<IncidenceClass> incidenceClasses = new HashSet<IncidenceClass>();
        incidenceClasses.addAll(this.outIncidenceClasses);
        for (VertexClass vc : this.getDirectSuperClasses()) {
            incidenceClasses.addAll(vc.getAllOutIncidenceClasses());
        }
        return incidenceClasses;
    }

    @Override
    public Set<IncidenceClass> getOwnAndInheritedFarIncidenceClasses() {
        HashSet<IncidenceClass> result = new HashSet<IncidenceClass>();
        for (IncidenceClass ic : this.getAllInIncidenceClasses()) {
            result.add(ic.getEdgeClass().getFrom());
            for (IncidenceClass sup : ic.getSubsettedIncidenceClasses()) {
                result.add(sup.getEdgeClass().getFrom());
            }
        }
        for (IncidenceClass ic : this.getAllOutIncidenceClasses()) {
            result.add(ic.getEdgeClass().getTo());
            for (IncidenceClass sup : ic.getSubsettedIncidenceClasses()) {
                result.add(sup.getEdgeClass().getTo());
            }
        }
        return result;
    }

    @Override
    public Set<EdgeClass> getConnectedEdgeClasses() {
        HashSet<EdgeClass> result = new HashSet<EdgeClass>();
        for (IncidenceClass ic : this.getAllInIncidenceClasses()) {
            result.add(ic.getEdgeClass());
        }
        for (IncidenceClass ic : this.getAllOutIncidenceClasses()) {
            result.add(ic.getEdgeClass());
        }
        return result;
    }

    @Override
    public Set<EdgeClass> getOwnConnectedEdgeClasses() {
        HashSet<EdgeClass> result = new HashSet<EdgeClass>();
        for (IncidenceClass ic : this.getOwnInIncidenceClasses()) {
            result.add(ic.getEdgeClass());
        }
        for (IncidenceClass ic : this.getOwnOutIncidenceClasses()) {
            result.add(ic.getEdgeClass());
        }
        return result;
    }

    @Override
    protected void finish() {
        this.allInIncidenceClasses = new HashSet<IncidenceClass>();
        this.allInIncidenceClasses.addAll(this.inIncidenceClasses);
        this.allOutIncidenceClasses = new HashSet<IncidenceClass>();
        this.allOutIncidenceClasses.addAll(this.outIncidenceClasses);
        for (VertexClass vc : this.getDirectSuperClasses()) {
            this.allInIncidenceClasses.addAll(vc.getAllInIncidenceClasses());
            this.allOutIncidenceClasses.addAll(vc.getAllOutIncidenceClasses());
        }
        this.allInIncidenceClasses = Collections.unmodifiableSet(this.allInIncidenceClasses);
        this.allOutIncidenceClasses = Collections.unmodifiableSet(this.allOutIncidenceClasses);
        this.validFromFarIncidenceClasses = Collections.unmodifiableSet(this.getValidFromFarIncidenceClasses());
        this.validToFarIncidenceClasses = Collections.unmodifiableSet(this.getValidToFarIncidenceClasses());
        this.validFromEdgeClasses = Collections.unmodifiableSet(this.getValidFromEdgeClasses());
        this.validToEdgeClasses = Collections.unmodifiableSet(this.getValidToEdgeClasses());
        this.farRoleNameToEdgeClass = new HashMap<String, DirectedSchemaEdgeClass>();
        for (IncidenceClass ic : this.getOwnAndInheritedFarIncidenceClasses()) {
            String role = ic.getRolename();
            if (role.length() == 0) continue;
            this.farRoleNameToEdgeClass.put(role, this.getDirectedEdgeClassForFarEndRole(role));
        }
        this.farRoleNameToEdgeClass = Collections.unmodifiableMap(this.farRoleNameToEdgeClass);
        this.inIncidenceClasses = Collections.unmodifiableSet(this.inIncidenceClasses);
        this.outIncidenceClasses = Collections.unmodifiableSet(this.outIncidenceClasses);
        for (IncidenceClass ic : this.inIncidenceClasses) {
            ((IncidenceClassImpl)ic).finish();
        }
        for (IncidenceClass ic : this.outIncidenceClasses) {
            ((IncidenceClassImpl)ic).finish();
        }
        super.finish();
    }

    @Override
    public boolean isValidFromFor(EdgeClass ec) {
        if (ec.equals(this.graphClass.getTemporaryEdgeClass())) {
            return true;
        }
        return this.getValidFromEdgeClasses().contains(ec);
    }

    @Override
    public boolean isValidToFor(EdgeClass ec) {
        if (ec.equals(this.graphClass.getTemporaryEdgeClass())) {
            return true;
        }
        return this.getValidToEdgeClasses().contains(ec);
    }

    @Override
    public DirectedSchemaEdgeClass getDirectedEdgeClassForFarEndRole(String roleName) {
        if (this.isFinished()) {
            return this.farRoleNameToEdgeClass.get(roleName);
        }
        for (IncidenceClass ic : this.getOwnAndInheritedFarIncidenceClasses()) {
            if (!roleName.equals(ic.getRolename())) continue;
            EdgeClass ec = ic.getEdgeClass();
            return new DirectedSchemaEdgeClass(ec, ic.getDirection() == IncidenceDirection.IN ? EdgeDirection.OUT : EdgeDirection.IN);
        }
        return null;
    }

    @Override
    protected void reopen() {
        this.allInIncidenceClasses = null;
        this.allOutIncidenceClasses = null;
        this.validFromFarIncidenceClasses = null;
        this.validToFarIncidenceClasses = null;
        this.validFromEdgeClasses = null;
        this.validToEdgeClasses = null;
        this.farRoleNameToEdgeClass = null;
        for (IncidenceClass ic : this.inIncidenceClasses) {
            ((IncidenceClassImpl)ic).reopen();
        }
        for (IncidenceClass ic : this.outIncidenceClasses) {
            ((IncidenceClassImpl)ic).reopen();
        }
        this.inIncidenceClasses = new HashSet<IncidenceClass>(this.inIncidenceClasses);
        this.outIncidenceClasses = new HashSet<IncidenceClass>(this.outIncidenceClasses);
        super.reopen();
    }

    @Override
    protected final void register() {
        super.register();
        this.graphClass.vertexClasses.put(this.qualifiedName, this);
        this.parentPackage.vertexClasses.put(this.simpleName, this);
    }

    @Override
    protected final void unregister() {
        super.unregister();
        this.graphClass.vertexClasses.remove(this.qualifiedName);
        this.parentPackage.vertexClasses.remove(this.simpleName);
    }

    @Override
    public void delete() {
        this.schema.assertNotFinished();
        if (this == this.graphClass.getDefaultVertexClass()) {
            throw new SchemaException("The default vertex class cannot be deleted.");
        }
        if (!this.getConnectedEdgeClasses().isEmpty()) {
            throw new SchemaException("Cannot delete vertex class " + this.qualifiedName + " because there are still connected edge classes: " + this.getConnectedEdgeClasses());
        }
        super.delete();
        this.graphClass.vertexClasses.remove(this.qualifiedName);
        this.graphClass.vertexClassDag.delete(this);
        this.parentPackage.vertexClasses.remove(this.simpleName);
    }

    void unlink(IncidenceClass ic) {
        this.schema.assertNotFinished();
        this.outIncidenceClasses.remove(ic);
        this.inIncidenceClasses.remove(ic);
    }

    @Override
    protected VertexClass getDefaultClass() {
        return this.graphClass.getDefaultVertexClass();
    }

    @Override
    public boolean isDefaultGraphElementClass() {
        return this == this.graphClass.getDefaultVertexClass();
    }
}

