/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.RecordImpl;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.exception.CycleException;
import de.uni_koblenz.jgralab.schema.exception.SchemaClassAccessException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.CompositeDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.DomainImpl;
import de.uni_koblenz.jgralab.schema.impl.NamedElementImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class RecordDomainImpl
extends CompositeDomainImpl
implements RecordDomain {
    private Class<? extends Object> schemaClass;
    private final Map<String, RecordDomain.RecordComponent> components = new TreeMap<String, RecordDomain.RecordComponent>();

    RecordDomainImpl(String sn, PackageImpl pkg, Collection<RecordDomain.RecordComponent> components) {
        super(sn, pkg);
        if (components != null) {
            for (RecordDomain.RecordComponent c : components) {
                this.addComponent(c.getName(), c.getDomain());
            }
        }
    }

    @Override
    public void addComponent(String name, Domain domain) {
        SchemaImpl s = (SchemaImpl)this.getSchema();
        s.assertNotFinished();
        if (name.isEmpty()) {
            throw new SchemaException("Cannot create a record component with an empty name.");
        }
        if (this.components.containsKey(name)) {
            throw new SchemaException("Duplicate component '" + name + "' in " + this);
        }
        if (this.getSchema() != domain.getSchema()) {
            throw new SchemaException("Domain " + domain.getQualifiedName() + " belongs to a different schema.");
        }
        try {
            s.addDomainDependency(this, domain);
        }
        catch (CycleException e) {
            throw new SchemaException("Adding the component '" + name + "' of type '" + domain + "' to '" + this + "' would create a cycle of RecordDomains.");
        }
        RecordDomain.RecordComponent c = new RecordDomain.RecordComponent(name, domain);
        this.components.put(name, c);
    }

    @Override
    public Collection<RecordDomain.RecordComponent> getComponents() {
        return this.components.values();
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String schemaRootPackagePrefix) {
        return schemaRootPackagePrefix + "." + this.getQualifiedName();
    }

    @Override
    public String getJavaClassName(String schemaRootPackagePrefix) {
        return this.getJavaAttributeImplementationTypeName(schemaRootPackagePrefix);
    }

    @Override
    public Class<? extends Object> getSchemaClass() {
        if (this.schemaClass == null) {
            String schemaClassName = this.getSchema().getPackagePrefix() + "." + this.getQualifiedName();
            try {
                this.schemaClass = Class.forName(schemaClassName, true, SchemaClassManager.instance(this.getSchema().getQualifiedName()));
            }
            catch (ClassNotFoundException e) {
                throw new SchemaClassAccessException("Can't load (generated) schema class for RecordDomain '" + this.getQualifiedName() + "'", e);
            }
        }
        return this.schemaClass;
    }

    @Override
    public CodeBlock getReadMethod(String schemaPrefix, String variableName, String graphIoVariableName) {
        CodeSnippet code = new CodeSnippet();
        code.setVariable("name", variableName);
        code.setVariable("init", "");
        this.internalGetReadMethod(code, schemaPrefix, variableName, graphIoVariableName);
        return code;
    }

    @Override
    public String getTGTypeName(Package pkg) {
        return this.getQualifiedName(pkg);
    }

    @Override
    public CodeBlock getWriteMethod(String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        CodeSnippet code = new CodeSnippet();
        code.setVariable("name", variableName);
        this.internalGetWriteMethod(code, schemaRootPackagePrefix, variableName, graphIoVariableName);
        return code;
    }

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder("Record " + this.getQualifiedName());
        String delim = " (";
        for (RecordDomain.RecordComponent component : this.components.values()) {
            output.append(delim);
            output.append(component.getName());
            output.append('=');
            output.append(component.getDomain());
            delim = ", ";
        }
        output.append(")");
        return output.toString();
    }

    private void internalGetReadMethod(CodeSnippet code, String schemaPrefix, String variableName, String graphIoVariableName) {
        code.add("#init#");
        code.add("if (" + graphIoVariableName + ".isNextToken(\"(\")) {");
        code.add("\t#name# = new " + this.getSchema().getPackagePrefix() + "." + this.getQualifiedName() + "(io);");
        code.add("} else if (" + graphIoVariableName + ".isNextToken(GraphIO.NULL_LITERAL)) {");
        code.add("\t" + graphIoVariableName + ".match();");
        code.add("\t" + variableName + " = null;");
        code.add("} else {");
        code.add("\tthrow new GraphIOException(\"Read record: '(' or 'n' expected\");");
        code.add("}");
    }

    private void internalGetWriteMethod(CodeSnippet code, String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        code.add("if (#name# != null) {");
        code.add("\t#name#.writeComponentValues(" + graphIoVariableName + ");");
        code.add("} else {");
        code.add("\t" + graphIoVariableName + ".writeIdentifier(GraphIO.NULL_LITERAL);");
        code.add("}");
    }

    @Override
    public CodeBlock getTransactionReadMethod(String schemaPrefix, String variableName, String graphIoVariableName) {
        CodeSnippet code = new CodeSnippet();
        code.setVariable("name", variableName);
        code.setVariable("init", this.getJavaAttributeImplementationTypeName(schemaPrefix) + " #name# = null;");
        this.internalGetReadMethod(code, schemaPrefix, variableName, graphIoVariableName);
        return code;
    }

    @Override
    public CodeBlock getTransactionWriteMethod(String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        CodeSnippet code = new CodeSnippet();
        code.setVariable("name", "get" + CodeGenerator.camelCase(variableName) + "()");
        this.internalGetWriteMethod(code, schemaRootPackagePrefix, variableName, graphIoVariableName);
        return code;
    }

    @Override
    public String getTransactionJavaAttributeImplementationTypeName(String schemaRootPackagePrefix) {
        return this.getJavaAttributeImplementationTypeName(schemaRootPackagePrefix);
    }

    @Override
    public String getTransactionJavaClassName(String schemaRootPackagePrefix) {
        return this.getJavaAttributeImplementationTypeName(schemaRootPackagePrefix);
    }

    @Override
    public String getVersionedClass(String schemaRootPackagePrefix) {
        return "de.uni_koblenz.jgralab.impl.trans.VersionedReferenceImpl<" + this.getTransactionJavaAttributeImplementationTypeName(schemaRootPackagePrefix) + ">";
    }

    @Override
    public String getInitialValue() {
        return "null";
    }

    @Override
    public Boolean hasComponent(String name) {
        return this.components.containsKey(name);
    }

    @Override
    public Object parseGenericAttribute(GraphIO io) throws GraphIOException {
        if (io.isNextToken("(")) {
            RecordImpl result = RecordImpl.empty();
            io.match("(");
            Iterator<RecordDomain.RecordComponent> componentIterator = this.getComponents().iterator();
            RecordDomain.RecordComponent component = componentIterator.next();
            while (!io.isNextToken(")")) {
                Object componentValue = null;
                componentValue = component.getDomain().parseGenericAttribute(io);
                result = result.plus(component.getName(), componentValue);
                component = componentIterator.hasNext() ? componentIterator.next() : null;
            }
            assert (!componentIterator.hasNext());
            io.match(")");
            return result;
        }
        if (io.isNextToken("n")) {
            io.match();
            return null;
        }
        throw new GraphIOException("Read record: '(' or 'n' excpected");
    }

    @Override
    public void serializeGenericAttribute(GraphIO io, Object data) throws IOException {
        if (data != null) {
            io.writeSpace();
            io.write("(");
            io.noSpace();
            for (RecordDomain.RecordComponent rc : this.getComponents()) {
                rc.getDomain().serializeGenericAttribute(io, ((Record)data).getComponent(rc.getName()));
            }
            io.write(")");
        } else {
            io.writeIdentifier("n");
        }
    }

    @Override
    public boolean isConformValue(Object value) {
        boolean result = true;
        if (value == null) {
            return result;
        }
        if (value instanceof RecordImpl) {
            if (!(result &= value instanceof Record)) {
                return false;
            }
            Iterator<RecordDomain.RecordComponent> iterator = this.getComponents().iterator();
            while (iterator.hasNext() && result) {
                RecordDomain.RecordComponent component = iterator.next();
                result &= component.getDomain().isConformValue(((Record)value).getComponent(component.getName()));
            }
            return result;
        }
        if (value instanceof Record) {
            return value.getClass().equals(this.getSchemaClass());
        }
        return false;
    }

    @Override
    public void setQualifiedName(String newQName) {
        if (this.qualifiedName.equals(newQName)) {
            return;
        }
        if (this.schema.knows(newQName)) {
            throw new SchemaException(newQName + " is already known to the schema.");
        }
        String[] ps = SchemaImpl.splitQualifiedName(newQName);
        String newPackageName = ps[0];
        String newSimpleName = ps[1];
        if (!NamedElementImpl.ATTRELEM_OR_NOCOLLDOMAIN_PATTERN.matcher(newSimpleName).matches()) {
            throw new SchemaException("Invalid record domain name '" + newSimpleName + "'.");
        }
        this.unregister();
        this.qualifiedName = newQName;
        this.simpleName = newSimpleName;
        this.parentPackage = this.schema.createPackageWithParents(newPackageName);
        this.register();
    }

    @Override
    public void delete() {
        this.schema.assertNotFinished();
        if (!this.attributes.isEmpty()) {
            throw new SchemaException("Cannot delete record domain that is still used by attributes: " + this.attributes);
        }
        this.parentPackage.domains.remove(this.simpleName);
        this.schema.namedElements.remove(this.qualifiedName);
        this.schema.domains.remove(this.qualifiedName);
    }

    @Override
    protected void registerAttribute(Attribute a) {
        this.attributes = this.attributes.plus(a);
        for (RecordDomain.RecordComponent rc : this.components.values()) {
            ((DomainImpl)rc.getDomain()).registerAttribute(a);
        }
    }
}

