/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.IncidenceDirection;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.EdgeClassImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.VertexClassImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class IncidenceClassImpl
implements IncidenceClass {
    private AggregationKind aggregationKind;
    private final EdgeClass edgeClass;
    private final VertexClass vertexClass;
    private final int maxEdgesAtVertex;
    private final int minEdgesAtVertex;
    private String rolename;
    private final IncidenceDirection direction;
    private final Set<IncidenceClass> subsettedIncidenceClasses;
    private Set<IncidenceClass> allSubsettedIncidenceClasses;
    private final int incidenceClassIdInSchema;

    protected IncidenceClassImpl(EdgeClass edgeClass, VertexClass vertexClass, String rolename, int minEdgesAtVertex, int maxEdgesAtVertex, IncidenceDirection direction, AggregationKind aggregationKind) {
        this.aggregationKind = aggregationKind == null ? AggregationKind.NONE : aggregationKind;
        this.edgeClass = edgeClass;
        this.maxEdgesAtVertex = maxEdgesAtVertex;
        this.minEdgesAtVertex = minEdgesAtVertex;
        this.rolename = rolename == null ? "" : rolename;
        this.direction = direction;
        this.vertexClass = vertexClass;
        this.subsettedIncidenceClasses = new HashSet<IncidenceClass>();
        this.incidenceClassIdInSchema = ((SchemaImpl)edgeClass.getSchema()).getNextIncidenceClassId();
    }

    @Override
    public AggregationKind getAggregationKind() {
        return this.aggregationKind;
    }

    @Override
    public IncidenceClass getOpposite() {
        if (this.edgeClass.getFrom() == this) {
            return this.edgeClass.getTo();
        }
        return this.edgeClass.getFrom();
    }

    @Override
    public void setAggregationKind(AggregationKind kind) {
        if (kind != AggregationKind.NONE && this.getOpposite().getAggregationKind() != AggregationKind.NONE) {
            throw new SchemaException("At least one end of each EdgeClass must be of AggregationKind NONE at EdgeClass " + this.edgeClass.getQualifiedName());
        }
        this.aggregationKind = kind;
    }

    @Override
    public IncidenceDirection getDirection() {
        return this.direction;
    }

    @Override
    public EdgeClass getEdgeClass() {
        return this.edgeClass;
    }

    @Override
    public int getMax() {
        return this.maxEdgesAtVertex;
    }

    @Override
    public int getMin() {
        return this.minEdgesAtVertex;
    }

    @Override
    public String getRolename() {
        return this.rolename;
    }

    @Override
    public Set<IncidenceClass> getOwnSubsettedIncidenceClasses() {
        return this.subsettedIncidenceClasses;
    }

    @Override
    public Set<IncidenceClass> getSubsettedIncidenceClasses() {
        if (((VertexClassImpl)this.vertexClass).isFinished()) {
            return this.allSubsettedIncidenceClasses;
        }
        HashSet<IncidenceClass> result = new HashSet<IncidenceClass>();
        result.addAll(this.subsettedIncidenceClasses);
        for (IncidenceClass ic : this.subsettedIncidenceClasses) {
            result.addAll(ic.getSubsettedIncidenceClasses());
        }
        return result;
    }

    @Override
    public VertexClass getVertexClass() {
        return this.vertexClass;
    }

    public void addSubsettedIncidenceClass(IncidenceClass other) {
        if (((VertexClassImpl)this.vertexClass).isFinished()) {
            throw new SchemaException("No changes to finished schema!");
        }
        EdgeClassImpl.checkIncidenceClassSpecialization(this, other);
        if (other.getSubsettedIncidenceClasses().contains(this)) {
            throw new SchemaException("Subsetting of IncidenceClasses need to be acyclic");
        }
        this.subsettedIncidenceClasses.add(other);
    }

    @Override
    public Set<String> getAllRoles() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getRolename());
        for (IncidenceClass ic : this.getSubsettedIncidenceClasses()) {
            result.add(ic.getRolename());
        }
        return result;
    }

    void finish() {
        this.allSubsettedIncidenceClasses = new HashSet<IncidenceClass>();
        this.allSubsettedIncidenceClasses.addAll(this.subsettedIncidenceClasses);
        for (IncidenceClass ic : this.subsettedIncidenceClasses) {
            this.allSubsettedIncidenceClasses.addAll(ic.getSubsettedIncidenceClasses());
        }
        this.allSubsettedIncidenceClasses = Collections.unmodifiableSet(this.allSubsettedIncidenceClasses);
    }

    @Override
    public int getIncidenceClassIdInSchema() {
        return this.incidenceClassIdInSchema;
    }

    void reopen() {
        this.allSubsettedIncidenceClasses = null;
    }
}

