/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.exception.SchemaClassAccessException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.DomainImpl;
import de.uni_koblenz.jgralab.schema.impl.NamedElementImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.io.IOException;
import java.util.List;
import org.pcollections.PVector;

public final class EnumDomainImpl
extends DomainImpl
implements EnumDomain {
    private PVector<String> constants = JGraLab.vector();
    private Class<? extends Object> schemaClass;

    EnumDomainImpl(String sn, PackageImpl pkg, List<String> constants) {
        super(sn, pkg);
        for (String c : constants) {
            this.addConst(c);
        }
    }

    @Override
    public void addConst(String aConst) {
        SchemaImpl s = (SchemaImpl)this.getSchema();
        s.assertNotFinished();
        if (this.constants.contains(aConst)) {
            throw new SchemaException("Try to add duplicate constant '" + aConst + "' to EnumDomain" + this.getQualifiedName());
        }
        if (!s.isValidEnumConstant(aConst)) {
            throw new SchemaException(aConst + " is not a valid enumeration constant.");
        }
        this.constants = this.constants.plus(aConst);
    }

    @Override
    public PVector<String> getConsts() {
        return this.constants;
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String schemaRootPackagePrefix) {
        return schemaRootPackagePrefix + "." + this.getQualifiedName();
    }

    @Override
    public String getJavaClassName(String schemaRootPackagePrefix) {
        return this.getJavaAttributeImplementationTypeName(schemaRootPackagePrefix);
    }

    @Override
    public CodeBlock getReadMethod(String schemaPrefix, String variableName, String graphIoVariableName) {
        return new CodeSnippet(variableName + " = " + this.getJavaAttributeImplementationTypeName(schemaPrefix) + ".valueOfPermitNull(" + graphIoVariableName + ".matchEnumConstant());");
    }

    @Override
    public String getTGTypeName(Package pkg) {
        return this.getQualifiedName(pkg);
    }

    @Override
    public CodeBlock getWriteMethod(String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        CodeSnippet code = new CodeSnippet();
        code.add("if (" + variableName + " != null) {");
        code.add("\t" + graphIoVariableName + ".writeIdentifier(" + variableName + ".toString());");
        code.add("} else {");
        code.add("\t" + graphIoVariableName + ".writeIdentifier(GraphIO.NULL_LITERAL);");
        code.add("}");
        return code;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder("domain Enum " + this.getQualifiedName() + " (");
        String delim = "";
        int count = 0;
        for (String s : this.constants) {
            output.append(delim + count++ + ": " + s);
            delim = ", ";
        }
        output.append(")");
        return output.toString();
    }

    @Override
    public CodeBlock getTransactionReadMethod(String schemaPrefix, String variableName, String graphIoVariableName) {
        return new CodeSnippet(this.getJavaAttributeImplementationTypeName(schemaPrefix) + " " + variableName + " = " + this.getJavaAttributeImplementationTypeName(schemaPrefix) + ".valueOfPermitNull(" + graphIoVariableName + ".matchEnumConstant());");
    }

    @Override
    public CodeBlock getTransactionWriteMethod(String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        return this.getWriteMethod(schemaRootPackagePrefix, "get" + CodeGenerator.camelCase(variableName) + "()", graphIoVariableName);
    }

    @Override
    public String getTransactionJavaAttributeImplementationTypeName(String schemaRootPackagePrefix) {
        return this.getJavaAttributeImplementationTypeName(schemaRootPackagePrefix);
    }

    @Override
    public String getTransactionJavaClassName(String schemaRootPackagePrefix) {
        return this.getJavaClassName(schemaRootPackagePrefix);
    }

    @Override
    public String getVersionedClass(String schemaRootPackagePrefix) {
        return "de.uni_koblenz.jgralab.impl.trans.VersionedReferenceImpl<" + this.getTransactionJavaAttributeImplementationTypeName(schemaRootPackagePrefix) + ">";
    }

    @Override
    public String getInitialValue() {
        return "null";
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Class<? extends Object> getSchemaClass() {
        if (this.schemaClass == null) {
            String schemaClassName = this.getSchema().getPackagePrefix() + "." + this.getQualifiedName();
            try {
                this.schemaClass = Class.forName(schemaClassName, true, SchemaClassManager.instance(this.getSchema().getQualifiedName()));
            }
            catch (ClassNotFoundException e) {
                throw new SchemaClassAccessException("Can't load (generated) schema class for EnumDomain '" + this.getQualifiedName() + "'", e);
            }
        }
        return this.schemaClass;
    }

    @Override
    public Object parseGenericAttribute(GraphIO io) throws GraphIOException {
        String result = io.matchEnumConstant();
        return result;
    }

    @Override
    public void serializeGenericAttribute(GraphIO io, Object data) throws IOException {
        if (data != null) {
            io.writeIdentifier((String)data);
        } else {
            io.writeIdentifier("n");
        }
    }

    @Override
    public void setQualifiedName(String newQName) {
        if (this.qualifiedName.equals(newQName)) {
            return;
        }
        if (this.schema.knows(newQName)) {
            throw new SchemaException(newQName + " is already known to the schema.");
        }
        String[] ps = SchemaImpl.splitQualifiedName(newQName);
        String newPackageName = ps[0];
        String newSimpleName = ps[1];
        if (!NamedElementImpl.ATTRELEM_OR_NOCOLLDOMAIN_PATTERN.matcher(newSimpleName).matches()) {
            throw new SchemaException("Invalid enum domain name '" + newSimpleName + "'.");
        }
        this.unregister();
        this.qualifiedName = newQName;
        this.simpleName = newSimpleName;
        this.parentPackage = this.schema.createPackageWithParents(newPackageName);
        this.register();
    }

    @Override
    public void delete() {
        this.schema.assertNotFinished();
        if (!this.attributes.isEmpty()) {
            throw new SchemaException("Cannot delete enum domain that is still used by attributes: " + this.attributes);
        }
        this.parentPackage.domains.remove(this.simpleName);
        this.schema.namedElements.remove(this.qualifiedName);
        this.schema.domains.remove(this.qualifiedName);
    }

    @Override
    public boolean isConformValue(Object value) {
        boolean result = true;
        if (value == null) {
            return result;
        }
        if (value instanceof Enum) {
            return this.getSchemaClass().isInstance(value);
        }
        return result &= value instanceof String && this.getConsts().contains(value);
    }
}

