/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.schema.Constraint;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;

public class ConstraintImpl
implements Constraint {
    private String message;
    private String predicate;
    private String offendingElements;

    public ConstraintImpl(String msg, String pred, String offendingElems) {
        this.message = msg;
        this.predicate = pred;
        this.offendingElements = offendingElems;
    }

    public ConstraintImpl(String msg, String pred) {
        this(msg, pred, null);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getOffendingElementsQuery() {
        return this.offendingElements;
    }

    @Override
    public String getPredicate() {
        return this.predicate;
    }

    public boolean equals(Object o) {
        if (o instanceof Constraint) {
            Constraint other = (Constraint)o;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.message.hashCode();
        hash = 31 * hash + this.predicate.hashCode();
        hash = 31 * hash + (null == this.offendingElements ? 0 : this.offendingElements.hashCode());
        return hash;
    }

    @Override
    public int compareTo(Constraint o) {
        int result = this.message.compareTo(o.getMessage());
        if (result != 0) {
            return result;
        }
        result = this.predicate.compareTo(o.getPredicate());
        if (result != 0) {
            return result;
        }
        if (this.offendingElements != null) {
            return this.offendingElements.compareTo(o.getOffendingElementsQuery());
        }
        if (o.getOffendingElementsQuery() == null) {
            return 0;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{Constraint: message = \"");
        sb.append(CodeGenerator.stringQuote(this.message));
        sb.append("\", predicate = \"");
        sb.append(CodeGenerator.stringQuote(this.predicate));
        sb.append("\", offendingElements = ");
        sb.append(this.offendingElements == null ? "<no offending elems query>" : this.offendingElements);
        sb.append("}");
        return sb.toString();
    }
}

