/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.StringDomain;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;

public class RecordCodeGenerator
extends CodeGenerator {
    protected RecordDomain recordDomain;

    public RecordCodeGenerator(RecordDomain recordDomain, String schemaPackageName, CodeGeneratorConfiguration config) {
        super(schemaPackageName, recordDomain.getPackageName(), config);
        this.rootBlock.setVariable("simpleClassName", recordDomain.getSimpleName());
        this.rootBlock.setVariable("isClassOnly", "true");
        this.recordDomain = recordDomain;
    }

    @Override
    protected CodeBlock createBody() {
        CodeList code = new CodeList();
        if (this.currentCycle.isClassOnly()) {
            code.add(this.createRecordComponents());
            code.add(this.createFieldConstructor());
            code.add(this.createMapConstructor());
            code.add(this.createGraphIOConstructor());
            code.add(this.createGetterMethods());
            code.add(this.createGenericGetter());
            code.add(this.createToStringMethod());
            code.add(this.createWriteComponentsMethod());
            code.add(this.createToPMapMethod());
            code.add(this.createEqualsMethod());
            code.add(this.createHashCodeMethod());
        }
        return code;
    }

    private CodeBlock createGraphIOConstructor() {
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException");
        CodeList code = new CodeList();
        code.addNoIndent(new CodeSnippet(true, "public #simpleClassName#(GraphIO io) throws GraphIOException {"));
        code.add(new CodeSnippet("io.match(\"(\");"));
        for (RecordDomain.RecordComponent rc : this.recordDomain.getComponents()) {
            code.add(rc.getDomain().getReadMethod(this.schemaRootPackageName, "_" + rc.getName(), "io"));
        }
        code.add(new CodeSnippet("io.match(\")\");"));
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    private CodeBlock createFieldConstructor() {
        CodeList code = new CodeList();
        StringBuilder sb = new StringBuilder();
        code.addNoIndent(new CodeSnippet(true, "public #simpleClassName#(#fields#) {"));
        String delim = "";
        for (RecordDomain.RecordComponent rc : this.recordDomain.getComponents()) {
            sb.append(delim);
            delim = ", ";
            sb.append(rc.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
            sb.append(" _");
            sb.append(rc.getName());
            CodeSnippet assign = null;
            assign = new CodeSnippet("this._#name# = _#name#;");
            assign.setVariable("name", rc.getName());
            code.add(assign);
        }
        code.setVariable("fields", sb.toString());
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    private CodeBlock createMapConstructor() {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.exception.NoSuchAttributeException");
        code.setVariable("rcname", this.recordDomain.getQualifiedName());
        CodeSnippet suppressUnchecked = new CodeSnippet("");
        code.addNoIndent(suppressUnchecked);
        code.addNoIndent(new CodeSnippet("public #simpleClassName#(java.util.Map<String, Object> componentValues) {"));
        code.add(new CodeSnippet("assert componentValues.size() == " + this.recordDomain.getComponents().size() + ";"));
        for (RecordDomain.RecordComponent rc : this.recordDomain.getComponents()) {
            if (rc.getDomain().isComposite() && suppressUnchecked.size() <= 1) {
                suppressUnchecked.add("@SuppressWarnings(\"unchecked\")");
            }
            CodeSnippet assign = new CodeSnippet("assert componentValues.containsKey(\"#name#\");", "_#name# = (#cls#)componentValues.get(\"#name#\");");
            assign.setVariable("name", rc.getName());
            assign.setVariable("cls", rc.getDomain().getJavaClassName(this.schemaRootPackageName));
            code.add(assign);
        }
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    private CodeBlock createToPMapMethod() {
        CodeList code = new CodeList();
        code.addNoIndent(new CodeSnippet("public org.pcollections.PMap<String, Object> toPMap() {"));
        code.add(new CodeSnippet("org.pcollections.PMap<String, Object> m = de.uni_koblenz.jgralab.JGraLab.map();"));
        for (RecordDomain.RecordComponent rc : this.recordDomain.getComponents()) {
            CodeSnippet assign = new CodeSnippet("m = m.plus(\"#name#\", _#name#);");
            assign.setVariable("name", rc.getName());
            code.add(assign);
        }
        code.add(new CodeSnippet("return m;"));
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    private CodeBlock createHashCodeMethod() {
        CodeList code = new CodeList();
        code.addNoIndent(new CodeSnippet(true, "@Override", "public int hashCode() {", "\tint h = 0;"));
        for (RecordDomain.RecordComponent rc : this.recordDomain.getComponents()) {
            CodeSnippet assign = new CodeSnippet();
            code.add(assign);
            assign.setVariable("name", rc.getName());
            assign.setVariable("cls", rc.getDomain().getJavaClassName(this.schemaRootPackageName));
            if (rc.getDomain().isPrimitive()) {
                assign.add("h += ((#cls#) _#name#).hashCode();");
                continue;
            }
            assign.add("h += _#name#.hashCode();");
        }
        code.addNoIndent(new CodeSnippet("\treturn h;", "}"));
        return code;
    }

    private CodeBlock createEqualsMethod() {
        CodeSnippet codeSnippet;
        CodeList code = new CodeList();
        code.addNoIndent(new CodeSnippet(true, "@Override", "public boolean equals(Object o) {"));
        code.add(new CodeSnippet("if (o == null) {", "\treturn false;", "}"));
        code.add(new CodeSnippet("if (o instanceof #simpleClassName#) {", "\t#simpleClassName# rec = (#simpleClassName#) o;"));
        for (RecordDomain.RecordComponent rc : this.recordDomain.getComponents()) {
            codeSnippet = new CodeSnippet();
            codeSnippet.setVariable("name", rc.getName());
            if (rc.getDomain().isPrimitive()) {
                codeSnippet.add("\tif (_#name# != rec._#name#) {");
                codeSnippet.add("\t\treturn false;", "\t}");
            } else {
                codeSnippet.add("\tif (!(_#name#.equals(rec._#name#))) {");
                codeSnippet.add("\t\treturn false;", "\t\t}");
            }
            code.add(codeSnippet);
        }
        code.add(new CodeSnippet("\treturn true;", "}"));
        code.add(new CodeSnippet("if (o instanceof #jgPackage#.Record) {", "\t#jgPackage#.Record rec = (#jgPackage#.Record) o;", "\tif (rec.size() != " + this.recordDomain.getComponents().size() + ") {", "\t\treturn false;", "\t}", "\ttry {"));
        for (RecordDomain.RecordComponent rc : this.recordDomain.getComponents()) {
            codeSnippet = new CodeSnippet("\t\tif (!rec.getComponent(\"#name#\").equals(_#name#)) {", "\t\t\treturn false;", "\t\t}");
            codeSnippet.setVariable("name", rc.getName());
            code.add(codeSnippet);
        }
        code.add(new CodeSnippet("\t\treturn true;", "\t} catch (NoSuchAttributeException e) {", "\t\treturn false;", "\t}", "}", "return false;"));
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    @Override
    protected CodeBlock createHeader() {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        if (!this.currentCycle.isClassOnly()) {
            return code;
        }
        this.addImports("java.util.Collections", "java.util.List", "java.util.ArrayList");
        code.add("public class #simpleClassName# implements de.uni_koblenz.jgralab.Record {");
        code.add("\tprivate static List<String> componentNames = new ArrayList<String>(" + this.recordDomain.getComponents().size() + ");", "", "\tstatic {");
        for (RecordDomain.RecordComponent rc : this.recordDomain.getComponents()) {
            code.add("\t\tcomponentNames.add(\"" + rc.getName() + "\");");
        }
        code.add("\t\tcomponentNames = Collections.unmodifiableList(componentNames);", "\t}");
        code.add("", "\t@Override", "\tpublic List<String> getComponentNames() {", "\t\treturn componentNames;", "\t}");
        code.add("", "\t@Override", "\tpublic boolean hasComponent(String name) {", "\t\treturn componentNames.contains(name);", "\t}");
        code.add("", "\t@Override", "public int size() {", "\treturn " + this.recordDomain.getComponents().size() + ";", "}");
        return code;
    }

    protected CodeBlock createGetterMethods() {
        CodeList code = new CodeList();
        for (RecordDomain.RecordComponent rc : this.recordDomain.getComponents()) {
            CodeSnippet getterCode = new CodeSnippet(true, new String[0]);
            getterCode.setVariable("name", rc.getName());
            getterCode.setVariable("isOrGet", rc.getDomain().isBoolean() ? "is" : "get");
            getterCode.setVariable("type", rc.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
            getterCode.setVariable("ctype", rc.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
            getterCode.add("public #type# #isOrGet#_#name#() {");
            getterCode.add("\treturn _#name#;");
            getterCode.add("}");
            code.addNoIndent(getterCode);
        }
        return code;
    }

    private CodeBlock createGenericGetter() {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.exception.NoSuchAttributeException");
        code.addNoIndent(new CodeSnippet(true, "@Override", "public Object getComponent(String name) {"));
        for (RecordDomain.RecordComponent rc : this.recordDomain.getComponents()) {
            CodeSnippet assign = null;
            assign = new CodeSnippet("if (name.equals(\"#name#\")) {", "\treturn _#name#;", "}");
            assign.setVariable("name", rc.getName());
            assign.setVariable("cname", rc.getDomain().getJavaClassName(this.schemaRootPackageName));
            assign.setVariable("isOrGet", rc.getDomain().isBoolean() ? "is" : "get");
            code.add(assign);
        }
        code.add(new CodeSnippet("throw new NoSuchAttributeException(\"#rcname# doesn't contain an attribute \" + name);"));
        code.addNoIndent(new CodeSnippet("}"));
        code.setVariable("rcname", this.recordDomain.getQualifiedName());
        return code;
    }

    private CodeBlock createWriteComponentsMethod() {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException", "java.io.IOException");
        code.addNoIndent(new CodeSnippet(true, "@Override", "public void writeComponentValues(GraphIO io) throws IOException, GraphIOException {", "\tio.writeSpace();", "\tio.write(\"(\");", "\tio.noSpace();"));
        for (RecordDomain.RecordComponent rc : this.recordDomain.getComponents()) {
            code.add(rc.getDomain().getWriteMethod(this.schemaRootPackageName, "_" + rc.getName(), "io"));
        }
        code.addNoIndent(new CodeSnippet("\tio.write(\")\");", "}"));
        return code;
    }

    private CodeBlock createRecordComponents() {
        CodeList code = new CodeList();
        for (RecordDomain.RecordComponent rc : this.recordDomain.getComponents()) {
            Domain dom = rc.getDomain();
            CodeSnippet s = new CodeSnippet(true, "private final #type# _#field#;");
            s.setVariable("field", rc.getName());
            s.setVariable("type", dom.getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
            code.addNoIndent(s);
        }
        return code;
    }

    private CodeBlock createToStringMethod() {
        CodeList code = new CodeList();
        code.addNoIndent(new CodeSnippet(true, "@Override", "public String toString() {", "\tStringBuilder sb = new StringBuilder();"));
        String delim = "[";
        for (RecordDomain.RecordComponent rc : this.recordDomain.getComponents()) {
            CodeSnippet s = new CodeSnippet("String #key#String;");
            if (rc.getDomain().isComposite() || rc.getDomain() instanceof StringDomain) {
                s.add("if (_#key# == null) #key#String = \"null\";", "else #key#String = #toString#;");
            } else {
                s.add("#key#String = #toString#;");
            }
            s.add("sb.append(\"#delim#\").append(\"#key#\").append(\"=\").append(#key#String);");
            s.setVariable("delim", delim);
            s.setVariable("key", rc.getName());
            if (rc.getDomain().isComposite()) {
                s.setVariable("toString", "_" + rc.getName() + ".toString()");
            } else {
                s.setVariable("toString", "String.valueOf(_#key#)");
            }
            code.add(s);
            delim = ", ";
        }
        code.addNoIndent(new CodeSnippet("\treturn sb.append(\"]\").toString();", "}"));
        return code;
    }
}

