/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import java.util.Vector;

public class CodeSnippet
extends CodeBlock {
    protected Vector<String> lines;
    protected boolean wantsNewLine;

    public CodeSnippet() {
        this((CodeList)null, new String[0]);
    }

    public CodeSnippet(String ... initialLines) {
        this(null, false, initialLines);
    }

    public CodeSnippet(boolean newLine, String ... initialLines) {
        this(null, newLine, initialLines);
    }

    public CodeSnippet(CodeList parent, String ... initialLines) {
        this(parent, false, initialLines);
    }

    public CodeSnippet(CodeList parent, boolean newLine, String ... initialLines) {
        super(parent);
        this.wantsNewLine = newLine;
        this.lines = new Vector();
        if (initialLines != null) {
            for (String line : initialLines) {
                this.lines.add(line);
            }
        }
    }

    public void setNewLine(boolean b) {
        this.wantsNewLine = b;
    }

    public void add(String ... addedLines) {
        if (addedLines != null) {
            for (String line : addedLines) {
                this.lines.add(line);
            }
        }
    }

    @Override
    public String getCode(int indentLevel) {
        if (this.lines.size() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (this.wantsNewLine) {
            buf.append("\n");
        }
        for (String line : this.lines) {
            for (int i = 0; i < indentLevel; ++i) {
                buf.append('\t');
            }
            if (line.length() > 0) {
                buf.append(this.replaceVariables(line));
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public void clear() {
        this.lines.clear();
    }

    @Override
    public int size() {
        return this.lines.size();
    }
}

