/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.impl.GraphElementImpl;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import de.uni_koblenz.jgralab.impl.VertexBaseImpl;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;

public abstract class IncidenceImpl
extends GraphElementImpl<EdgeClass, Edge>
implements Edge,
InternalEdge {
    protected IncidenceImpl(Graph graph) {
        super(graph);
    }

    @Override
    public InternalEdge getNextIncidence() {
        InternalEdge nextIncidence;
        TraversalContext tc = this.graph.getTraversalContext();
        if (tc != null && nextIncidence != null && !tc.containsEdge(nextIncidence)) {
            for (nextIncidence = this.getNextIncidenceInISeq(); nextIncidence != null && !tc.containsEdge(nextIncidence); nextIncidence = nextIncidence.getNextIncidenceInISeq()) {
            }
        }
        return nextIncidence;
    }

    @Override
    public InternalEdge getPrevIncidence() {
        InternalEdge prevIncidence;
        TraversalContext tc = this.graph.getTraversalContext();
        if (tc != null && prevIncidence != null && !tc.containsEdge(prevIncidence)) {
            for (prevIncidence = this.getPrevIncidenceInISeq(); prevIncidence != null && !tc.containsEdge(prevIncidence); prevIncidence = prevIncidence.getPrevIncidenceInISeq()) {
            }
        }
        return prevIncidence;
    }

    @Override
    public Edge getNextIncidence(EdgeDirection orientation) {
        assert (this.isValid());
        switch (orientation) {
            case IN: {
                Edge i;
                for (i = this.getNextIncidence(); i != null && i.isNormal(); i = i.getNextIncidence()) {
                }
                return i;
            }
            case OUT: {
                Edge i;
                while (i != null && !i.isNormal()) {
                    i = i.getNextIncidence();
                }
                return i;
            }
            case INOUT: {
                Edge i;
                return i;
            }
        }
        throw new RuntimeException("FIXME!");
    }

    @Override
    public Edge getNextIncidence(boolean thisIncidence, AggregationKind ... kinds) {
        Edge i;
        assert (this.isValid());
        if (kinds.length == 0) {
            return i;
        }
        for (i = this.getNextIncidence(); i != null; i = i.getNextIncidence()) {
            for (AggregationKind element : kinds) {
                if ((thisIncidence ? i.getThisAggregationKind() : i.getThatAggregationKind()) != element) continue;
                return i;
            }
        }
        return null;
    }

    @Override
    public Edge getNextIncidence(EdgeClass anEdgeClass) {
        assert (anEdgeClass != null);
        assert (this.isValid());
        return this.getNextIncidence(anEdgeClass, EdgeDirection.INOUT, false);
    }

    @Override
    public Edge getNextIncidence(EdgeClass anEdgeClass, boolean noSubclasses) {
        assert (anEdgeClass != null);
        assert (this.isValid());
        return this.getNextIncidence(anEdgeClass, EdgeDirection.INOUT, noSubclasses);
    }

    @Override
    public Edge getNextIncidence(EdgeClass anEdgeClass, EdgeDirection orientation) {
        assert (anEdgeClass != null);
        assert (this.isValid());
        return this.getNextIncidence(anEdgeClass, orientation, false);
    }

    @Override
    public Edge getNextIncidence(EdgeClass anEdgeClass, EdgeDirection orientation, boolean noSubclasses) {
        assert (anEdgeClass != null);
        assert (this.isValid());
        for (Edge currentEdge = this.getNextIncidence(orientation); currentEdge != null; currentEdge = currentEdge.getNextIncidence(orientation)) {
            if (!(noSubclasses ? anEdgeClass == currentEdge.getAttributedElementClass() : currentEdge.isInstanceOf(anEdgeClass))) continue;
            return currentEdge;
        }
        return null;
    }

    @Override
    public boolean isBeforeIncidence(Edge e) {
        IncidenceImpl i;
        assert (e != null);
        assert (this.isValid());
        assert (e.isValid());
        assert (this.getGraph() == e.getGraph());
        assert (this.getThis() == e.getThis());
        if (e == this) {
            return false;
        }
        for (i = (IncidenceImpl)this.getNextIncidenceInISeq(); i != null && i != e; i = (IncidenceImpl)i.getNextIncidenceInISeq()) {
        }
        return i != null;
    }

    @Override
    public boolean isAfterIncidence(Edge e) {
        IncidenceImpl i;
        assert (e != null);
        assert (this.isValid());
        assert (e.isValid());
        assert (this.getGraph() == e.getGraph());
        assert (this.getThis() == e.getThis());
        if (e == this) {
            return false;
        }
        for (i = (IncidenceImpl)this.getPrevIncidenceInISeq(); i != null && i != e; i = (IncidenceImpl)i.getPrevIncidenceInISeq()) {
        }
        return i != null;
    }

    @Override
    public void putIncidenceBefore(Edge e) {
        assert (e != null);
        assert (this.isValid());
        assert (e.isValid());
        assert (this.getGraph() == e.getGraph());
        assert (this.getThis() == e.getThis());
        VertexBaseImpl v = (VertexBaseImpl)this.getThis();
        assert (v.isValid());
        assert (e != this);
        if (this != e) {
            v.putIncidenceBefore((IncidenceImpl)e, this);
        }
    }

    @Override
    public void putIncidenceAfter(Edge e) {
        assert (e != null);
        assert (this.isValid());
        assert (e.isValid());
        assert (this.getGraph() == e.getGraph());
        assert (this.getThis() == e.getThis()) : "this-vertices don't match: " + this.getThis() + " != " + e.getThis();
        VertexBaseImpl v = (VertexBaseImpl)this.getThis();
        assert (v.isValid());
        assert (e != this);
        if (this != e) {
            v.putIncidenceAfter((IncidenceImpl)e, this);
        }
    }
}

