/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl.templategraphparser;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.gretl.template.CreateEdge;
import de.uni_koblenz.jgralab.gretl.template.CreateVertex;
import de.uni_koblenz.jgralab.gretl.template.TemplateGraph;
import de.uni_koblenz.jgralab.gretl.template.TemplateSchema;
import de.uni_koblenz.jgralab.gretl.templategraphparser.ComplexToken;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TemplateGraphLexer;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TemplateGraphParserException;
import de.uni_koblenz.jgralab.gretl.templategraphparser.Token;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TokenType;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pcollections.PMap;

public class TemplateGraphParser {
    private List<Token> tokens;
    private TemplateGraph graph;
    private Map<String, CreateVertex> ident2VertexMap = new HashMap<String, CreateVertex>();

    public TemplateGraphParser(List<Token> toks) {
        this.tokens = toks;
    }

    private TemplateGraph parse() {
        this.graph = TemplateSchema.instance().createTemplateGraph(ImplementationType.STANDARD);
        while (!this.tokens.isEmpty()) {
            this.matchVertexOrSubgraph();
        }
        return this.graph;
    }

    private void matchVertexOrSubgraph() {
        CreateVertex v = this.matchVertex();
        while (!this.tryMatch(TokenType.COMMA) && !this.tokens.isEmpty()) {
            v = this.matchEdgeAndNextVertex(v);
        }
        if (this.tryMatch(TokenType.COMMA)) {
            this.match(TokenType.COMMA);
        }
    }

    private CreateVertex matchEdgeAndNextVertex(CreateVertex srcOrDst) {
        TokenType arrow = null;
        String ecName = null;
        boolean typeIsQuery = false;
        String arch = null;
        PMap<String, String> attrs = null;
        boolean copyAttributes = false;
        arrow = this.tryMatch(TokenType.L_ARROW) ? this.match((TokenType)TokenType.L_ARROW).type : this.match((TokenType)TokenType.R_ARROW).type;
        this.match(TokenType.L_CURLY);
        if (this.tryMatch(TokenType.IDENT)) {
            ecName = this.matchComplexToken((TokenType)TokenType.IDENT).value;
        } else if (this.tryMatch(TokenType.HASH)) {
            this.match(TokenType.HASH);
            typeIsQuery = true;
            ecName = this.matchComplexToken((TokenType)TokenType.STRING).value;
        }
        if (this.tryMatch(TokenType.STRING)) {
            arch = this.matchComplexToken((TokenType)TokenType.STRING).value;
        }
        if (this.tryMatch(TokenType.PIPE)) {
            this.match(TokenType.PIPE);
            attrs = this.matchAttributes();
            if (this.tryMatch(TokenType.TRIPLE_DOT)) {
                this.match(TokenType.TRIPLE_DOT);
                copyAttributes = true;
            }
        }
        this.match(TokenType.R_CURLY);
        CreateVertex srcOrDst2 = this.matchVertex();
        CreateEdge ce = null;
        ce = arrow == TokenType.R_ARROW ? this.graph.createCreateEdge(srcOrDst, srcOrDst2) : this.graph.createCreateEdge(srcOrDst2, srcOrDst);
        ce.set_typeName(ecName);
        ce.set_typeNameIsQuery(typeIsQuery);
        ce.set_archetype(arch);
        ce.set_attributes(attrs);
        ce.set_copyAttributeValues(copyAttributes);
        return srcOrDst2;
    }

    private CreateVertex matchVertex() {
        CreateVertex vertex = null;
        String vertexIdent = null;
        if (this.tryMatch(TokenType.IDENT)) {
            vertexIdent = this.matchComplexToken((TokenType)TokenType.IDENT).value;
            vertex = this.ident2VertexMap.get(vertexIdent);
        }
        if (vertex == null) {
            this.match(TokenType.L_PAREN);
            vertex = this.graph.createCreateVertex();
            if (this.tryMatch(TokenType.IDENT)) {
                String vcName = this.matchComplexToken((TokenType)TokenType.IDENT).value;
                vertex.set_typeNameIsQuery(false);
                vertex.set_typeName(vcName);
            } else if (this.tryMatch(TokenType.HASH)) {
                this.match(TokenType.HASH);
                String vcNameQuery = this.matchComplexToken((TokenType)TokenType.STRING).value;
                vertex.set_typeNameIsQuery(true);
                vertex.set_typeName(vcNameQuery);
            }
            if (this.tryMatch(TokenType.STRING)) {
                vertex.set_archetype(this.matchComplexToken((TokenType)TokenType.STRING).value);
            }
            if (this.tryMatch(TokenType.PIPE)) {
                this.match(TokenType.PIPE);
                vertex.set_attributes(this.matchAttributes());
                if (this.tryMatch(TokenType.TRIPLE_DOT)) {
                    this.match(TokenType.TRIPLE_DOT);
                    vertex.set_copyAttributeValues(true);
                }
            }
            this.match(TokenType.R_PAREN);
            if (vertexIdent != null) {
                this.ident2VertexMap.put(vertexIdent, vertex);
            }
        }
        return vertex;
    }

    private PMap<String, String> matchAttributes() {
        PMap<String, String> attrs = JGraLab.map();
        do {
            if (this.tryMatch(TokenType.TRIPLE_DOT)) {
                return attrs;
            }
            String attrName = this.matchComplexToken((TokenType)TokenType.IDENT).value;
            this.match(TokenType.ASSIGN);
            String val = this.matchComplexToken((TokenType)TokenType.STRING).value;
            attrs = attrs.plus(attrName, val);
        } while (this.tryMatch(TokenType.COMMA) && this.match(TokenType.COMMA) != null);
        return attrs;
    }

    private boolean tryMatch(TokenType tt) {
        return !this.tokens.isEmpty() && this.tokens.get((int)0).type == tt;
    }

    private ComplexToken matchComplexToken(TokenType tt) {
        return (ComplexToken)this.match(tt);
    }

    private Token match(TokenType tt) {
        if (this.tokens.isEmpty()) {
            throw new TemplateGraphParserException("Expected " + (Object)((Object)tt) + " but no Tokens were left over.");
        }
        Token t = this.tokens.get(0);
        if (t.type == tt) {
            return this.tokens.remove(0);
        }
        throw new TemplateGraphParserException("Expected " + (Object)((Object)tt) + " but got " + t + ".");
    }

    public static TemplateGraph parse(String txt) {
        TemplateGraphParser p = new TemplateGraphParser(TemplateGraphLexer.scan(txt));
        return p.parse();
    }

    public static void main(String[] args) throws GraphIOException, IOException {
        String[] txts = new String[]{"v1(a.A 'tup($[1], \"aArch\")' | a1 = '\"A\"', a2='$[2] + 1') -->{a.E 'tup($[1], $[2])' | e1 = '$[17]'} v1", "v1(a.A 'tup($[1], \"aArch\")' | a1 = '\"A\"', a2='$[2] + 1') -->{a.E 'tup($[1], $[2])' | e1 = '$[17]'} v1<--{a.E2 '$[3]'} v3(a.B '$[4]'), v4('$[6]') <--{a.F '1'| e3='17'} v1", "('$' | name = '$.name')"};
        for (int i = 0; i < txts.length; ++i) {
            System.out.println("Trying txts[" + i + "]...");
            TemplateGraph idg = TemplateGraphParser.parse(txts[i]);
            Tg2Dot.convertGraph((Graph)idg, "/tmp/g" + i + ".dot", false);
        }
        System.out.println("Fini.");
    }
}

