/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CreateEdges;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import org.pcollections.PSet;

public class CreateEdgeClass
extends Transformation<EdgeClass> {
    protected String qualifiedName;
    private IncidenceClassSpec from;
    private IncidenceClassSpec to;
    private PSet<Tuple> archetypes;
    private String semanticExpression;

    protected CreateEdgeClass(Context c, String qualifiedName, IncidenceClassSpec from, IncidenceClassSpec to) {
        super(c);
        this.qualifiedName = qualifiedName;
        this.from = from;
        this.to = to;
    }

    public CreateEdgeClass(Context c, String qualifiedName, IncidenceClassSpec from, IncidenceClassSpec to, PSet<Tuple> archetypes) {
        this(c, qualifiedName, from, to);
        this.archetypes = archetypes;
    }

    public CreateEdgeClass(Context c, String qualifiedName, IncidenceClassSpec from, IncidenceClassSpec to, String semanticExpression) {
        this(c, qualifiedName, from, to);
        this.semanticExpression = semanticExpression;
    }

    public static CreateEdgeClass parseAndCreate(ExecuteTransformation et) {
        String qname = et.matchQualifiedName();
        IncidenceClassSpec from = et.matchIncidenceClassSpec();
        IncidenceClassSpec to = et.matchIncidenceClassSpec();
        et.matchTransformationArrow();
        String semanticExpression = et.matchSemanticExpression();
        return new CreateEdgeClass(et.context, qname, from, to, semanticExpression);
    }

    @Override
    protected EdgeClass transform() {
        switch (this.context.phase) {
            case SCHEMA: {
                if (this.from.aggregationKind != AggregationKind.NONE && this.to.aggregationKind != AggregationKind.NONE) {
                    throw new GReTLException(this.context, "Only one IncidenceClass of " + this.qualifiedName + " map be SHARED or COMPOSITE.");
                }
                this.setDefaultMultiplicities(this.from, this.to);
                this.setDefaultMultiplicities(this.to, this.from);
                EdgeClass element = this.context.targetSchema.getGraphClass().createEdgeClass(this.qualifiedName, this.from.connectedVertexClass, this.from.minMultiplicity, this.from.maxMultiplicity, this.from.roleName, this.from.aggregationKind, this.to.connectedVertexClass, this.to.minMultiplicity, this.to.maxMultiplicity, this.to.roleName, this.to.aggregationKind);
                this.context.ensureMappings(element);
                return element;
            }
            case GRAPH: {
                EdgeClass edgeClass = this.context.targetGraph.getGraphClass().getEdgeClass(this.qualifiedName);
                if (this.archetypes != null) {
                    new CreateEdges(this.context, edgeClass, this.archetypes).execute();
                } else {
                    new CreateEdges(this.context, edgeClass, this.semanticExpression).execute();
                }
                return edgeClass;
            }
        }
        throw new GReTLException(this.context, "Unknown TransformationPhase " + (Object)((Object)this.context.phase) + "!");
    }

    private void setDefaultMultiplicities(IncidenceClassSpec specToBeSet, IncidenceClassSpec oppositeSpec) {
        if (specToBeSet.defaultMultis) {
            if (oppositeSpec.aggregationKind == AggregationKind.COMPOSITE) {
                specToBeSet.minMultiplicity = 1;
                specToBeSet.maxMultiplicity = 1;
            } else {
                specToBeSet.minMultiplicity = 0;
                specToBeSet.maxMultiplicity = Integer.MAX_VALUE;
            }
        }
        specToBeSet.defaultMultis = false;
    }

    public static final class IncidenceClassSpec {
        private boolean defaultMultis = false;
        protected VertexClass connectedVertexClass = null;
        protected int minMultiplicity = 0;
        protected int maxMultiplicity = Integer.MAX_VALUE;
        protected String roleName = null;
        protected AggregationKind aggregationKind = AggregationKind.NONE;

        public IncidenceClassSpec(VertexClass connectedVC, int min, int max, String roleName, AggregationKind aggrKind) {
            this.connectedVertexClass = connectedVC;
            this.minMultiplicity = min;
            this.maxMultiplicity = max;
            this.aggregationKind = aggrKind;
            this.roleName = roleName;
            if (min == -1 || max == -1) {
                this.defaultMultis = true;
            }
        }

        public IncidenceClassSpec(VertexClass connectedVC, int min, int max, String roleName) {
            this(connectedVC, min, max, roleName, AggregationKind.NONE);
        }

        public IncidenceClassSpec(VertexClass connectedVC, int min, int max) {
            this(connectedVC, min, max, "", AggregationKind.NONE);
        }

        public IncidenceClassSpec(VertexClass connectedVC, AggregationKind aggrKind, String roleName) {
            this(connectedVC, -1, -1, roleName, aggrKind);
        }

        public IncidenceClassSpec(VertexClass connectedVC, AggregationKind aggrKind) {
            this(connectedVC, aggrKind, "");
        }

        public IncidenceClassSpec(VertexClass connectedVC, String roleName) {
            this(connectedVC, -1, -1, roleName);
        }

        public IncidenceClassSpec(VertexClass connectedVC) {
            this(connectedVC, "");
        }

        public IncidenceClassSpec(VertexClass connectedVC, int min, int max, AggregationKind aggrKind) {
            this(connectedVC, min, max, "", aggrKind);
        }

        public IncidenceClassSpec(VertexClass connectedVC, IncidenceClass incClass) {
            this(connectedVC, incClass.getMin(), incClass.getMax(), incClass.getRolename(), incClass.getAggregationKind());
        }
    }
}

