/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CreateAttribute;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.SetMultipleAttributes;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.Attribute;
import org.pcollections.PMap;
import org.pcollections.PSequence;

public class CreateAttributes
extends Transformation<Attribute[]> {
    private CreateAttribute.AttributeSpec[] attrSpecs;
    private String semanticExpression;
    private PMap<Object, PSequence<Object>> archetype2ValueListMap;

    protected CreateAttributes(Context c, CreateAttribute.AttributeSpec ... attrSpecs) {
        super(c);
        this.attrSpecs = attrSpecs;
    }

    public CreateAttributes(Context c, PMap<Object, PSequence<Object>> archetype2ValListMap, CreateAttribute.AttributeSpec ... attrSpecs) {
        this(c, attrSpecs);
        this.archetype2ValueListMap = archetype2ValListMap;
    }

    public CreateAttributes(Context c, String semanticExpression, CreateAttribute.AttributeSpec ... attrSpecs) {
        this(c, attrSpecs);
        this.semanticExpression = semanticExpression;
    }

    public static CreateAttributes parseAndCreate(ExecuteTransformation et) {
        CreateAttribute.AttributeSpec[] attrSpec = et.matchAttributeSpecArray();
        et.matchTransformationArrow();
        String semanticExpression = et.matchSemanticExpression();
        return new CreateAttributes(et.context, semanticExpression, attrSpec);
    }

    @Override
    protected Attribute[] transform() {
        switch (this.context.phase) {
            case SCHEMA: {
                int i = 0;
                Attribute[] retVal = new Attribute[this.attrSpecs.length];
                for (CreateAttribute.AttributeSpec as : this.attrSpecs) {
                    retVal[i++] = (Attribute)new CreateAttribute(this.context, as, (String)null).execute();
                }
                return retVal;
            }
            case GRAPH: {
                Attribute[] retVal = new Attribute[this.attrSpecs.length];
                int i = 0;
                for (CreateAttribute.AttributeSpec as : this.attrSpecs) {
                    retVal[i++] = as.aec.getAttribute(as.name);
                }
                if (this.archetype2ValueListMap != null) {
                    new SetMultipleAttributes(this.context, this.archetype2ValueListMap, retVal).execute();
                } else {
                    new SetMultipleAttributes(this.context, this.semanticExpression, retVal).execute();
                }
                return retVal;
            }
        }
        throw new GReTLException(this.context, "Unknown TransformationPhase " + (Object)((Object)this.context.phase) + "!");
    }
}

