/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.serialising;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.exception.SerialisingException;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.greql.types.Undefined;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import java.util.Iterator;
import java.util.Map;
import org.pcollections.PMap;
import org.pcollections.PSet;
import org.pcollections.PVector;

public abstract class DefaultWriter {
    private Graph graph;
    protected Object rootValue;

    public DefaultWriter(Graph g) {
        this.graph = g;
    }

    protected void writeValue(Object value) throws Exception {
        this.rootValue = value;
        this.head();
        this.write(value);
        this.foot();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    protected void writePSet(PSet<?> s) throws Exception {
        Iterator iter = s.iterator();
        boolean first = true;
        this.pre();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                this.inter();
            }
            this.write(iter.next());
        }
        this.post();
    }

    protected void writePVector(PVector<?> b) throws Exception {
        Iterator iter = b.iterator();
        boolean first = true;
        this.pre();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                this.inter();
            }
            this.write(iter.next());
        }
        this.post();
    }

    protected void writePMap(PMap<?, ?> b) throws Exception {
        boolean first = true;
        this.pre();
        for (Map.Entry e : b.entrySet()) {
            if (first) {
                first = false;
            } else {
                this.inter();
            }
            Tuple t = Tuple.empty();
            t = t.plus(e.getKey());
            t = t.plus(e.getValue());
            this.writeTuple(t);
        }
        this.post();
    }

    protected void writeTable(Table<?> t) throws Exception {
        this.writePVector(t.getTitles());
        this.writePVector(t.toPVector());
    }

    protected void writeTuple(Tuple t) throws Exception {
        Iterator<Object> iter = t.iterator();
        boolean first = true;
        this.pre();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                this.inter();
            }
            this.write(iter.next());
        }
        this.post();
    }

    protected void writeRecord(Record r) throws Exception {
        boolean first = true;
        this.pre();
        for (String compName : r.getComponentNames()) {
            if (first) {
                first = false;
            } else {
                this.inter();
            }
            this.write(compName);
            this.write(r.getComponent(compName));
        }
        this.post();
    }

    protected void writePath(Path p) throws Exception {
        this.cantWrite(p);
    }

    protected void writePathSystem(PathSystem p) throws Exception {
        this.cantWrite(p);
    }

    protected void writeVertex(Vertex v) throws Exception {
        this.cantWrite(v);
    }

    protected void writeUndefined() throws Exception {
        this.cantWrite((Object)Undefined.UNDEFINED);
    }

    protected void writeEdge(Edge e) throws Exception {
        this.cantWrite(e);
    }

    protected void writeInteger(Integer n) throws Exception {
        this.cantWrite(n);
    }

    protected void writeLong(Long n) throws Exception {
        this.cantWrite(n);
    }

    protected void writeDouble(Double n) throws Exception {
        this.cantWrite(n);
    }

    protected void writeString(String s) throws Exception {
        this.cantWrite(s);
    }

    protected void writeEnum(Enum<?> e) throws Exception {
        this.cantWrite(e);
    }

    protected void writeGraph(Graph g) throws Exception {
        this.cantWrite(g);
    }

    protected void writeSubGraphMarker(SubGraphMarker s) throws Exception {
        this.cantWrite(s);
    }

    protected void writeDFA(DFA d) throws Exception {
        this.cantWrite(d);
    }

    protected void writeNFA(NFA n) throws Exception {
        this.cantWrite(n);
    }

    protected void writeBoolean(Boolean b) throws Exception {
        this.cantWrite(b);
    }

    protected void writeAttributedElementClass(AttributedElementClass<?, ?> a) throws Exception {
        this.cantWrite(a);
    }

    protected void writeTypeCollection(TypeCollection a) throws Exception {
        this.cantWrite(a);
    }

    protected void writeState(State s) throws Exception {
        this.cantWrite(s);
    }

    protected void writeTransition(Transition t) throws Exception {
        this.cantWrite(t);
    }

    protected void writeDeclaration(Declaration d) throws Exception {
        this.cantWrite(d);
    }

    protected void writeDefaultObject(Object o) throws Exception {
        this.cantWrite(o);
    }

    protected void write(Object o) throws Exception {
        if (o instanceof PSet) {
            this.writePSet((PSet)o);
        } else if (o instanceof Table) {
            this.writeTable((Table)o);
        } else if (o instanceof PVector) {
            this.writePVector((PVector)o);
        } else if (o instanceof PMap) {
            this.writePMap((PMap)o);
        } else if (o instanceof Tuple) {
            this.writeTuple((Tuple)o);
        } else if (o instanceof Record) {
            this.writeRecord((Record)o);
        } else if (o instanceof Path) {
            this.writePath((Path)o);
        } else if (o instanceof PathSystem) {
            this.writePathSystem((PathSystem)o);
        } else if (o instanceof Vertex) {
            this.writeVertex((Vertex)o);
        } else if (o instanceof Edge) {
            this.writeEdge((Edge)o);
        } else if (o instanceof Integer) {
            this.writeInteger((Integer)o);
        } else if (o instanceof Long) {
            this.writeLong((Long)o);
        } else if (o instanceof Double) {
            this.writeDouble((Double)o);
        } else if (o instanceof String) {
            this.writeString((String)o);
        } else if (o instanceof Enum) {
            this.writeEnum((Enum)o);
        } else if (o instanceof Graph) {
            this.writeGraph((Graph)o);
        } else if (o instanceof SubGraphMarker) {
            this.writeSubGraphMarker((SubGraphMarker)o);
        } else if (o instanceof DFA) {
            this.writeDFA((DFA)o);
        } else if (o instanceof NFA) {
            this.writeNFA((NFA)o);
        } else if (o instanceof TypeCollection) {
            this.writeTypeCollection((TypeCollection)o);
        } else if (o instanceof Boolean) {
            this.writeBoolean((Boolean)o);
        } else if (o instanceof AttributedElementClass) {
            this.writeAttributedElementClass((AttributedElementClass)o);
        } else if (o instanceof Transition) {
            this.writeTransition((Transition)o);
        } else if (o instanceof Declaration) {
            this.writeDeclaration((Declaration)o);
        } else if (o instanceof State) {
            this.writeState((State)o);
        } else if (o instanceof Undefined) {
            this.writeUndefined();
        } else {
            this.writeDefaultObject(o);
        }
    }

    protected void post() throws Exception {
    }

    protected void pre() throws Exception {
    }

    protected void inter() throws Exception {
    }

    protected void head() throws Exception {
    }

    protected void foot() throws Exception {
    }

    protected void cantWrite(Object v) {
        throw new SerialisingException(this.getClass().getSimpleName() + " can not handle " + v.getClass(), v);
    }
}

