/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.parser;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.exception.DuplicateVariableException;
import de.uni_koblenz.jgralab.greql.schema.GreqlAggregation;
import de.uni_koblenz.jgralab.greql.schema.SourcePosition;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SimpleSymbolTable {
    protected LinkedList<HashMap<String, Vertex>> list = new LinkedList();

    public void blockBegin() {
        HashMap map = new HashMap();
        this.list.addFirst(map);
    }

    public void blockEnd() {
        if (!this.list.isEmpty()) {
            this.list.removeFirst();
        }
    }

    public void insert(String ident, Vertex v) throws DuplicateVariableException {
        Vertex existingVariable = this.list.getFirst().get(ident);
        if (existingVariable != null) {
            GreqlAggregation firstIncidence = (GreqlAggregation)existingVariable.getFirstIncidence(EdgeDirection.OUT);
            SourcePosition previousPosition = null;
            if (firstIncidence != null) {
                previousPosition = (SourcePosition)firstIncidence.get_sourcePositions().get(0);
            } else {
                List<RecordDomain> recordDomains = v.getSchema().getRecordDomains();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("length", -1);
                map.put("offset", -1);
                for (RecordDomain dom : recordDomains) {
                    if (!dom.getQualifiedName().equals("SourcePosition")) continue;
                    previousPosition = (SourcePosition)v.getGraph().createRecord(dom, map);
                }
            }
            throw new DuplicateVariableException(((Variable)existingVariable).get_name(), (List<SourcePosition>)null, previousPosition);
        }
        this.list.getFirst().put(ident, v);
    }

    public Vertex lookup(String ident) {
        for (HashMap hashMap : this.list) {
            if (!hashMap.containsKey(ident)) continue;
            return (Vertex)hashMap.get(ident);
        }
        return null;
    }

    public Set<String> getKnownIdentifierSet() {
        HashSet<String> result = new HashSet<String>();
        for (HashMap hashMap : this.list) {
            result.addAll(hashMap.keySet());
        }
        return result;
    }
}

