/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.BinaryOperator;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.False;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Literal;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.True;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;

public class Or
extends BinaryOperator {
    public Or(GreqlQuery query, Formula lhs, Formula rhs) {
        super(query, lhs, rhs);
    }

    @Override
    public String toString() {
        return "(" + this.leftHandSide + " | " + this.rightHandSide + ")";
    }

    @Override
    public Expression toExpression() {
        GreqlGraph syntaxgraph = this.query.getQueryGraph();
        FunctionApplication funApp = syntaxgraph.createFunctionApplication();
        FunctionId funId = OptimizerUtility.findOrCreateFunctionId("or", syntaxgraph);
        syntaxgraph.createIsFunctionIdOf(funId, funApp);
        syntaxgraph.createIsArgumentOf(this.leftHandSide.toExpression(), funApp);
        syntaxgraph.createIsArgumentOf(this.rightHandSide.toExpression(), funApp);
        return funApp;
    }

    @Override
    protected Formula calculateReplacementFormula(Expression exp, Literal literal) {
        return new Or(this.query, this.leftHandSide.calculateReplacementFormula(exp, literal), this.rightHandSide.calculateReplacementFormula(exp, literal));
    }

    @Override
    public Formula simplify() {
        Formula lhs = this.leftHandSide.simplify();
        Formula rhs = this.rightHandSide.simplify();
        if (lhs instanceof True) {
            return lhs;
        }
        if (rhs instanceof True) {
            return rhs;
        }
        if (lhs instanceof False) {
            return rhs;
        }
        if (rhs instanceof False) {
            return lhs;
        }
        if (lhs.equals(rhs)) {
            return lhs;
        }
        return new Or(this.query, lhs, rhs);
    }

    @Override
    public double getSelectivity() {
        double selectivity = 1.0 - (1.0 - this.leftHandSide.getSelectivity()) * (1.0 - this.rightHandSide.getSelectivity());
        logger.finer("selectivity[" + this + "] = " + selectivity);
        return selectivity;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Or) {
            Or or = (Or)o;
            return this.leftHandSide.equals(or.leftHandSide) && this.rightHandSide.equals(or.rightHandSide);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode(19);
    }
}

