/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.And;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.False;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Literal;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Or;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.True;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import java.util.ArrayList;

public class Not
extends Formula {
    protected Formula formula;

    public Not(GreqlQuery query, Formula formula) {
        super(query);
        this.formula = formula;
    }

    @Override
    public String toString() {
        return "~" + this.formula;
    }

    @Override
    public Expression toExpression() {
        GreqlGraph syntaxgraph = this.query.getQueryGraph();
        FunctionApplication funApp = syntaxgraph.createFunctionApplication();
        FunctionId funId = OptimizerUtility.findOrCreateFunctionId("not", syntaxgraph);
        syntaxgraph.createIsFunctionIdOf(funId, funApp);
        syntaxgraph.createIsArgumentOf(this.formula.toExpression(), funApp);
        return funApp;
    }

    @Override
    protected ArrayList<Expression> getNonConstantTermExpressions() {
        return this.formula.getNonConstantTermExpressions();
    }

    @Override
    protected Formula calculateReplacementFormula(Expression exp, Literal literal) {
        return new Not(this.query, this.formula.calculateReplacementFormula(exp, literal));
    }

    @Override
    public Formula simplify() {
        Formula f = this.formula.simplify();
        if (f instanceof True) {
            return new False(this.query);
        }
        if (f instanceof False) {
            return new True(this.query);
        }
        if (f instanceof Not) {
            Not not = (Not)f;
            return not.formula.simplify();
        }
        if (f instanceof And) {
            And and = (And)f;
            Formula left = and.leftHandSide;
            Formula right = and.rightHandSide;
            return new Or(this.query, new Not(this.query, left), new Not(this.query, right)).simplify();
        }
        if (f instanceof Or) {
            Or or = (Or)f;
            Formula left = or.leftHandSide;
            Formula right = or.rightHandSide;
            return new And(this.query, new Not(this.query, left), new Not(this.query, right)).simplify();
        }
        return new Not(this.query, f);
    }

    @Override
    public double getSelectivity() {
        double selectivity = 1.0 - this.formula.getSelectivity();
        logger.finer("selectivity[" + this + "] = " + selectivity);
        return selectivity;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Not) {
            Not not = (Not)o;
            return this.formula.equals(not.formula);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hc = 23;
        int multiplier = 37;
        return hc * multiplier + this.formula.hashCode();
    }
}

