/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.BinaryOperator;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Literal;
import de.uni_koblenz.jgralab.greql.schema.Expression;

public class Equiv
extends BinaryOperator {
    public Equiv(GreqlQuery query, Formula lhs, Formula rhs) {
        super(query, lhs, rhs);
    }

    @Override
    protected Formula calculateReplacementFormula(Expression exp, Literal literal) {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }

    @Override
    public Formula simplify() {
        Formula lhs = this.leftHandSide.simplify();
        Formula rhs = this.rightHandSide.simplify();
        return new Equiv(this.query, lhs, rhs);
    }

    @Override
    public Expression toExpression() {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }

    @Override
    public String toString() {
        return "(" + this.leftHandSide + " <=> " + this.rightHandSide + ")";
    }

    @Override
    public double getSelectivity() {
        double leftSel = this.leftHandSide.getSelectivity();
        double rightSel = this.rightHandSide.getSelectivity();
        double selectivity = 1.0 - (1.0 - leftSel * rightSel) * (1.0 - (1.0 - leftSel) * (1.0 - rightSel));
        logger.finer("selectivity[" + this + "] = " + selectivity);
        return selectivity;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Equiv) {
            Equiv equiv = (Equiv)o;
            return this.leftHandSide.equals(equiv.leftHandSide) && this.rightHandSide.equals(equiv.rightHandSide);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode(21);
    }
}

