/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.optimizer.VariableDeclarationOrderUnit;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class VariableDeclarationOrderOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(VariableDeclarationOrderOptimizer.class);

    public VariableDeclarationOrderOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof VariableDeclarationOrderOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery query) throws OptimizerException {
        GreqlGraph syntaxgraph = query.getQueryGraph();
        ArrayList unitsList = new ArrayList();
        for (Declaration decl : syntaxgraph.getDeclarationVertices()) {
            ArrayList<VariableDeclarationOrderUnit> units = new ArrayList<VariableDeclarationOrderUnit>();
            Set<Variable> set = this.collectVariablesDeclaredBy(decl);
            if (set.size() < 2) continue;
            for (Variable var : set) {
                units.add(new VariableDeclarationOrderUnit(var, decl, query));
            }
            unitsList.add(units);
        }
        boolean varDeclOrderChanged = false;
        HashSet<SimpleDeclaration> oldSDs = new HashSet<SimpleDeclaration>();
        for (List list : unitsList) {
            Collections.sort(list);
            Declaration declaringDecl = ((VariableDeclarationOrderUnit)list.get(0)).getDeclaringDeclaration();
            List<Variable> varDeclOrderBefore = this.collectVariablesInDeclarationOrder(declaringDecl);
            List<Variable> varDeclOrderAfter = this.collectVariablesInProposedDeclarationOrder(list);
            if (varDeclOrderAfter.equals(varDeclOrderBefore)) continue;
            varDeclOrderChanged = true;
            logger.finer(this.optimizerHeaderString() + "New order of declarations in " + declaringDecl);
            int i = 0;
            for (VariableDeclarationOrderUnit unit : list) {
                oldSDs.add(unit.getSimpleDeclarationOfVariable());
                Variable var = unit.getVariable();
                Variable old = varDeclOrderBefore.get(i);
                logger.finer("  " + old + " (" + old.get_name() + ") --> " + var + " (" + var.get_name() + "), changeCosts = " + unit.getVariableValueChangeCosts() + ", cardinality = " + unit.getTypeExpressionCardinality());
                ++i;
                SimpleDeclaration newSD = syntaxgraph.createSimpleDeclaration();
                syntaxgraph.createIsDeclaredVarOf(var, newSD);
                syntaxgraph.createIsTypeExprOfDeclaration(unit.getTypeExpressionOfVariable(), newSD);
                syntaxgraph.createIsSimpleDeclOf(newSD, unit.getDeclaringDeclaration());
            }
        }
        for (SimpleDeclaration simpleDeclaration : oldSDs) {
            simpleDeclaration.delete();
        }
        OptimizerUtility.createMissingSourcePositions(syntaxgraph);
        return varDeclOrderChanged;
    }

    private List<Variable> collectVariablesInDeclarationOrder(Declaration decl) {
        ArrayList<Variable> varList = new ArrayList<Variable>();
        for (IsSimpleDeclOf isSD : decl.getIsSimpleDeclOfIncidences()) {
            for (IsDeclaredVarOf isVar : isSD.getAlpha().getIsDeclaredVarOfIncidences()) {
                varList.add(isVar.getAlpha());
            }
        }
        return varList;
    }

    private List<Variable> collectVariablesInProposedDeclarationOrder(List<VariableDeclarationOrderUnit> units) {
        ArrayList<Variable> varList = new ArrayList<Variable>();
        for (VariableDeclarationOrderUnit unit : units) {
            varList.add(unit.getVariable());
        }
        return varList;
    }

    private Set<Variable> collectVariablesDeclaredBy(Declaration decl) {
        HashSet<Variable> vars = new HashSet<Variable>();
        for (IsSimpleDeclOf inc : decl.getIsSimpleDeclOfIncidences(EdgeDirection.IN)) {
            vars.addAll(OptimizerUtility.collectVariablesDeclaredBy(inc.getAlpha()));
        }
        return vars;
    }
}

