/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.schema.BoolLiteral;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.IsConstraintOf;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Logger;

public class ConditionalExpressionOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(ConditionalExpressionOptimizer.class);

    public ConditionalExpressionOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof ConditionalExpressionOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery query) throws OptimizerException {
        boolean simplifiedOrOptimized = false;
        FunctionApplication top = this.findAndOrNotFunApp(query.getQueryGraph().getFirstGreqlExpression());
        while (top != null) {
            Formula formula;
            LinkedList<VertexEdgeClassTuple> relinkables = this.rememberConnections(top);
            Formula formula2 = Formula.createFormulaFromExpression(top, query);
            if (!formula2.equals(formula = formula2.simplify().optimize())) {
                simplifiedOrOptimized = true;
                logger.fine(this.optimizerHeaderString() + "Transformed constraint\n    " + formula2 + "\nto\n    " + formula + ".");
                Expression newTop = formula.toExpression();
                for (VertexEdgeClassTuple vect : relinkables) {
                    query.getQueryGraph().createEdge(vect.ec, newTop, vect.v);
                }
                top.delete();
                top = this.findAndOrNotFunApp(query.getQueryGraph().getFirstGreqlExpression());
                continue;
            }
            top = null;
        }
        HashSet<BoolLiteral> verticesToDelete = new HashSet<BoolLiteral>();
        for (IsConstraintOf isConstraintOf : query.getQueryGraph().getIsConstraintOfEdges()) {
            BoolLiteral bl;
            Expression alpha = isConstraintOf.getAlpha();
            if (!(alpha instanceof BoolLiteral) || !(bl = (BoolLiteral)alpha).is_boolValue()) continue;
            verticesToDelete.add(bl);
        }
        for (Vertex vertex : verticesToDelete) {
            vertex.delete();
        }
        OptimizerUtility.createMissingSourcePositions(query.getQueryGraph());
        return simplifiedOrOptimized;
    }

    private LinkedList<VertexEdgeClassTuple> rememberConnections(FunctionApplication top) {
        LinkedList<VertexEdgeClassTuple> list = new LinkedList<VertexEdgeClassTuple>();
        assert (top.isValid());
        for (Edge e : top.incidences(EdgeDirection.OUT)) {
            list.add(new VertexEdgeClassTuple((GreqlVertex)e.getOmega(), e.getAttributedElementClass()));
        }
        return list;
    }

    private FunctionApplication findAndOrNotFunApp(GreqlExpression g) {
        LinkedList<GreqlVertex> queue = new LinkedList<GreqlVertex>();
        queue.add(g);
        while (!queue.isEmpty()) {
            FunctionApplication f;
            GreqlVertex v = (GreqlVertex)queue.poll();
            if (v instanceof FunctionApplication && (OptimizerUtility.isAnd(f = (FunctionApplication)v) || OptimizerUtility.isOr(f) || OptimizerUtility.isNot(f))) {
                return f;
            }
            for (Edge e : v.incidences(EdgeDirection.IN)) {
                queue.offer((GreqlVertex)e.getAlpha());
            }
        }
        return null;
    }

    private static class VertexEdgeClassTuple {
        GreqlVertex v;
        EdgeClass ec;

        public VertexEdgeClassTuple(GreqlVertex v, EdgeClass ec) {
            this.v = v;
            this.ec = ec;
        }
    }
}

