/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.statistics;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Max
extends Function {
    @Description(params={"a", "b"}, description="Returns the maximum of the given two numbers.", categories={Function.Category.STATISTICS})
    public Number evaluate(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return Math.max(a.doubleValue(), b.doubleValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return Math.max(a.longValue(), b.longValue());
        }
        return Math.max(a.intValue(), b.intValue());
    }

    @Description(params={"l"}, description="Returns the maximum of a collection of comparable things.", categories={Function.Category.STATISTICS, Function.Category.COLLECTIONS_AND_MAPS})
    public <T extends Comparable<T>> T evaluate(Collection<T> l) {
        if (l.isEmpty()) {
            return null;
        }
        Iterator<T> it = l.iterator();
        Comparable max = (Comparable)it.next();
        while (it.hasNext()) {
            Comparable current = (Comparable)it.next();
            if (current.compareTo(max) <= 0) continue;
            max = current;
        }
        return (T)max;
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> inElements) {
        return inElements.get(0);
    }
}

