/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.schema;

import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.schema.GraphElementClass;

public class HasType
extends Function {
    @Description(params={"el", "qn"}, description="Returns true, iff the given attributed element has an attributed element class with the given qualified name.", categories={Function.Category.SCHEMA_ACCESS})
    public <SC extends GraphElementClass<SC, IC>, IC extends GraphElement<SC, IC>> Boolean evaluate(IC el, String qn) {
        GraphElementClass aec = (GraphElementClass)el.getSchema().getAttributedElementClass(qn);
        if (aec == null) {
            throw new GreqlException("hasType: Schema doesn't contain a type '");
        }
        return this.evaluate(el, aec);
    }

    @Description(params={"el", "aec"}, description="Returns true, iff the given attributed element has the given attributed element class", categories={Function.Category.SCHEMA_ACCESS})
    private <SC extends GraphElementClass<SC, IC>, IC extends GraphElement<SC, IC>> Boolean evaluate(IC el, SC aec) {
        GraphElementClass c = (GraphElementClass)el.getAttributedElementClass();
        return c.equals(aec) || c.isSubClassOf(aec);
    }

    @Description(params={"el", "tc"}, description="Returns true, iff the given attributed element has an attributed element class accepted by the given type collection.", categories={Function.Category.SCHEMA_ACCESS})
    public <SC extends GraphElementClass<SC, IC>, IC extends GraphElement<SC, IC>> Boolean evaluate(IC el, TypeCollection tc) {
        GraphElementClass c = (GraphElementClass)el.getAttributedElementClass();
        return tc.acceptsType(c);
    }
}

