/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsEvaluatorArgument;
import de.uni_koblenz.jgralab.greql.types.pathsearch.PathSystemMarkerEntry;
import de.uni_koblenz.jgralab.greql.types.pathsearch.PathSystemQueueEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pcollections.PSet;

@NeedsEvaluatorArgument
public class Slice
extends Function {
    private Graph graph;
    private List<GraphMarker<Map<Edge, PathSystemMarkerEntry>>> marker;
    private GraphMarker<Set<State>> stateMarker;

    public Slice() {
        super(1000L, 1L, 1.0);
    }

    @Description(params={"internal", "v", "dfa"}, description="Returns a SubGraphMarker, starting at the given root vertex and  being structured according to the given path description.", categories={Function.Category.GRAPH, Function.Category.PATHS_AND_PATHSYSTEMS_AND_SLICES})
    public SubGraphMarker evaluate(InternalGreqlEvaluator evaluator, Vertex v, DFA dfa) {
        return this.evaluate(evaluator, JGraLab.set().plus(v), dfa);
    }

    @Description(params={"internal", "roots", "dfa"}, description="Returns a SubGraphMarker, starting at the given root vertices and  being structured according to the given path description.", categories={Function.Category.GRAPH, Function.Category.PATHS_AND_PATHSYSTEMS_AND_SLICES})
    public SubGraphMarker evaluate(InternalGreqlEvaluator evaluator, PSet<Vertex> roots, DFA dfa) {
        HashSet<Vertex> sliCritVertices = new HashSet<Vertex>();
        this.graph = null;
        for (Vertex v : roots) {
            if (this.graph == null) {
                this.graph = v.getGraph();
            }
            assert (v.getGraph() == this.graph) : "Roots from different graphs?!?";
            sliCritVertices.add(v);
        }
        assert (evaluator.getGraph() == this.graph) : "Roots from different graph than we're querying!?!";
        this.marker = new ArrayList<GraphMarker<Map<Edge, PathSystemMarkerEntry>>>(dfa.stateList.size());
        for (int i = 0; i < dfa.stateList.size(); ++i) {
            this.marker.add(new GraphMarker(this.graph));
        }
        List<Vertex> leaves = this.markVerticesOfSlice(evaluator, sliCritVertices, dfa);
        return this.createSliceFromMarkings(this.graph, sliCritVertices, leaves);
    }

    protected boolean markVertex(Vertex v, State s, Vertex parentVertex, Edge e, State ps, int d) {
        PathSystemMarkerEntry entry;
        PathSystemMarkerEntry m = new PathSystemMarkerEntry(v, parentVertex, e, s, ps, d);
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> currentMarker = this.marker.get(s.number);
        HashMap<Edge, PathSystemMarkerEntry> map = (HashMap<Edge, PathSystemMarkerEntry>)currentMarker.getMark(v);
        if (map == null) {
            map = new HashMap<Edge, PathSystemMarkerEntry>();
            currentMarker.mark(v, map);
        }
        if ((entry = (PathSystemMarkerEntry)map.get(e)) == null) {
            map.put(e, m);
            return true;
        }
        return false;
    }

    protected boolean isMarked(Vertex v, State s, Edge parentEdge) {
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> currentMarker = this.marker.get(s.number);
        Map map = (Map)currentMarker.getMark(v);
        if (map != null) {
            return map.containsKey(parentEdge);
        }
        return false;
    }

    protected boolean isMarked(Vertex v, State s) {
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> currentMarker = this.marker.get(s.number);
        Map map = (Map)currentMarker.getMark(v);
        return map != null;
    }

    private List<Vertex> markVerticesOfSlice(InternalGreqlEvaluator evaluator, Set<Vertex> sliCritVertices, DFA dfa) {
        PathSystemQueueEntry currentEntry;
        ArrayList<Vertex> finalVertices = new ArrayList<Vertex>();
        LinkedList<PathSystemQueueEntry> queue = new LinkedList<PathSystemQueueEntry>();
        for (Vertex v : sliCritVertices) {
            currentEntry = new PathSystemQueueEntry(v, dfa.initialState, null, null, 0);
            queue.offer(currentEntry);
            this.markVertex(v, dfa.initialState, null, null, null, 0);
        }
        while (!queue.isEmpty()) {
            currentEntry = (PathSystemQueueEntry)queue.poll();
            if (currentEntry.state.isFinal) {
                finalVertices.add(currentEntry.vertex);
            }
            for (Edge inc : currentEntry.vertex.incidences()) {
                for (Transition currentTransition : currentEntry.state.outTransitions) {
                    Edge traversedEdge;
                    Vertex nextVertex = currentTransition.getNextVertex(currentEntry.vertex, inc);
                    if (this.isMarked(nextVertex, currentTransition.endState, inc) || !currentTransition.accepts(currentEntry.vertex, inc, evaluator)) continue;
                    Edge edge = traversedEdge = currentTransition.consumesEdge() ? inc : null;
                    if (!this.isMarked(nextVertex, currentTransition.endState)) {
                        queue.add(new PathSystemQueueEntry(nextVertex, currentTransition.endState, traversedEdge, currentEntry.state, 0));
                    }
                    this.markVertex(nextVertex, currentTransition.endState, currentEntry.vertex, traversedEdge, currentEntry.state, 0);
                }
            }
        }
        return finalVertices;
    }

    private SubGraphMarker createSliceFromMarkings(Graph graph, Set<Vertex> sliCritVertices, List<Vertex> leaves) {
        SubGraphMarker sliceSubGraph = new SubGraphMarker(graph);
        for (Vertex v : sliCritVertices) {
            sliceSubGraph.mark(v);
        }
        LinkedList<Vertex> queue = new LinkedList<Vertex>();
        this.stateMarker = new GraphMarker(graph);
        GraphMarker<State> currentStateMarker = new GraphMarker<State>(graph);
        for (Vertex leaf : leaves) {
            for (GraphMarker<Map<Edge, PathSystemMarkerEntry>> currentGraphMarker : this.marker) {
                if (currentGraphMarker.getMark(leaf) == null) continue;
                for (PathSystemMarkerEntry currentMarker : ((Map)currentGraphMarker.getMark(leaf)).values()) {
                    if (!currentMarker.state.isFinal || this.isVertexMarkedWithState(leaf, currentMarker.state)) continue;
                    this.markVertexWithState(leaf, currentMarker.state);
                    currentStateMarker.mark(leaf, currentMarker.state);
                    queue.add(leaf);
                    while (!queue.isEmpty()) {
                        Vertex currentVertex = (Vertex)queue.poll();
                        for (PathSystemMarkerEntry marker : this.getMarkersWithState(currentVertex, (State)currentStateMarker.getMark(currentVertex)).values()) {
                            Vertex parentVertex;
                            State parentState = marker.parentState;
                            sliceSubGraph.mark(currentVertex);
                            if (marker.edgeToParentVertex != null) {
                                sliceSubGraph.mark(marker.edgeToParentVertex);
                            }
                            if ((parentVertex = marker.parentVertex) == null || this.isVertexMarkedWithState(parentVertex, parentState)) continue;
                            this.markVertexWithState(parentVertex, parentState);
                            currentStateMarker.mark(parentVertex, parentState);
                            queue.add(parentVertex);
                        }
                    }
                }
            }
        }
        return sliceSubGraph;
    }

    private void markVertexWithState(Vertex v, State s) {
        if (this.stateMarker.getMark(v) == null) {
            this.stateMarker.mark(v, new HashSet());
        }
        ((Set)this.stateMarker.getMark(v)).add(s);
    }

    private boolean isVertexMarkedWithState(Vertex v, State s) {
        if (this.stateMarker.getMark(v) == null) {
            return false;
        }
        return ((Set)this.stateMarker.getMark(v)).contains(s);
    }

    private Map<Edge, PathSystemMarkerEntry> getMarkersWithState(Vertex v, State s) {
        if (v == null) {
            return null;
        }
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> currentMarker = this.marker.get(s.number);
        return (Map)currentMarker.getMark(v);
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> inElements) {
        return 1000L;
    }

    @Override
    public double getSelectivity() {
        return 0.001f;
    }

    @Override
    public long getEstimatedCardinality(int inElements) {
        return 1L;
    }
}

